/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import me.fengming.vaultpatcher_asm.core.utils.ASMUtils;
import me.fengming.vaultpatcher_asm.core.utils.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassCache {
    private final ClassReader cr;
    private ClassNode clazz;
    private final Path hashFile;
    private boolean updated;

    public ClassCache(Path hashFile, Path classFile) throws IOException {
        this.hashFile = hashFile;
        this.cr = new ClassReader(Files.newInputStream(classFile, new OpenOption[0]));
    }

    private static String bytes2String(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getSha256(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes);
            return ClassCache.bytes2String(md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to hash", e);
        }
    }

    public boolean updated(ClassNode clazz) {
        ClassWriter cw1 = new ClassWriter(0);
        clazz.accept((ClassVisitor)cw1);
        String currentHash = ClassCache.getSha256(cw1.toByteArray());
        byte[] cacheHashBytes = new byte[64];
        try (InputStream fis = Files.newInputStream(this.hashFile, new OpenOption[0]);){
            fis.read(cacheHashBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read hash file", e);
        }
        String cacheHash = new String(cacheHashBytes, StandardCharsets.UTF_8);
        this.updated = currentHash.equals(cacheHash);
        if (!this.updated) {
            this.clazz = clazz;
            ClassCache.writeHash(currentHash, this.hashFile);
        } else {
            this.clazz = new ClassNode();
            this.cr.accept((ClassVisitor)this.clazz, 0);
        }
        return this.updated;
    }

    public void create(byte[] bytesToHash) throws IOException {
        this.updated = true;
        String currentHash = ClassCache.getSha256(bytesToHash);
        ClassCache.writeHash(currentHash, this.hashFile);
    }

    public ClassNode take() {
        return this.clazz;
    }

    public void put(ClassNode node, byte[] bytesToHash) {
        if (this.updated) {
            return;
        }
        this.clazz = node;
        ASMUtils.exportClass(node, Utils.mcPath.resolve("vaultpatcher").resolve("cache"));
        String hash = ClassCache.getSha256(bytesToHash);
        ClassCache.writeHash(hash, this.hashFile);
    }

    private static void writeHash(String hash, Path hashFile) {
        try {
            if (Files.notExists(hashFile, new LinkOption[0])) {
                Files.createDirectories(hashFile.getParent(), new FileAttribute[0]);
                Files.createFile(hashFile, new FileAttribute[0]);
            }
            try (OutputStream fos = Files.newOutputStream(hashFile, new OpenOption[0]);){
                fos.write(hash.getBytes(StandardCharsets.UTF_8));
                fos.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write hash file", e);
        }
    }
}

