/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.transformers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.DebugMode;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.TranslationInfo;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.cache.Caches;
import me.fengming.vaultpatcher_asm.core.cache.ClassCache;
import me.fengming.vaultpatcher_asm.core.node.NodeHandlerParameters;
import me.fengming.vaultpatcher_asm.core.node.handlers.NodeHandler;
import me.fengming.vaultpatcher_asm.core.transformers.VPClassLoader;
import me.fengming.vaultpatcher_asm.core.utils.ASMUtils;
import me.fengming.vaultpatcher_asm.core.utils.Utils;
import me.fengming.vaultpatcher_asm.plugin.VaultPatcherPlugin;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class VPClassTransformer
implements Consumer<ClassNode> {
    private final DebugMode debug = VaultPatcherConfig.getDebugMode();
    private final TranslationInfo translationInfo;
    private static boolean disableLocal = false;

    public VPClassTransformer(TranslationInfo info) {
        this.translationInfo = info;
        if (info != null) {
            VaultPatcher.debugInfo(String.format("[VaultPatcher] Loading VPTransformer for translation info: %s", info));
        }
    }

    private static void methodReplace(ClassNode input, TranslationInfo info) {
        boolean hasClinit = false;
        boolean isInterface = (input.access & 0x200) != 0;
        boolean needPatch = input.fields.stream().noneMatch(node -> node.name.equals("__vp_map"));
        for (MethodNode method : input.methods) {
            String methodName = info.getTargetClassInfo().getMethod();
            if ((Utils.isBlank(methodName) || methodName.equals(method.name)) && !method.name.equals("__vp_init") && !method.name.equals("__vp_replace")) {
                HashMap<Integer, String> localVariableMap = new HashMap<Integer, String>();
                boolean disableLocalVariable = true;
                if (!disableLocal && method.localVariables != null) {
                    disableLocalVariable = false;
                    method.localVariables.stream().filter(node -> node.desc.equals("Ljava/lang/String;")).forEach(node -> localVariableMap.put(node.index, node.name));
                }
                NodeHandlerParameters params = new NodeHandlerParameters(disableLocal, disableLocalVariable, input, method, localVariableMap, info);
                for (AbstractInsnNode instruction : method.instructions) {
                    params.addOrdinal();
                    NodeHandler<AbstractInsnNode> handler = NodeHandler.getHandlerByNode(instruction, params);
                    if (handler == null) continue;
                    instruction = handler.modifyNode();
                }
            }
            if (disableLocal || !needPatch || !method.name.equals("<clinit>")) continue;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/HashMap"));
            list.add((AbstractInsnNode)new InsnNode(89));
            Set<Map.Entry<String, String>> set = info.getPairs().getMap().entrySet();
            if (set.size() > 5) {
                list.add((AbstractInsnNode)new IntInsnNode(16, set.size()));
            } else {
                list.add((AbstractInsnNode)new InsnNode(3 + set.size()));
            }
            list.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/HashMap", "<init>", "(I)V", false));
            list.add((AbstractInsnNode)new FieldInsnNode(179, input.name, "__vp_map", "Ljava/util/HashMap;"));
            list.add((AbstractInsnNode)new MethodInsnNode(184, input.name, "__vp_init", "()V"));
            method.instructions.insertBefore(method.instructions.getLast(), list);
            hasClinit = true;
        }
        if (!disableLocal && needPatch) {
            VPClassTransformer.patchClass((ClassVisitor)input, input.name, info.getPairs().getMap().entrySet(), hasClinit, isInterface);
        }
    }

    private static void patchClass(ClassVisitor cv, String className, Set<Map.Entry<String, String>> set, boolean hasClinit, boolean isInterface) {
        Label label2;
        Label label1;
        Label label0;
        MethodVisitor mv;
        FieldVisitor fv = cv.visitField((isInterface ? 1 : 2) | 0x10 | 8, "__vp_map", "Ljava/util/HashMap;", "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/String;>;", null);
        fv.visitEnd();
        if (isInterface) {
            String innerClassName = className + "$vp_map";
            if (!hasClinit) {
                MethodVisitor mv2 = cv.visitMethod(8, "<clinit>", "()V", null, null);
                mv2.visitCode();
                Label label02 = new Label();
                mv2.visitLabel(label02);
                mv2.visitTypeInsn(187, innerClassName);
                mv2.visitInsn(89);
                if (set.size() > 5) {
                    mv2.visitIntInsn(16, set.size());
                } else {
                    mv2.visitInsn(3 + set.size());
                }
                mv2.visitMethodInsn(183, innerClassName, "<init>", "(I)V", false);
                mv2.visitFieldInsn(179, className, "__vp_map", "Ljava/util/HashMap;");
                Label label12 = new Label();
                mv2.visitLabel(label12);
                mv2.visitInsn(177);
                Label label22 = new Label();
                mv2.visitLabel(label22);
                mv2.visitMaxs(0, 0);
                mv2.visitEnd();
            }
            ClassWriter cw = new ClassWriter(2);
            cw.visit(52, 48, innerClassName, "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/String;>;", "java/util/HashMap", null);
            cw.visitSource("VaultPatcher_" + innerClassName, null);
            cw.visitOuterClass(className, null, null);
            cw.visitInnerClass(innerClassName, null, null, 8);
            MethodVisitor mv3 = cw.visitMethod(0, "<init>", "(I)V", null, null);
            mv3.visitCode();
            Label label03 = new Label();
            mv3.visitLabel(label03);
            mv3.visitVarInsn(25, 0);
            mv3.visitVarInsn(21, 1);
            mv3.visitMethodInsn(183, "java/util/HashMap", "<init>", "(I)V", false);
            Label label13 = new Label();
            mv3.visitLabel(label13);
            for (Map.Entry<String, String> entry : set) {
                mv3.visitVarInsn(25, 0);
                mv3.visitLdcInsn((Object)entry.getKey());
                mv3.visitLdcInsn((Object)entry.getValue());
                mv3.visitMethodInsn(182, innerClassName, "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv3.visitInsn(87);
            }
            Label label23 = new Label();
            mv3.visitLabel(label23);
            mv3.visitInsn(177);
            Label label3 = new Label();
            mv3.visitLabel(label3);
            mv3.visitLocalVariable("this", "L" + innerClassName + ";", null, label03, label3, 0);
            mv3.visitLocalVariable("x0", "I", null, label03, label3, 1);
            mv3.visitMaxs(3, 2);
            mv3.visitEnd();
            cw.visitEnd();
            byte[] bytes = cw.toByteArray();
            VPClassLoader.newClass(innerClassName, bytes);
        } else {
            if (!hasClinit) {
                mv = cv.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                label0 = new Label();
                mv.visitLabel(label0);
                mv.visitTypeInsn(187, "java/util/HashMap");
                mv.visitInsn(89);
                if (set.size() > 5) {
                    mv.visitIntInsn(16, set.size());
                } else {
                    mv.visitInsn(3 + set.size());
                }
                mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "(I)V", false);
                mv.visitFieldInsn(179, className, "__vp_map", "Ljava/util/HashMap;");
                label1 = new Label();
                mv.visitLabel(label1);
                mv.visitMethodInsn(184, className, "__vp_init", "()V", false);
                label2 = new Label();
                mv.visitLabel(label2);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            mv = cv.visitMethod(10, "__vp_init", "()V", null, null);
            mv.visitCode();
            label0 = new Label();
            mv.visitLabel(label0);
            for (Map.Entry<String, String> entry : set) {
                mv.visitFieldInsn(178, className, "__vp_map", "Ljava/util/HashMap;");
                mv.visitLdcInsn((Object)entry.getKey());
                mv.visitLdcInsn((Object)entry.getValue());
                mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitInsn(87);
            }
            label1 = new Label();
            mv.visitLabel(label1);
            mv.visitInsn(177);
            mv.visitMaxs(3, 0);
            mv.visitEnd();
        }
        mv = cv.visitMethod((isInterface ? 1 : 2) | 8, "__vp_replace", "(Ljava/lang/String;)Ljava/lang/String;", null, null);
        mv.visitCode();
        label0 = new Label();
        mv.visitLabel(label0);
        mv.visitFieldInsn(178, className, "__vp_map", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/util/HashMap", "getOrDefault", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitInsn(176);
        label1 = new Label();
        mv.visitLabel(label1);
        mv.visitLocalVariable("source", "Ljava/lang/String;", null, label0, label1, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cv.visitMethod((isInterface ? 1 : 2) | 8, "__vp_replace", "(Ljava/lang/Object;)Ljava/lang/String;", null, null);
        mv.visitCode();
        label0 = new Label();
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 0);
        label1 = new Label();
        mv.visitJumpInsn(199, label1);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(label1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitFieldInsn(178, className, "__vp_map", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/util/HashMap", "getOrDefault", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitInsn(176);
        label2 = new Label();
        mv.visitLabel(label2);
        mv.visitLocalVariable("source", "Ljava/lang/Object;", null, label0, label2, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private static void fieldReplace(ClassNode input, TranslationInfo info) {
        Pairs pairs = info.getPairs();
        for (FieldNode field : input.fields) {
            if (!(field.value instanceof String)) continue;
            String o = (String)field.value;
            String v = Utils.matchPairs(pairs, o, false);
            Utils.printDebugInfo(o, "ASMTransformField", v, input.name, info);
            field.value = v;
        }
    }

    @Override
    public void accept(ClassNode input) {
        VaultPatcher.plugins.forEach(e -> e.onTransformClass(input, VaultPatcherPlugin.Phase.BEFORE));
        if (VaultPatcherConfig.getDebugMode().isUseCache()) {
            ClassCache cache = Caches.getClassCache(input.name);
            byte[] copy = Utils.nodeToBytes(input);
            if (cache != null) {
                VaultPatcher.debugInfo("Using Cache: " + input.name);
                if (!cache.updated(input)) {
                    VaultPatcher.debugInfo("Updating Cache: " + input.name);
                    this.generate(input);
                    cache.put(input, copy);
                }
                ClassNode taken = cache.take();
                input.methods = taken.methods;
                input.fields = taken.fields;
                input.innerClasses = taken.innerClasses;
            } else {
                VaultPatcher.debugInfo("Generating Class Cache: " + input.name);
                this.generate(input);
                Caches.addClassCache(input.name, input, copy);
            }
        } else {
            this.generate(input);
        }
        VaultPatcher.plugins.forEach(e -> e.onTransformClass(input, VaultPatcherPlugin.Phase.AFTER));
        if (this.debug.isExportClass()) {
            ASMUtils.exportClass(input, Utils.mcPath.resolve("vaultpatcher").resolve("exported"));
        }
    }

    private void generate(ClassNode input) {
        if (this.translationInfo == null) {
            disableLocal = true;
            for (TranslationInfo info : Utils.translationInfos) {
                if (!Utils.isBlank(info.getTargetClassInfo().getName()) && !input.name.equals(Utils.rawPackage(info.getTargetClassInfo().getName()))) continue;
                VPClassTransformer.methodReplace(input, info);
                VPClassTransformer.fieldReplace(input, info);
            }
        } else if (Utils.isBlank(this.translationInfo.getTargetClassInfo().getName()) || input.name.equals(Utils.rawPackage(this.translationInfo.getTargetClassInfo().getName()))) {
            disableLocal = Utils.isBlank(this.translationInfo.getTargetClassInfo().getLocal());
            VPClassTransformer.methodReplace(input, this.translationInfo);
            VPClassTransformer.fieldReplace(input, this.translationInfo);
        }
    }
}

