/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.core.utils;

import cpw.mods.modlauncher.api.ITransformer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.DebugMode;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.TranslationInfo;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.plugin.VaultPatcherPlugin;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class Utils {
    public static final List<TranslationInfo> EMPTY_LIST = new ArrayList<TranslationInfo>();
    public static List<TranslationInfo> translationInfos = new ArrayList<TranslationInfo>();
    public static List<TranslationInfo> dynTranslationInfos = new ArrayList<TranslationInfo>();
    public static Path mcPath = null;
    public static String mcVersion = null;

    public static String getGameVersion() {
        return mcVersion == null ? "" : mcVersion;
    }

    public static Path getPluginConfigPath(VaultPatcherPlugin plugin) {
        return mcPath.resolve("config").resolve("vaultpatcher_asm").resolve("plugins").resolve(plugin.getName());
    }

    public static void printDebugInfo(int o, String s, String m, String ret, String c, TranslationInfo info) {
        DebugMode debug = VaultPatcherConfig.getDebugMode();
        if (!debug.isEnable()) {
            return;
        }
        String format = debug.getOutputFormat();
        VaultPatcher.LOGGER.info("[VaultPatcher] Trying replacing!");
        VaultPatcher.LOGGER.info(format.replace("<source>", s).replace("<target>", ret).replace("<method>", m).replace("<info>", info.toString()).replace("<class>", c).replace("<ordinal>", String.valueOf(o)));
    }

    public static void printDebugInfo(String s, String m, String ret, String c, TranslationInfo info) {
        DebugMode debug = VaultPatcherConfig.getDebugMode();
        if (!debug.isEnable()) {
            return;
        }
        String format = debug.getOutputFormat();
        VaultPatcher.LOGGER.info("[VaultPatcher] Trying replacing!");
        VaultPatcher.LOGGER.info(format.replace("<source>", s).replace("<target>", ret).replace("<method>", m).replace("<info>", info.toString()).replace("<class>", c).replace("<ordinal>", "Unknown"));
    }

    public static byte[] nodeToBytes(ClassNode node) {
        ClassWriter wr = new ClassWriter(0);
        node.accept((ClassVisitor)wr);
        return wr.toByteArray();
    }

    public static Set<ITransformer.Target> getTarget(TranslationInfo info) {
        HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
        if (info == null) {
            targets.addAll(Utils.getExpandTargets());
        } else {
            String name = info.getTargetClassInfo().getName();
            if (!Utils.isBlank(name)) {
                targets.add(ITransformer.Target.targetClass((String)Utils.rawPackage(name)));
            }
        }
        targets.iterator().forEachRemaining(t -> VaultPatcher.debugInfo(String.format("[VaultPatcher] VPClassTransformer Target = %s", t.getClassName())));
        return targets;
    }

    public static Set<ITransformer.Target> getExpandTargets() {
        HashSet<ITransformer.Target> targets = new HashSet<ITransformer.Target>();
        targets.addAll(VaultPatcherConfig.getApplyMods().stream().collect(ArrayList::new, (list, s) -> Utils.getClassesNameByJar(mcPath.resolve("mods").resolve(s + ".jar").toString()).forEach(s1 -> list.add(ITransformer.Target.targetClass((String)s1.substring(0, s1.length() - 6)))), ArrayList::addAll));
        targets.addAll(VaultPatcherConfig.getClasses().stream().collect(ArrayList::new, (list, s) -> list.add(ITransformer.Target.targetClass((String)Utils.rawPackage(s))), ArrayList::addAll));
        return targets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getClassesNameByJar(String jarPath) {
        try (JarFile jarFile = new JarFile(jarPath);){
            List<String> list = jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class")).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed loading jar: " + jarPath, e);
        }
    }

    public static String rawPackage(String s) {
        return s.replace('.', '/');
    }

    public static String matchPairs(Pairs p, String key, boolean dyn) {
        if (key.isEmpty()) {
            return key;
        }
        String v = key;
        if (dyn) {
            for (Map.Entry<String, String> entry : p.getMap().entrySet()) {
                String k1 = entry.getKey();
                String v1 = entry.getValue();
                if (key.equals(k1) && v1.charAt(0) != '@') {
                    v = v1;
                }
                if (v1.charAt(0) != '@' || !key.contains(k1)) continue;
                v = v.replace(k1, v1.substring(1));
            }
        } else {
            v = p.getValue(key);
        }
        return v == null ? key : v;
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return false;
        }
        if (s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.getBytes(StandardCharsets.UTF_8).length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

