/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.dummmmmmy.entity.TargetDummyEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static int ID;
    private static final String PROTOCOL_VERSION = "1";

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dummmmmmy", "dummychannel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(NetworkHandler.nextID(), PacketDamageNumber.class, PacketDamageNumber::toBytes, PacketDamageNumber::new, PacketDamageNumber::handle);
        INSTANCE.registerMessage(NetworkHandler.nextID(), PacketSyncEquip.class, PacketSyncEquip::toBytes, PacketSyncEquip::new, PacketSyncEquip::handle);
    }

    public static void sendToAllTracking(Entity entity, ServerLevel world, Message message) {
        world.m_7726_().m_8445_(entity, INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT));
    }

    static {
        ID = 0;
    }

    public static class PacketDamageNumber
    implements Message {
        private final int entityID;
        private final float shake;

        public PacketDamageNumber(FriendlyByteBuf buf) {
            this.entityID = buf.readInt();
            this.shake = buf.readFloat();
        }

        public PacketDamageNumber(int id, float shakeAmount) {
            this.entityID = id;
            this.shake = shakeAmount;
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeFloat(this.shake);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
                if (entity instanceof TargetDummyEntity) {
                    TargetDummyEntity dummy = (TargetDummyEntity)entity;
                    dummy.f_20925_ = this.shake;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PacketSyncEquip
    implements Message {
        private final int entityID;
        private final int slotId;
        private final ItemStack itemstack;

        public PacketSyncEquip(FriendlyByteBuf buf) {
            this.entityID = buf.readInt();
            this.slotId = buf.readInt();
            this.itemstack = buf.m_130267_();
        }

        public PacketSyncEquip(int entityId, int slotId, @Nonnull ItemStack itemstack) {
            this.entityID = entityId;
            this.slotId = slotId;
            this.itemstack = itemstack.m_41777_();
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeInt(this.slotId);
            buf.m_130055_(this.itemstack);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
                if (entity instanceof TargetDummyEntity) {
                    TargetDummyEntity dummy = (TargetDummyEntity)entity;
                    dummy.m_8061_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)this.slotId), this.itemstack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static interface Message {
    }
}

