/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public final class BookCategory
extends AbstractReadStateHolder
implements Comparable<BookCategory> {
    private final ResourceLocation id;
    private final String name;
    private final String description;
    private final BookIcon icon;
    @Nullable
    private final String parent;
    private final String flag;
    private final int sortnum;
    private final boolean secret;
    private final Book book;
    @Nullable
    private BookCategory parentCategory;
    private final List<BookCategory> children = new ArrayList<BookCategory>();
    private final List<BookEntry> entries = new ArrayList<BookEntry>();
    private boolean locked;
    private boolean built;

    public BookCategory(JsonObject root, ResourceLocation id, Book book) {
        this.book = book.isExtension ? book.extensionTarget : book;
        this.id = id;
        this.name = GsonHelper.m_13906_((JsonObject)root, (String)"name");
        this.description = GsonHelper.m_13906_((JsonObject)root, (String)"description");
        this.icon = BookIcon.from(GsonHelper.m_13906_((JsonObject)root, (String)"icon"));
        this.parent = GsonHelper.m_13851_((JsonObject)root, (String)"parent", null);
        this.flag = GsonHelper.m_13851_((JsonObject)root, (String)"flag", (String)"");
        this.sortnum = GsonHelper.m_13824_((JsonObject)root, (String)"sortnum", (int)0);
        this.secret = GsonHelper.m_13855_((JsonObject)root, (String)"secret", (boolean)false);
    }

    public MutableComponent getName() {
        return this.book.i18n ? new TranslatableComponent(this.name) : new TextComponent(this.name);
    }

    public String getDescription() {
        return this.description;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public void addEntry(BookEntry entry) {
        this.entries.add(entry);
    }

    public void addChildCategory(BookCategory category) {
        this.children.add(category);
    }

    public List<BookEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public BookCategory getParentCategory() {
        return this.parentCategory;
    }

    public void updateLockStatus(boolean rootOnly) {
        boolean wasLocked;
        block4: {
            if (rootOnly && !this.isRootCategory()) {
                return;
            }
            this.children.forEach(c -> c.updateLockStatus(false));
            wasLocked = this.locked;
            this.locked = !this.children.isEmpty() || !this.entries.isEmpty();
            for (BookCategory c2 : this.children) {
                if (c2.isLocked()) continue;
                this.locked = false;
                break block4;
            }
            for (BookEntry e : this.entries) {
                if (e.isLocked()) continue;
                this.locked = false;
                break;
            }
        }
        if (!this.locked && wasLocked) {
            this.book.markUpdated();
        }
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public boolean isLocked() {
        return this.getBook().advancementsEnabled() && this.locked;
    }

    public boolean isRootCategory() {
        return this.parent == null || this.parent.isEmpty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean canAdd() {
        return this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    @Override
    public int compareTo(BookCategory o) {
        if (this.book.advancementsEnabled() && o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        if (this.sortnum != o.sortnum) {
            return Integer.compare(this.sortnum, o.sortnum);
        }
        return this.getName().getString().compareTo(o.getName().getString());
    }

    public void build(BookContentsBuilder builder) {
        if (this.built) {
            return;
        }
        if (!this.isRootCategory()) {
            if (this.parent.contains(":")) {
                BookCategory parentCat = builder.getCategory(new ResourceLocation(this.parent));
                if (parentCat == null) {
                    String msg = String.format("Category %s specifies parent %s, but it could not be found", this.id, this.parent);
                    throw new RuntimeException(msg);
                }
                parentCat.addChildCategory(this);
                this.parentCategory = parentCat;
            } else {
                String hint = String.format("`%s:%s`", this.book.getModNamespace(), this.parent);
                throw new IllegalArgumentException("`parent` must be fully qualified (domain:name). Hint: Try " + hint);
            }
        }
        this.built = true;
    }

    public Book getBook() {
        return this.book;
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> entryStream = this.entries.stream().filter(e -> !e.isLocked()).map(AbstractReadStateHolder::getReadState);
        Stream<EntryDisplayState> childrenStream = this.children.stream().map(AbstractReadStateHolder::getReadState);
        return BookCategory.mostImportantState(Streams.concat((Stream[])new Stream[]{entryStream, childrenStream}));
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        if (this.parentCategory != null) {
            this.parentCategory.markReadStateDirty();
        } else {
            this.book.getContents().markReadStateDirty();
        }
    }
}

