/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.api.vertex.VertexWriter;
import com.jozufozu.flywheel.backend.gl.GlPrimitive;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedGlBuffer;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.backend.model.ModelAllocator;
import com.jozufozu.flywheel.core.model.Model;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL32;

public class ModelPool
implements ModelAllocator {
    protected final VertexType vertexType;
    private final List<PooledModel> models = new ArrayList<PooledModel>();
    private final List<PooledModel> pendingUpload = new ArrayList<PooledModel>();
    private final GlBuffer vbo;
    private int vertices;
    private boolean dirty;
    private boolean anyToRemove;

    public ModelPool(VertexType vertexType) {
        this.vertexType = vertexType;
        int stride = vertexType.getStride();
        this.vbo = new MappedGlBuffer(GlBufferType.ARRAY_BUFFER);
        this.vbo.bind();
        this.vbo.setGrowthMargin(stride * 64);
    }

    @Override
    public PooledModel alloc(Model model, ModelAllocator.Callback callback) {
        PooledModel bufferedModel = new PooledModel(model, this.vertices);
        bufferedModel.callback = callback;
        this.vertices += model.vertexCount();
        this.models.add(bufferedModel);
        this.pendingUpload.add(bufferedModel);
        this.setDirty();
        return bufferedModel;
    }

    public void flush() {
        if (this.dirty) {
            if (this.anyToRemove) {
                this.processDeletions();
            }
            this.vbo.bind();
            if (this.realloc()) {
                this.uploadAll();
            } else {
                this.uploadPending();
            }
            this.vbo.unbind();
            this.dirty = false;
            this.pendingUpload.clear();
        }
    }

    private void processDeletions() {
        this.models.removeIf(PooledModel::isDeleted);
        int vertices = 0;
        for (PooledModel model : this.models) {
            if (model.first != vertices) {
                this.pendingUpload.add(model);
            }
            model.first = vertices;
            vertices += model.getVertexCount();
        }
        this.vertices = vertices;
        this.anyToRemove = false;
    }

    private boolean realloc() {
        return this.vbo.ensureCapacity((long)this.vertices * (long)this.vertexType.getStride());
    }

    private void uploadAll() {
        try (MappedBuffer buffer = this.vbo.getBuffer();){
            VertexWriter writer = this.vertexType.createWriter(buffer.unwrap());
            int vertices = 0;
            for (PooledModel model : this.models) {
                model.first = vertices;
                this.buffer(writer, model);
                vertices += model.getVertexCount();
            }
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Error uploading pooled models:", (Throwable)e);
        }
    }

    private void uploadPending() {
        try (MappedBuffer buffer = this.vbo.getBuffer();){
            VertexWriter writer = this.vertexType.createWriter(buffer.unwrap());
            for (PooledModel model : this.pendingUpload) {
                this.buffer(writer, model);
            }
            this.pendingUpload.clear();
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Error uploading pooled models:", (Throwable)e);
        }
    }

    private void buffer(VertexWriter writer, PooledModel model) {
        writer.seekToVertex(model.first);
        writer.writeVertexList(model.model.getReader());
        if (model.callback != null) {
            model.callback.onAlloc(model);
        }
    }

    private void setDirty() {
        this.dirty = true;
    }

    public void delete() {
        this.vbo.delete();
    }

    public class PooledModel
    implements BufferedModel {
        private final ElementBuffer ebo;
        private ModelAllocator.Callback callback;
        private final Model model;
        private int first;
        private boolean remove;

        public PooledModel(Model model, int first) {
            this.model = model;
            this.first = first;
            this.ebo = model.createEBO();
        }

        @Override
        public VertexType getType() {
            return ModelPool.this.vertexType;
        }

        @Override
        public int getVertexCount() {
            return this.model.vertexCount();
        }

        @Override
        public void setupState(GlVertexArray vao) {
            ModelPool.this.vbo.bind();
            vao.enableArrays(this.getAttributeCount());
            vao.bindAttributes(0, ModelPool.this.vertexType.getLayout());
            this.ebo.bind();
        }

        @Override
        public void drawCall() {
            GL32.glDrawElementsBaseVertex((int)GlPrimitive.TRIANGLES.glEnum, (int)this.ebo.getElementCount(), (int)this.ebo.getEboIndexType().f_166923_, (long)0L, (int)this.first);
        }

        @Override
        public void drawInstances(int instanceCount) {
            if (!this.valid()) {
                return;
            }
            GL32.glDrawElementsInstancedBaseVertex((int)GlPrimitive.TRIANGLES.glEnum, (int)this.ebo.getElementCount(), (int)this.ebo.getEboIndexType().f_166923_, (long)0L, (int)instanceCount, (int)this.first);
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public void delete() {
            ModelPool.this.setDirty();
            ModelPool.this.anyToRemove = true;
            this.remove = true;
        }
    }
}

