/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.instancing;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GroupInstance<D extends InstanceData>
extends AbstractCollection<D> {
    final Instancer<D> model;
    final List<D> backing;

    public GroupInstance(Instancer<D> model) {
        this.model = model;
        this.backing = new ArrayList<D>();
    }

    public GroupInstance(Instancer<D> model, int size) {
        this.model = model;
        this.backing = new ArrayList<D>(size);
        for (int i = 0; i < size; ++i) {
            this.addInstance();
        }
    }

    public boolean resize(int count) {
        int size = this.size();
        if (count == size) {
            return false;
        }
        if (count <= 0) {
            this.clear();
            return size > 0;
        }
        if (count > size) {
            for (int i = size; i < count; ++i) {
                this.addInstance();
            }
        } else {
            List<D> unnecessary = this.backing.subList(count, size);
            unnecessary.forEach(InstanceData::delete);
            unnecessary.clear();
        }
        return true;
    }

    public InstanceData addInstance() {
        D instance = this.model.createInstance();
        this.backing.add(instance);
        return instance;
    }

    public D get(int index) {
        return (D)((InstanceData)this.backing.get(index));
    }

    @Override
    public Iterator<D> iterator() {
        return this.backing.iterator();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public void clear() {
        this.backing.forEach(InstanceData::delete);
        this.backing.clear();
    }
}

