/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.transform;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;

public interface Rotate<Self> {
    public Self multiply(Quaternion var1);

    default public Self rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return (Self)this;
        }
        return this.multiply(axis.m_122432_().m_122270_(radians));
    }

    default public Self rotate(double angle, Direction.Axis axis) {
        Vector3f vec = axis == Direction.Axis.X ? Vector3f.f_122223_ : (axis == Direction.Axis.Y ? Vector3f.f_122225_ : Vector3f.f_122227_);
        return this.multiply(vec, angle);
    }

    default public Self rotateX(double angle) {
        return this.multiply(Vector3f.f_122223_, angle);
    }

    default public Self rotateY(double angle) {
        return this.multiply(Vector3f.f_122225_, angle);
    }

    default public Self rotateZ(double angle) {
        return this.multiply(Vector3f.f_122227_, angle);
    }

    default public Self rotateXRadians(double angle) {
        return this.multiplyRadians(Vector3f.f_122223_, angle);
    }

    default public Self rotateYRadians(double angle) {
        return this.multiplyRadians(Vector3f.f_122225_, angle);
    }

    default public Self rotateZRadians(double angle) {
        return this.multiplyRadians(Vector3f.f_122227_, angle);
    }

    default public Self multiply(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(axis.m_122240_((float)angle));
    }

    default public Self multiplyRadians(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return (Self)this;
        }
        return this.multiply(axis.m_122270_((float)angle));
    }

    default public Self rotateToFace(Direction facing) {
        switch (facing) {
            case SOUTH: {
                this.multiply(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                this.multiply(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case NORTH: {
                this.multiply(Vector3f.f_122225_.m_122240_(0.0f));
                break;
            }
            case EAST: {
                this.multiply(Vector3f.f_122225_.m_122240_(270.0f));
                break;
            }
            case UP: {
                this.multiply(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case DOWN: {
                this.multiply(Vector3f.f_122222_.m_122240_(90.0f));
            }
        }
        return (Self)this;
    }
}

