/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MouseOverHelp {
    private static final int TEXT_MARGIN = 8;
    private final List<HelpRegion> helpRegions = new ArrayList<HelpRegion>();
    private final AbstractContainerScreen<?> screen;
    private boolean active = false;

    public MouseOverHelp(AbstractContainerScreen<?> screen) {
        this.screen = screen;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key, Predicate<AbstractContainerScreen<?>> showPredicate) {
        this.helpRegions.add(new HelpRegion(x1, y1, x2, y2, MiscUtil.wrapString(I18n.m_118938_((String)key, (Object[])new Object[0]), 35), showPredicate));
    }

    private void onMouseOver(PoseStack matrixStack, int mouseX, int mouseY) {
        HelpRegion region;
        if (this.active && (region = this.getRegionAt(mouseX, mouseY)) != null) {
            MouseOverHelp.showPopupBox(matrixStack, this.screen, Minecraft.m_91087_().f_91062_, region.extent, -1073741824, 1614872575, 0, null);
            MouseOverHelp.showPopupBox(matrixStack, this.screen, Minecraft.m_91087_().f_91062_, region.extent, -1073741824, -534765536, -2039584, region.text);
        }
    }

    private HelpRegion getRegionAt(int mouseX, int mouseY) {
        for (HelpRegion region : this.helpRegions) {
            if (!region.extent.m_110087_(mouseX, mouseY) || !region.showPredicate.test(this.screen)) continue;
            return region;
        }
        return null;
    }

    private static Rect2i calcBounds(AbstractContainerScreen<?> screen, Font fontRenderer, Rect2i rect, List<String> helpText) {
        if (helpText != null && !helpText.isEmpty()) {
            int boxWidth = 0;
            int n = helpText.size();
            Objects.requireNonNull(fontRenderer);
            int boxHeight = n * 9;
            for (String s : helpText) {
                boxWidth = Math.max(boxWidth, fontRenderer.m_92895_(s));
            }
            int xOff = rect.m_110085_() - screen.getGuiLeft() < screen.getXSize() / 2 ? rect.m_110090_() + 10 : -(boxWidth + 8 + 10);
            int yOff = (rect.m_110091_() - boxHeight - 8) / 2;
            return new Rect2i(rect.m_110085_() + xOff, rect.m_110086_() + yOff, boxWidth + 8, boxHeight + 8);
        }
        return rect;
    }

    private static void showPopupBox(PoseStack matrixStack, AbstractContainerScreen<?> screen, Font fontRenderer, Rect2i rect, int borderColor, int bgColor, int textColor, List<String> helpText) {
        Rect2i actualRect = MouseOverHelp.calcBounds(screen, fontRenderer, rect, helpText);
        int x1 = actualRect.m_110085_() - screen.getGuiLeft();
        int y1 = actualRect.m_110086_() - screen.getGuiTop();
        int x2 = x1 + actualRect.m_110090_();
        int y2 = y1 + actualRect.m_110091_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 300.0);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)bgColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)borderColor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x2, (int)y1, (int)(x2 + 1), (int)(y2 + 1), (int)borderColor);
        if (helpText != null) {
            for (String s : helpText) {
                fontRenderer.m_92883_(matrixStack, s, (float)x1 + 4.0f, (float)y1 + 4.0f, textColor);
                Objects.requireNonNull(fontRenderer);
                y1 += 9;
            }
        }
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public static void drawMouseOver(ContainerScreenEvent.DrawForeground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof IMouseOverHelpProvider) {
            IMouseOverHelpProvider provider = (IMouseOverHelpProvider)abstractContainerScreen;
            provider.getMouseOverHelp().onMouseOver(event.getPoseStack(), event.getMouseX(), event.getMouseY());
        }
    }

    public static class HelpRegion {
        final Rect2i extent;
        final List<String> text;
        final Predicate<AbstractContainerScreen<?>> showPredicate;
        static final Predicate<AbstractContainerScreen<?>> YES = guiContainer -> true;

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text) {
            this(x1, y1, x2, y2, text, YES);
        }

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text, Predicate<AbstractContainerScreen<?>> showPredicate) {
            this.extent = new Rect2i(x1, y1, x2 - x1, y2 - y1);
            this.text = text;
            this.showPredicate = showPredicate;
        }
    }

    public static class Button
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(192, 0);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(208, 0);

        public Button(int x, int y) {
            super(x, y, 16, 16, false, null);
            this.tooltip1.addAll(MiscUtil.wrapStringAsTextComponent(I18n.m_118938_((String)"modularrouters.guiText.tooltip.mouseOverHelp.false", (Object[])new Object[0])));
            this.tooltip2.addAll(MiscUtil.wrapStringAsTextComponent(I18n.m_118938_((String)"modularrouters.guiText.tooltip.mouseOverHelp.true", (Object[])new Object[0])));
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.toggle();
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public boolean sendToServer() {
            return false;
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

