/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public abstract class CamouflagingModel
implements IDynamicBakedModel {
    private final BakedModel baseModel;

    CamouflagingModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        if (state == null || !(state.m_60734_() instanceof BlockCamo)) {
            return this.baseModel.getQuads(state, side, rand, modelData);
        }
        BlockState camoState = (BlockState)modelData.getData(BlockCamo.CAMOUFLAGE_STATE);
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (layer == null) {
            layer = RenderType.m_110451_();
        }
        if (camoState == null && layer == RenderType.m_110451_()) {
            return this.baseModel.getQuads(state, side, rand, modelData);
        }
        if (camoState != null && ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(camoState);
            return model.getQuads(camoState, side, rand, modelData);
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    public boolean m_7547_() {
        return false;
    }

    static class TemplateFrameModel
    extends CamouflagingModel {
        TemplateFrameModel(BakedModel baseModel) {
            super(baseModel);
        }
    }

    static class RouterModel
    extends CamouflagingModel {
        RouterModel(BakedModel baseModel) {
            super(baseModel);
        }
    }
}

