/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.recipe;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModRecipes;
import me.desht.modularrouters.item.module.IPickaxeUser;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.crafting.MultiItemValue;
import org.apache.commons.lang3.Validate;

public abstract class PickaxeModuleRecipe
extends ShapelessRecipe {
    PickaxeModuleRecipe(ResourceLocation resourceLocation, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(resourceLocation, "", result, ingredients);
        Validate.isTrue((boolean)(result.m_41720_() instanceof IPickaxeUser), (String)("recipe " + resourceLocation + ": result is not a IPickaxeUser!"), (Object[])new Object[0]);
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!super.m_5818_(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!PickaxeModuleRecipe.isValidPickaxe(stack) && !(stack.m_41720_() instanceof IPickaxeUser)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack pick = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (PickaxeModuleRecipe.isValidPickaxe(stack)) {
                pick = stack;
                break;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof IPickaxeUser)) continue;
            IPickaxeUser pickaxeUser = (IPickaxeUser)item;
            pick = pickaxeUser.getPickaxe(stack);
            break;
        }
        if (!pick.m_41619_()) {
            ItemStack result = super.m_5874_(inv);
            return ((IPickaxeUser)result.m_41720_()).setPickaxe(result, pick);
        }
        return ItemStack.f_41583_;
    }

    private static boolean isValidPickaxe(ItemStack stack) {
        return stack != null && stack.m_41720_().canPerformAction(stack, ToolActions.PICKAXE_DIG) && stack.m_41773_() == 0;
    }

    private static class PickaxeIngredient
    extends Ingredient {
        PickaxeIngredient() {
            super(Stream.of(new MultiItemValue((Collection)ImmutableList.of((Object)new ItemStack((ItemLike)Items.f_42422_), (Object)new ItemStack((ItemLike)Items.f_42427_), (Object)new ItemStack((ItemLike)Items.f_42385_), (Object)new ItemStack((ItemLike)Items.f_42390_), (Object)new ItemStack((ItemLike)Items.f_42395_)))));
        }

        public boolean test(@Nullable ItemStack stack) {
            return PickaxeModuleRecipe.isValidPickaxe(stack);
        }
    }

    public static class ExtruderModule1Recipe
    extends PickaxeModuleRecipe {
        public ExtruderModule1Recipe(ResourceLocation resourceLocation) {
            super(resourceLocation, new ItemStack((ItemLike)ModItems.EXTRUDER_MODULE_1.get()), ExtruderModule1Recipe.ingredients());
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_MODULE.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PLACER_MODULE.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BREAKER_MODULE.get()})});
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)ModRecipes.EXTRUDER_MODULE_1.get();
        }
    }

    public static class BreakerModuleRecipe
    extends PickaxeModuleRecipe {
        public BreakerModuleRecipe(ResourceLocation resourceLocation) {
            super(resourceLocation, new ItemStack((ItemLike)ModItems.BREAKER_MODULE.get()), BreakerModuleRecipe.ingredients());
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_MODULE.get()}), new PickaxeIngredient()});
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)ModRecipes.BREAKER_MODULE.get();
        }
    }
}

