/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.creeperhost.ftbbackups.BackupHandler;
import net.creeperhost.ftbbackups.commands.BackupCommand;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.org.quartz.CronExpression;
import net.creeperhost.ftbbackups.org.quartz.CronScheduleBuilder;
import net.creeperhost.ftbbackups.org.quartz.CronTrigger;
import net.creeperhost.ftbbackups.org.quartz.Job;
import net.creeperhost.ftbbackups.org.quartz.JobBuilder;
import net.creeperhost.ftbbackups.org.quartz.JobDetail;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionContext;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionException;
import net.creeperhost.ftbbackups.org.quartz.Scheduler;
import net.creeperhost.ftbbackups.org.quartz.TriggerBuilder;
import net.creeperhost.ftbbackups.org.quartz.impl.StdSchedulerFactory;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBBackups {
    public static final String MOD_ID = "ftbbackups2";
    public static Logger LOGGER = LogManager.getLogger();
    public static Path configFile = Platform.getConfigFolder().resolve("ftbbackups2.json");
    public static ScheduledExecutorService configWatcherExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FTB Backups Config Watcher %d").setDaemon(true).build());
    public static ScheduledExecutorService backupCleanerWatcherExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("FTB Backups scheduled executor %d").setDaemon(true).build());
    public static ExecutorService backupExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("FTB Backups backup thread %d").setDaemon(true).build());
    public static MinecraftServer minecraftServer;
    public static Scheduler scheduler;
    public static boolean isShutdown;

    public static void init() {
        Config.init(configFile.toFile());
        CommandRegistrationEvent.EVENT.register(FTBBackups::onCommandRegisterEvent);
        LifecycleEvent.SERVER_STARTED.register(FTBBackups::serverStartedEvent);
        LifecycleEvent.SERVER_STOPPED.register(instance -> FTBBackups.killOutThreads());
        LifecycleEvent.SERVER_LEVEL_SAVE.register(FTBBackups::serverSaveEvent);
        Runtime.getRuntime().addShutdownHook(new Thread(FTBBackups::killOutThreads));
    }

    public static void serverSaveEvent(ServerLevel serverLevel) {
        if (serverLevel == null || serverLevel.f_46443_) {
            return;
        }
        BackupHandler.isDirty = serverLevel.m_142572_().m_7416_() > 0;
    }

    private static void serverStartedEvent(MinecraftServer minecraftServer) {
        FTBBackups.minecraftServer = minecraftServer;
        BackupHandler.init(minecraftServer);
        isShutdown = false;
        if (Config.cached().enabled) {
            if (!CronExpression.isValidExpression(Config.cached().backup_cron)) {
                LOGGER.error("backup_cron is invalid, restoring default value");
                Config.cached().backup_cron = "0 */30 * * * ?";
                Config.saveConfig();
            }
            try {
                JobDetail jobDetail = JobBuilder.newJob(BackupJob.class).withIdentity(MOD_ID).build();
                Properties properties = new Properties();
                properties.put("net.creeperhost.ftbbackups.org.quartz.scheduler.instanceName", MOD_ID);
                properties.put("net.creeperhost.ftbbackups.org.quartz.threadPool.threadCount", "1");
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
                scheduler = schedulerFactory.getScheduler();
                CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity(MOD_ID).withSchedule(CronScheduleBuilder.cronSchedule(Config.cached().backup_cron)).build();
                scheduler.start();
                scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void killOutThreads() {
        try {
            int shutdownCount = 0;
            isShutdown = true;
            while (BackupHandler.isRunning() && shutdownCount <= 120) {
                try {
                    if (shutdownCount % 10 == 0) {
                        LOGGER.info("Backup in progress, Waiting for it to finish before shutting down.");
                    }
                    Thread.sleep(1000L);
                    ++shutdownCount;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (scheduler != null && !scheduler.isShutdown()) {
                scheduler.clear();
                LOGGER.info("Shutting down scheduler thread");
                scheduler.shutdown(false);
            }
            Config.watcher.get().close();
            if (!configWatcherExecutorService.isShutdown()) {
                LOGGER.info("Shutting down the config watcher executor");
                configWatcherExecutorService.shutdownNow();
            }
            if (!backupCleanerWatcherExecutorService.isShutdown()) {
                LOGGER.info("Shutting down backup cleaning executor");
                backupCleanerWatcherExecutorService.shutdownNow();
            }
            if (!backupExecutor.isShutdown()) {
                LOGGER.info("Shutting down backup executor");
                backupExecutor.shutdownNow();
            }
            BackupHandler.backupRunning.set(false);
            LOGGER.info("=========Checking everything is shut down============");
            LOGGER.info("Scheduler Shutdown:{}", (Object)scheduler.isShutdown());
            LOGGER.info("Config watcher Shutdown:{}", (Object)configWatcherExecutorService.isShutdown());
            LOGGER.info("Cleaner watcher Shutdown:{}", (Object)backupCleanerWatcherExecutorService.isShutdown());
            LOGGER.info("Backup Executor Shutdown:{}", (Object)backupExecutor.isShutdown());
            LOGGER.info("========Shutdown completed, FTB Backups has now finished shutting down==========");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onCommandRegisterEvent(CommandDispatcher<CommandSourceStack> cs, Commands.CommandSelection commandSelection) {
        cs.register(BackupCommand.register());
    }

    static {
        isShutdown = false;
    }

    public static class BackupJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            if (minecraftServer != null) {
                LOGGER.info("Attempting to create an automatic backup");
                BackupHandler.createBackup(minecraftServer);
            }
        }
    }
}

