/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class BlockState {
    Map<String, Map<String, Integer>> states;

    private BlockState() {
    }

    public BlockState(Map<String, Map<String, Integer>> states) {
        this.states = Objects.requireNonNull(states);
    }

    public int getProperty(String key, String value) {
        return (Integer)this.states.getOrDefault(key, Collections.emptyMap()).get(value);
    }

    public BitSet getState(Map<String, String> properties) {
        BitSet state = new BitSet(this.states.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            state.set(this.getProperty(entry.getKey(), entry.getValue()));
        }
        return state;
    }

    public int getSize() {
        return this.states.size();
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockState other = (BlockState)obj;
        return Objects.equals(this.states, other.states);
    }
}

