/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_13;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_14;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_15;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_16;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_17;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer_1_18;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ChunkMetadata;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.Region;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.Chunk;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.RegionFile;
import net.creeperhost.ftbbackups.de.piegames.nbt.stream.NBTInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionRenderer {
    private static Logger log = LogManager.getLogger(RegionRenderer.class);
    public final RenderSettings settings;
    private final ChunkRenderer renderer13;
    private final ChunkRenderer renderer14;
    private final ChunkRenderer renderer15;
    private final ChunkRenderer renderer16;
    private final ChunkRenderer renderer17;
    private final ChunkRenderer renderer18;

    public RegionRenderer(RenderSettings settings) {
        this.settings = Objects.requireNonNull(settings);
        this.renderer13 = new ChunkRenderer_1_13(settings);
        this.renderer14 = new ChunkRenderer_1_14(settings);
        this.renderer15 = new ChunkRenderer_1_15(settings);
        this.renderer16 = new ChunkRenderer_1_16(settings);
        this.renderer17 = new ChunkRenderer_1_17(settings);
        this.renderer18 = new ChunkRenderer_1_18(settings);
    }

    public Region render(Vector2ic regionPos, RegionFile file) {
        log.info("Rendering region file " + regionPos.x() + " " + regionPos.y());
        BufferedImage image = new BufferedImage(512, 512, 2);
        HashMap<Vector2ic, ChunkMetadata> metadata = new HashMap<Vector2ic, ChunkMetadata>();
        Color[] colors = this.renderRaw(regionPos, file, metadata);
        for (int x = 0; x < 512; ++x) {
            for (int z = 0; z < 512; ++z) {
                if (colors[x | z << 9] == null) continue;
                image.setRGB(x, z, colors[x | z << 9].toRGB());
            }
        }
        return new Region(regionPos, image, metadata);
    }

    protected Color[] renderRaw(Vector2ic regionPos, RegionFile file, Map<Vector2ic, ChunkMetadata> metadata) {
        Color[] map = new Color[262144];
        int[] height = new int[262144];
        String[] regionBiomes = new String[262144];
        Arrays.fill(height, this.settings.minY);
        for (int chunkIndex : file.listChunks()) {
            CompoundTag root;
            Vector2i chunkPos;
            Chunk chunk = null;
            try {
                chunk = file.loadChunk(chunkIndex);
            }
            catch (ClosedByInterruptException e) {
                log.info("Got interrupted while rendering, stopping");
                break;
            }
            catch (IOException | RuntimeException e) {
                int x = chunkIndex & 0xF;
                int z = chunkIndex >> 4;
                log.warn("Failed to load chunk (" + x + ", " + z + ")", (Throwable)e);
                chunkPos = new Vector2i(regionPos.x() << 5 | x, regionPos.y() << 5 | z);
                metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataFailed(chunkPos, e));
                continue;
            }
            int chunkX = regionPos.x() << 5 | chunk.x;
            int chunkZ = regionPos.y() << 5 | chunk.z;
            Vector2i chunkPosRegion = new Vector2i(chunk.x, chunk.z);
            chunkPos = new Vector2i(chunkX, chunkZ);
            if (!((chunkX << 4) + 16 >= this.settings.minX && chunkX << 4 <= this.settings.maxX || (chunkZ << 4) + 16 >= this.settings.minZ && chunkZ << 4 <= this.settings.maxZ)) {
                metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataCulled(chunkPos));
                continue;
            }
            try (NBTInputStream nbtIn = new NBTInputStream((InputStream)new ByteArrayInputStream(chunk.getData().array(), 5, chunk.getRealLength()), (int)chunk.getCompression(), true);){
                root = new CompoundTag("chunk", ((CompoundTag)nbtIn.readTag()).getValue());
            }
            catch (IOException | RuntimeException e) {
                log.warn("Failed to load chunk " + chunkPosRegion, (Throwable)e);
                metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataFailed(chunkPos, e));
                continue;
            }
            try {
                Optional<Integer> dataVersion = root.getAsIntTag("DataVersion").map(Tag::getValue);
                if (dataVersion.isPresent()) {
                    CompoundTag level;
                    int version = dataVersion.get();
                    if (version < MinecraftVersion.MC_1_13.minVersion) {
                        log.warn("Skipping chunk because it is too old (before Minecraft 1.13)");
                        metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataVersion(chunkPos, "This chunk was written from Minecraft <1.13, which is not supported", version));
                        continue;
                    }
                    if (version <= MinecraftVersion.MC_1_13.maxVersion) {
                        level = root.getAsCompoundTag("Level").get();
                        metadata.put(chunkPos, this.renderer13.renderChunk(chunkPosRegion, chunkPos, level, map, height, regionBiomes));
                        continue;
                    }
                    if (version >= MinecraftVersion.MC_1_14.minVersion && version <= MinecraftVersion.MC_1_14.maxVersion) {
                        level = root.getAsCompoundTag("Level").get();
                        metadata.put(chunkPos, this.renderer14.renderChunk(chunkPosRegion, chunkPos, level, map, height, regionBiomes));
                        continue;
                    }
                    if (version >= MinecraftVersion.MC_1_15.minVersion && version <= MinecraftVersion.MC_1_15.maxVersion) {
                        level = root.getAsCompoundTag("Level").get();
                        metadata.put(chunkPos, this.renderer15.renderChunk(chunkPosRegion, chunkPos, level, map, height, regionBiomes));
                        continue;
                    }
                    if (version >= MinecraftVersion.MC_1_16.minVersion && version <= MinecraftVersion.MC_1_16.maxVersion) {
                        level = root.getAsCompoundTag("Level").get();
                        metadata.put(chunkPos, this.renderer16.renderChunk(chunkPosRegion, chunkPos, level, map, height, regionBiomes));
                        continue;
                    }
                    if (version >= MinecraftVersion.MC_1_17.minVersion && version <= MinecraftVersion.MC_1_17.maxVersion) {
                        level = root.getAsCompoundTag("Level").get();
                        metadata.put(chunkPos, this.renderer17.renderChunk(chunkPosRegion, chunkPos, level, map, height, regionBiomes));
                        continue;
                    }
                    if (version >= MinecraftVersion.MC_1_18.minVersion && version <= MinecraftVersion.MC_1_18.maxVersion) {
                        metadata.put(chunkPos, this.renderer18.renderChunk(chunkPosRegion, chunkPos, root, map, height, regionBiomes));
                        continue;
                    }
                    log.warn("Could not render chunk with Minecraft format version " + version);
                    metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataVersion(chunkPos, "Could not find a chunk rendering engine for this version", version));
                    continue;
                }
                log.warn("Skipping chunk because it is way too old (pre 1.9)");
                metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataVersion(chunkPos, "This chunk was written from Minecraft <1.9, which is not supported", 0));
            }
            catch (RuntimeException e) {
                metadata.put(chunkPos, new ChunkMetadata.ChunkMetadataFailed(chunkPos, e));
            }
        }
        this.settings.regionShader.shade(map, height, regionBiomes, this.settings.biomeColors);
        return map;
    }
}

