/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson.NullableTypeAdapter;

public final class EnumDefaultValueTypeAdapterFactory<T extends Enum>
implements TypeAdapterFactory {
    private final Class<T> clazz;
    private final T defaultValue;

    public EnumDefaultValueTypeAdapterFactory(Class<T> clazz, T defaultValue) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.clazz.isAssignableFrom(type.getRawType())) {
            final TypeAdapter originalTypeAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new NullableTypeAdapter(new TypeAdapter<T>(){

                public void write(JsonWriter jsonWriter, T o) throws IOException {
                    originalTypeAdapter.write(jsonWriter, o);
                }

                public T read(JsonReader jsonReader) throws IOException {
                    Object result = originalTypeAdapter.read(jsonReader);
                    if (result == null) {
                        return EnumDefaultValueTypeAdapterFactory.this.defaultValue;
                    }
                    return result;
                }
            });
        }
        return null;
    }
}

