/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.standalone;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.RegionFolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostProcessing {
    private static Logger log = LogManager.getLogger(PostProcessing.class);

    private PostProcessing() {
    }

    public static int createTileHtml(RegionFolder.LocalRegionFolder world, Path outputDir, RenderSettings settings) {
        Set allowedBlocks;
        log.info("Writing HTML tiles...");
        if (world.listRegions().isEmpty()) {
            log.warn("The world is empty, there is nothing to do!");
            return 0;
        }
        Path cssFile = outputDir.resolve("tiles.css");
        if (!Files.exists(cssFile, new LinkOption[0])) {
            try (InputStream cssInputStream = PostProcessing.class.getResourceAsStream("tiles.css");){
                Files.copy(cssInputStream, cssFile, new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Could not copy style sheet file", (Throwable)e);
                return 1;
            }
        }
        if ((allowedBlocks = world.listRegions().stream().filter(v -> PostProcessing.inBounds(v.x(), settings.minX, settings.maxX) && PostProcessing.inBounds(v.y(), settings.minZ, settings.maxZ)).collect(Collectors.toSet())).isEmpty()) {
            log.warn("No chunks selected, please increase your bounds");
            return 2;
        }
        int minX = allowedBlocks.stream().mapToInt(v -> v.x()).min().getAsInt();
        int maxX = allowedBlocks.stream().mapToInt(v -> v.x()).max().getAsInt();
        int minZ = allowedBlocks.stream().mapToInt(v -> v.y()).min().getAsInt();
        int maxZ = allowedBlocks.stream().mapToInt(v -> v.y()).max().getAsInt();
        try (BufferedWriter w = Files.newBufferedWriter(outputDir.resolve("tiles.html"), new OpenOption[0]);){
            w.write("<html><head>\n");
            w.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"tiles.css\"/>\n");
            w.write("</head><body>\n");
            w.write("<div style=\"height: " + (maxZ - minZ + 1) * 512 + "px\">");
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    Vector2i pos = new Vector2i(x, z);
                    Path region = world.getPath(pos);
                    if (region == null) continue;
                    int top = (z - minZ) * 512;
                    int left = (x - minX) * 512;
                    String title = "Region " + x + ", " + z;
                    String name = "r." + x + "." + z;
                    String style = "width: 512px; height: 512px; position: absolute; top: " + top + "px; left: " + left + "px; background-image: url(" + outputDir.relativize(region) + ")";
                    w.write("<a\n\tclass=\"tile\"\n\tstyle=\"" + style + "\"\n\ttitle=\"" + title + "\"\n\tname=\"" + name + "\"\n\thref=\"" + outputDir.relativize(region) + "\"\n>&nbsp;</a>");
                }
            }
            w.write("</div>\n");
            w.write("<p class=\"notes\">");
            w.write("Page rendered at " + new Date().toString());
            w.write("</p>\n");
            w.write("</body></html>");
        }
        catch (IOException e) {
            log.error("Could not write html file", (Throwable)e);
        }
        return 0;
    }

    public static int createBigImage(RegionFolder world, Path outputDir, RenderSettings settings) {
        log.info("Creating big image...");
        if (world.listRegions().isEmpty()) {
            log.warn("The world is empty, there is nothing to do!");
            return 0;
        }
        Set allowedBlocks = world.listRegions().stream().filter(v -> PostProcessing.inBounds(v.x(), settings.minX, settings.maxX) && PostProcessing.inBounds(v.y(), settings.minZ, settings.maxZ)).collect(Collectors.toSet());
        if (allowedBlocks.isEmpty()) {
            log.warn("No chunks selected, please increase your bounds");
            return 2;
        }
        int minX = allowedBlocks.stream().mapToInt(v -> v.x()).min().getAsInt();
        int maxX = allowedBlocks.stream().mapToInt(v -> v.x()).max().getAsInt();
        int minZ = allowedBlocks.stream().mapToInt(v -> v.y()).min().getAsInt();
        int maxZ = allowedBlocks.stream().mapToInt(v -> v.y()).max().getAsInt();
        int minPixelX = minX << 9 < settings.minX ? settings.minX : minX << 9;
        int maxPixelX = (maxX << 9) + 512 > settings.maxX ? settings.maxX : (maxX << 9) + 512;
        int minPixelZ = minZ << 9 < settings.minZ ? settings.minZ : minZ << 9;
        int maxPixelZ = (maxZ << 9) + 512 > settings.maxZ ? settings.maxZ : (maxZ << 9) + 512;
        int width = maxPixelX - minPixelX;
        int height = maxPixelZ - minPixelZ;
        log.debug("Dimension: " + width + ", " + height);
        BufferedImage bigImage = null;
        try {
            bigImage = new BufferedImage(width, height, 2);
        }
        catch (Throwable t) {
            log.error("Could not create image, is it too big?", t);
            return 1;
        }
        for (Vector2ic pos : world.listRegions()) {
            BufferedImage region = null;
            try {
                region = world.render(pos).getImage();
            }
            catch (IOException e) {
                log.warn("Could not load image " + pos, (Throwable)e);
                continue;
            }
            bigImage.createGraphics().drawImage((Image)region, pos.x() * 512 - minPixelX, pos.y() * 512 - minPixelZ, null);
            log.debug("Region " + pos.x() + ", " + pos.y() + " drawn to " + (pos.x() * 512 - minPixelX) + ", " + (pos.y() * 512 - minPixelZ));
        }
        try {
            ImageIO.write((RenderedImage)bigImage, "png", new File(outputDir + "/big.png"));
        }
        catch (IOException e) {
            log.error("Could not write big image to " + outputDir + "/big.png", (Throwable)e);
        }
        return 0;
    }

    public static boolean inBounds(int region, int min, int max) {
        return min >> 9 <= region && region <= max >> 9;
    }
}

