/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.Arrays;
import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public class LongArrayTag
extends Tag<long[]> {
    private long[] value;

    public LongArrayTag(String name, long[] value) {
        super(TagType.TAG_LONG_ARRAY, name);
        this.value = value;
    }

    @Override
    public long[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(long[] value) {
        this.value = value;
    }

    @Override
    public Optional<LongArrayTag> getAsLongArrayTag() {
        return Optional.of(this);
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        for (long s : this.value) {
            String hexDigits = Long.toHexString(s).toUpperCase();
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Long_Array" + append + ": " + hex.toString();
    }

    @Override
    public LongArrayTag clone() {
        long[] clonedArray = this.cloneArray(this.value);
        return new LongArrayTag(this.getName(), clonedArray);
    }

    private long[] cloneArray(long[] longArray) {
        if (longArray == null) {
            return null;
        }
        int length = longArray.length;
        byte[] newArray = new byte[length];
        System.arraycopy(longArray, 0, newArray, 0, length);
        return longArray;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongArrayTag other = (LongArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

