/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.org.quartz.listeners;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionContext;
import net.creeperhost.ftbbackups.org.quartz.JobExecutionException;
import net.creeperhost.ftbbackups.org.quartz.JobListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastJobListener
implements JobListener {
    private String name;
    private List<JobListener> listeners;

    public BroadcastJobListener(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = name;
        this.listeners = new LinkedList<JobListener>();
    }

    public BroadcastJobListener(String name, List<JobListener> listeners) {
        this(name);
        this.listeners.addAll(listeners);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addListener(JobListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(JobListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeListener(String listenerName) {
        Iterator<JobListener> itr = this.listeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = itr.next();
            if (!jl.getName().equals(listenerName)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public List<JobListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
        for (JobListener jl : this.listeners) {
            jl.jobToBeExecuted(context);
        }
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        for (JobListener jl : this.listeners) {
            jl.jobExecutionVetoed(context);
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        for (JobListener jl : this.listeners) {
            jl.jobWasExecuted(context, jobException);
        }
    }
}

