/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class BitmapProvider
implements GlyphProvider {
    static final Logger f_95328_ = LogUtils.getLogger();
    private final NativeImage f_95329_;
    private final Int2ObjectMap<Glyph> f_95330_;

    BitmapProvider(NativeImage p_95333_, Int2ObjectMap<Glyph> p_95334_) {
        this.f_95329_ = p_95333_;
        this.f_95330_ = p_95334_;
    }

    @Override
    public void close() {
        this.f_95329_.close();
    }

    @Override
    @Nullable
    public RawGlyph m_7823_(int p_95341_) {
        return (RawGlyph)this.f_95330_.get(p_95341_);
    }

    @Override
    public IntSet m_6990_() {
        return IntSets.unmodifiable((IntSet)this.f_95330_.keySet());
    }

    static final class Glyph
    implements RawGlyph {
        private final float f_95363_;
        private final NativeImage f_95364_;
        private final int f_95365_;
        private final int f_95366_;
        private final int f_95367_;
        private final int f_95368_;
        private final int f_95369_;
        private final int f_95370_;

        Glyph(float p_95372_, NativeImage p_95373_, int p_95374_, int p_95375_, int p_95376_, int p_95377_, int p_95378_, int p_95379_) {
            this.f_95363_ = p_95372_;
            this.f_95364_ = p_95373_;
            this.f_95365_ = p_95374_;
            this.f_95366_ = p_95375_;
            this.f_95367_ = p_95376_;
            this.f_95368_ = p_95377_;
            this.f_95369_ = p_95378_;
            this.f_95370_ = p_95379_;
        }

        @Override
        public float m_5621_() {
            return 1.0f / this.f_95363_;
        }

        @Override
        public int m_5631_() {
            return this.f_95367_;
        }

        @Override
        public int m_5629_() {
            return this.f_95368_;
        }

        @Override
        public float m_7403_() {
            return this.f_95369_;
        }

        @Override
        public float m_142672_() {
            return RawGlyph.super.m_142672_() + 7.0f - (float)this.f_95370_;
        }

        @Override
        public void m_6238_(int p_95391_, int p_95392_) {
            this.f_95364_.m_85003_(0, p_95391_, p_95392_, this.f_95365_, this.f_95366_, this.f_95367_, this.f_95368_, false, false);
        }

        @Override
        public boolean m_5633_() {
            return this.f_95364_.m_85102_().m_85161_() > 1;
        }
    }

    public static class Builder
    implements GlyphProviderBuilder {
        private final ResourceLocation f_95344_;
        private final List<int[]> f_95345_;
        private final int f_95346_;
        private final int f_95347_;

        public Builder(ResourceLocation p_95349_, int p_95350_, int p_95351_, List<int[]> p_95352_) {
            this.f_95344_ = new ResourceLocation(p_95349_.m_135827_(), "textures/" + p_95349_.m_135815_());
            this.f_95345_ = p_95352_;
            this.f_95346_ = p_95350_;
            this.f_95347_ = p_95351_;
        }

        public static Builder m_95355_(JsonObject p_95356_) {
            int $$1 = GsonHelper.m_13824_(p_95356_, "height", 8);
            int $$2 = GsonHelper.m_13927_(p_95356_, "ascent");
            if ($$2 > $$1) {
                throw new JsonParseException("Ascent " + $$2 + " higher than height " + $$1);
            }
            ArrayList $$3 = Lists.newArrayList();
            JsonArray $$4 = GsonHelper.m_13933_(p_95356_, "chars");
            for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                int $$8;
                String $$6 = GsonHelper.m_13805_($$4.get($$5), "chars[" + $$5 + "]");
                int[] $$7 = $$6.codePoints().toArray();
                if ($$5 > 0 && $$7.length != ($$8 = ((int[])$$3.get(0)).length)) {
                    throw new JsonParseException("Elements of chars have to be the same length (found: " + $$7.length + ", expected: " + $$8 + "), pad with space or \\u0000");
                }
                $$3.add($$7);
            }
            if ($$3.isEmpty() || ((int[])$$3.get(0)).length == 0) {
                throw new JsonParseException("Expected to find data in chars, found none.");
            }
            return new Builder(new ResourceLocation(GsonHelper.m_13906_(p_95356_, "file")), $$1, $$2, $$3);
        }

        @Override
        @Nullable
        public GlyphProvider m_6762_(ResourceManager p_95354_) {
            BitmapProvider bitmapProvider;
            block10: {
                Resource $$1 = p_95354_.m_142591_(this.f_95344_);
                try {
                    NativeImage $$2 = NativeImage.m_85048_(NativeImage.Format.RGBA, $$1.m_6679_());
                    int $$3 = $$2.m_84982_();
                    int $$4 = $$2.m_85084_();
                    int $$5 = $$3 / this.f_95345_.get(0).length;
                    int $$6 = $$4 / this.f_95345_.size();
                    float $$7 = (float)this.f_95346_ / (float)$$6;
                    Int2ObjectOpenHashMap $$8 = new Int2ObjectOpenHashMap();
                    for (int $$9 = 0; $$9 < this.f_95345_.size(); ++$$9) {
                        int $$10 = 0;
                        for (int $$11 : this.f_95345_.get($$9)) {
                            int $$13;
                            Glyph $$14;
                            int $$12 = $$10++;
                            if ($$11 == 0 || $$11 == 32 || ($$14 = (Glyph)$$8.put($$11, (Object)new Glyph($$7, $$2, $$12 * $$5, $$9 * $$6, $$5, $$6, (int)(0.5 + (double)((float)($$13 = this.m_95357_($$2, $$5, $$6, $$12, $$9)) * $$7)) + 1, this.f_95347_))) == null) continue;
                            f_95328_.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString($$11), (Object)this.f_95344_);
                        }
                    }
                    bitmapProvider = new BitmapProvider($$2, (Int2ObjectMap<Glyph>)$$8);
                    if ($$1 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if ($$1 != null) {
                            try {
                                $$1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException $$15) {
                        throw new RuntimeException($$15.getMessage());
                    }
                }
                $$1.close();
            }
            return bitmapProvider;
        }

        private int m_95357_(NativeImage p_95358_, int p_95359_, int p_95360_, int p_95361_, int p_95362_) {
            int $$5;
            for ($$5 = p_95359_ - 1; $$5 >= 0; --$$5) {
                int $$6 = p_95361_ * p_95359_ + $$5;
                for (int $$7 = 0; $$7 < p_95360_; ++$$7) {
                    int $$8 = p_95362_ * p_95360_ + $$7;
                    if (p_95358_.m_85087_($$6, $$8) == 0) continue;
                    return $$5 + 1;
                }
            }
            return $$5 + 1;
        }
    }
}

