/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class LegacyUnicodeBitmapsProvider
implements GlyphProvider {
    static final Logger f_95422_ = LogUtils.getLogger();
    private static final int f_169109_ = 256;
    private static final int f_169110_ = 256;
    private static final int f_169111_ = 256;
    private final ResourceManager f_95423_;
    private final byte[] f_95424_;
    private final String f_95425_;
    private final Map<ResourceLocation, NativeImage> f_95426_ = Maps.newHashMap();

    public LegacyUnicodeBitmapsProvider(ResourceManager p_95429_, byte[] p_95430_, String p_95431_) {
        this.f_95423_ = p_95429_;
        this.f_95424_ = p_95430_;
        this.f_95425_ = p_95431_;
        for (int $$3 = 0; $$3 < 256; ++$$3) {
            int $$4 = $$3 * 256;
            ResourceLocation $$5 = this.m_95442_($$4);
            try (Resource $$6 = this.f_95423_.m_142591_($$5);
                 NativeImage $$7 = NativeImage.m_85048_(NativeImage.Format.RGBA, $$6.m_6679_());){
                if ($$7.m_84982_() == 256 && $$7.m_85084_() == 256) {
                    for (int $$8 = 0; $$8 < 256; ++$$8) {
                        byte $$9 = p_95430_[$$4 + $$8];
                        if ($$9 == 0 || LegacyUnicodeBitmapsProvider.m_95433_($$9) <= LegacyUnicodeBitmapsProvider.m_95440_($$9)) continue;
                        p_95430_[$$4 + $$8] = 0;
                    }
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Arrays.fill(p_95430_, $$4, $$4 + 256, (byte)0);
        }
    }

    @Override
    public void close() {
        this.f_95426_.values().forEach(NativeImage::close);
    }

    private ResourceLocation m_95442_(int p_95443_) {
        ResourceLocation $$1 = new ResourceLocation(String.format(this.f_95425_, String.format("%02x", p_95443_ / 256)));
        return new ResourceLocation($$1.m_135827_(), "textures/" + $$1.m_135815_());
    }

    @Override
    @Nullable
    public RawGlyph m_7823_(int p_95436_) {
        NativeImage $$2;
        if (p_95436_ < 0 || p_95436_ > 65535) {
            return null;
        }
        byte $$1 = this.f_95424_[p_95436_];
        if ($$1 != 0 && ($$2 = this.f_95426_.computeIfAbsent(this.m_95442_(p_95436_), this::m_95437_)) != null) {
            int $$3 = LegacyUnicodeBitmapsProvider.m_95433_($$1);
            return new Glyph(p_95436_ % 16 * 16 + $$3, (p_95436_ & 0xFF) / 16 * 16, LegacyUnicodeBitmapsProvider.m_95440_($$1) - $$3, 16, $$2);
        }
        return null;
    }

    @Override
    public IntSet m_6990_() {
        IntOpenHashSet $$0 = new IntOpenHashSet();
        for (int $$1 = 0; $$1 < 65535; ++$$1) {
            if (this.f_95424_[$$1] == 0) continue;
            $$0.add($$1);
        }
        return $$0;
    }

    @Nullable
    private NativeImage m_95437_(ResourceLocation p_95438_) {
        NativeImage nativeImage;
        block8: {
            Resource $$1 = this.f_95423_.m_142591_(p_95438_);
            try {
                nativeImage = NativeImage.m_85048_(NativeImage.Format.RGBA, $$1.m_6679_());
                if ($$1 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if ($$1 != null) {
                        try {
                            $$1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$2) {
                    f_95422_.error("Couldn't load texture {}", (Object)p_95438_, (Object)$$2);
                    return null;
                }
            }
            $$1.close();
        }
        return nativeImage;
    }

    private static int m_95433_(byte p_95434_) {
        return p_95434_ >> 4 & 0xF;
    }

    private static int m_95440_(byte p_95441_) {
        return (p_95441_ & 0xF) + 1;
    }

    static class Glyph
    implements RawGlyph {
        private final int f_95454_;
        private final int f_95455_;
        private final int f_95456_;
        private final int f_95457_;
        private final NativeImage f_95458_;

        Glyph(int p_95460_, int p_95461_, int p_95462_, int p_95463_, NativeImage p_95464_) {
            this.f_95454_ = p_95462_;
            this.f_95455_ = p_95463_;
            this.f_95456_ = p_95460_;
            this.f_95457_ = p_95461_;
            this.f_95458_ = p_95464_;
        }

        @Override
        public float m_5621_() {
            return 2.0f;
        }

        @Override
        public int m_5631_() {
            return this.f_95454_;
        }

        @Override
        public int m_5629_() {
            return this.f_95455_;
        }

        @Override
        public float m_7403_() {
            return this.f_95454_ / 2 + 1;
        }

        @Override
        public void m_6238_(int p_95473_, int p_95474_) {
            this.f_95458_.m_85003_(0, p_95473_, p_95474_, this.f_95456_, this.f_95457_, this.f_95454_, this.f_95455_, false, false);
        }

        @Override
        public boolean m_5633_() {
            return this.f_95458_.m_85102_().m_85161_() > 1;
        }

        @Override
        public float m_5645_() {
            return 0.5f;
        }

        @Override
        public float m_5619_() {
            return 0.5f;
        }
    }

    public static class Builder
    implements GlyphProviderBuilder {
        private final ResourceLocation f_95445_;
        private final String f_95446_;

        public Builder(ResourceLocation p_95448_, String p_95449_) {
            this.f_95445_ = p_95448_;
            this.f_95446_ = p_95449_;
        }

        public static GlyphProviderBuilder m_95452_(JsonObject p_95453_) {
            return new Builder(new ResourceLocation(GsonHelper.m_13906_(p_95453_, "sizes")), Builder.m_182569_(p_95453_));
        }

        private static String m_182569_(JsonObject p_182570_) {
            String $$1 = GsonHelper.m_13906_(p_182570_, "template");
            try {
                String.format($$1, "");
            }
            catch (IllegalFormatException $$2) {
                throw new JsonParseException("Invalid legacy unicode template supplied, expected single '%s': " + $$1);
            }
            return $$1;
        }

        @Override
        @Nullable
        public GlyphProvider m_6762_(ResourceManager p_95451_) {
            LegacyUnicodeBitmapsProvider legacyUnicodeBitmapsProvider;
            block8: {
                Resource $$1 = Minecraft.m_91087_().m_91098_().m_142591_(this.f_95445_);
                try {
                    byte[] $$2 = new byte[65536];
                    $$1.m_6679_().read($$2);
                    legacyUnicodeBitmapsProvider = new LegacyUnicodeBitmapsProvider(p_95451_, $$2, this.f_95446_);
                    if ($$1 == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if ($$1 != null) {
                            try {
                                $$1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException $$3) {
                        f_95422_.error("Cannot load {}, unicode glyphs will not render correctly", (Object)this.f_95445_);
                        return null;
                    }
                }
                $$1.close();
            }
            return legacyUnicodeBitmapsProvider;
        }
    }
}

