/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> f_115566_ = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    static final DynamicCommandExceptionType f_115567_ = new DynamicCommandExceptionType(p_115580_ -> new TranslatableComponent("arguments.block.tag.unknown", p_115580_));

    public static BlockPredicateArgument m_115570_() {
        return new BlockPredicateArgument();
    }

    public Result parse(StringReader p_115572_) throws CommandSyntaxException {
        final BlockStateParser $$1 = new BlockStateParser(p_115572_, true).m_116806_(true);
        if ($$1.m_116808_() != null) {
            final BlockPredicate $$2 = new BlockPredicate($$1.m_116808_(), $$1.m_116764_().keySet(), $$1.m_116815_());
            return new Result(){

                @Override
                public Predicate<BlockInWorld> m_203340_(Registry<Block> p_205581_) {
                    return $$2;
                }

                @Override
                public boolean m_183631_() {
                    return $$2.m_194399_();
                }
            };
        }
        final TagKey<Block> $$3 = $$1.m_205617_();
        return new Result(){

            @Override
            public Predicate<BlockInWorld> m_203340_(Registry<Block> p_205588_) throws CommandSyntaxException {
                if (!p_205588_.m_203658_($$3)) {
                    throw f_115567_.create((Object)$$3);
                }
                return new TagPredicate($$3, $$1.m_116846_(), $$1.m_116815_());
            }

            @Override
            public boolean m_183631_() {
                return $$1.m_116815_() != null;
            }
        };
    }

    public static Predicate<BlockInWorld> m_115573_(CommandContext<CommandSourceStack> p_115574_, String p_115575_) throws CommandSyntaxException {
        return ((Result)p_115574_.getArgument(p_115575_, Result.class)).m_203340_(((CommandSourceStack)p_115574_.getSource()).m_81377_().m_206579_().m_175515_(Registry.f_122901_));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_115587_, SuggestionsBuilder p_115588_) {
        StringReader $$2 = new StringReader(p_115588_.getInput());
        $$2.setCursor(p_115588_.getStart());
        BlockStateParser $$3 = new BlockStateParser($$2, true);
        try {
            $$3.m_116806_(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return $$3.m_205594_(p_115588_, Registry.f_122824_);
    }

    public Collection<String> getExamples() {
        return f_115566_;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class BlockPredicate
    implements Predicate<BlockInWorld> {
        private final BlockState f_115591_;
        private final Set<Property<?>> f_115592_;
        @Nullable
        private final CompoundTag f_115593_;

        public BlockPredicate(BlockState p_115595_, Set<Property<?>> p_115596_, @Nullable CompoundTag p_115597_) {
            this.f_115591_ = p_115595_;
            this.f_115592_ = p_115596_;
            this.f_115593_ = p_115597_;
        }

        @Override
        public boolean test(BlockInWorld p_115599_) {
            BlockState $$1 = p_115599_.m_61168_();
            if (!$$1.m_60713_(this.f_115591_.m_60734_())) {
                return false;
            }
            for (Property<?> $$2 : this.f_115592_) {
                if ($$1.m_61143_($$2) == this.f_115591_.m_61143_($$2)) continue;
                return false;
            }
            if (this.f_115593_ != null) {
                BlockEntity $$3 = p_115599_.m_61174_();
                return $$3 != null && NbtUtils.m_129235_(this.f_115593_, $$3.m_187480_(), true);
            }
            return true;
        }

        public boolean m_194399_() {
            return this.f_115593_ != null;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }

    public static interface Result {
        public Predicate<BlockInWorld> m_203340_(Registry<Block> var1) throws CommandSyntaxException;

        public boolean m_183631_();
    }

    static class TagPredicate
    implements Predicate<BlockInWorld> {
        private final TagKey<Block> f_115604_;
        @Nullable
        private final CompoundTag f_115605_;
        private final Map<String, String> f_115606_;

        TagPredicate(TagKey<Block> p_205591_, Map<String, String> p_205592_, @Nullable CompoundTag p_205593_) {
            this.f_115604_ = p_205591_;
            this.f_115606_ = p_205592_;
            this.f_115605_ = p_205593_;
        }

        @Override
        public boolean test(BlockInWorld p_115617_) {
            BlockState $$1 = p_115617_.m_61168_();
            if (!$$1.m_204336_(this.f_115604_)) {
                return false;
            }
            for (Map.Entry<String, String> $$2 : this.f_115606_.entrySet()) {
                Property<?> $$3 = $$1.m_60734_().m_49965_().m_61081_($$2.getKey());
                if ($$3 == null) {
                    return false;
                }
                Comparable $$4 = $$3.m_6215_($$2.getValue()).orElse(null);
                if ($$4 == null) {
                    return false;
                }
                if ($$1.m_61143_($$3) == $$4) continue;
                return false;
            }
            if (this.f_115605_ != null) {
                BlockEntity $$5 = p_115617_.m_61174_();
                return $$5 != null && NbtUtils.m_129235_(this.f_115605_, $$5.m_187480_(), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }
}

