/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.NbtComponent;
import net.minecraft.network.chat.ScoreComponent;
import net.minecraft.network.chat.SelectorComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public interface Component
extends Message,
FormattedText {
    public Style m_7383_();

    public String m_6111_();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String m_130668_(int p_130669_) {
        StringBuilder $$1 = new StringBuilder();
        this.m_5651_(p_130673_ -> {
            int $$3 = p_130669_ - $$1.length();
            if ($$3 <= 0) {
                return f_130759_;
            }
            $$1.append(p_130673_.length() <= $$3 ? p_130673_ : p_130673_.substring(0, $$3));
            return Optional.empty();
        });
        return $$1.toString();
    }

    public List<Component> m_7360_();

    public MutableComponent m_6879_();

    public MutableComponent m_6881_();

    public FormattedCharSequence m_7532_();

    @Override
    default public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> p_130679_, Style p_130680_) {
        Style $$2 = this.m_7383_().m_131146_(p_130680_);
        Optional<T> $$3 = this.m_7452_(p_130679_, $$2);
        if ($$3.isPresent()) {
            return $$3;
        }
        for (Component $$4 : this.m_7360_()) {
            Optional<T> $$5 = $$4.m_7451_(p_130679_, $$2);
            if (!$$5.isPresent()) continue;
            return $$5;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> p_130677_) {
        Optional<T> $$1 = this.m_5655_(p_130677_);
        if ($$1.isPresent()) {
            return $$1;
        }
        for (Component $$2 : this.m_7360_()) {
            Optional<T> $$3 = $$2.m_5651_(p_130677_);
            if (!$$3.isPresent()) continue;
            return $$3;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> m_7452_(FormattedText.StyledContentConsumer<T> p_130682_, Style p_130683_) {
        return p_130682_.m_7164_(p_130683_, this.m_6111_());
    }

    default public <T> Optional<T> m_5655_(FormattedText.ContentConsumer<T> p_130681_) {
        return p_130681_.m_130809_(this.m_6111_());
    }

    default public List<Component> m_178405_(Style p_178406_) {
        ArrayList $$1 = Lists.newArrayList();
        this.m_7451_((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                $$1.add(new TextComponent(p_178404_).m_130948_(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return $$1;
    }

    public static Component m_130674_(@Nullable String p_130675_) {
        return p_130675_ != null ? new TextComponent(p_130675_) : TextComponent.f_131282_;
    }

    public static class Serializer
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private static final Gson f_130685_ = Util.m_137537_(() -> {
            GsonBuilder $$0 = new GsonBuilder();
            $$0.disableHtmlEscaping();
            $$0.registerTypeHierarchyAdapter(Component.class, (Object)new Serializer());
            $$0.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            $$0.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return $$0.create();
        });
        private static final Field f_130686_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field $$0 = JsonReader.class.getDeclaredField("pos");
                $$0.setAccessible(true);
                return $$0;
            }
            catch (NoSuchFieldException $$1) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", $$1);
            }
        });
        private static final Field f_130687_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field $$0 = JsonReader.class.getDeclaredField("lineStart");
                $$0.setAccessible(true);
                return $$0;
            }
            catch (NoSuchFieldException $$1) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", $$1);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MutableComponent deserialize(JsonElement p_130694_, Type p_130695_, JsonDeserializationContext p_130696_) throws JsonParseException {
            if (p_130694_.isJsonPrimitive()) {
                return new TextComponent(p_130694_.getAsString());
            }
            if (p_130694_.isJsonObject()) {
                void $$25;
                JsonObject $$3 = p_130694_.getAsJsonObject();
                if ($$3.has("text")) {
                    TextComponent $$4 = new TextComponent(GsonHelper.m_13906_($$3, "text"));
                } else if ($$3.has("translate")) {
                    String $$5 = GsonHelper.m_13906_($$3, "translate");
                    if ($$3.has("with")) {
                        JsonArray $$6 = GsonHelper.m_13933_($$3, "with");
                        Object[] $$7 = new Object[$$6.size()];
                        for (int $$8 = 0; $$8 < $$7.length; ++$$8) {
                            TextComponent $$9;
                            $$7[$$8] = this.deserialize($$6.get($$8), p_130695_, p_130696_);
                            if (!($$7[$$8] instanceof TextComponent) || !($$9 = (TextComponent)$$7[$$8]).m_7383_().m_131179_() || !$$9.m_7360_().isEmpty()) continue;
                            $$7[$$8] = $$9.m_131292_();
                        }
                        TranslatableComponent $$10 = new TranslatableComponent($$5, $$7);
                    } else {
                        TranslatableComponent $$11 = new TranslatableComponent($$5);
                    }
                } else if ($$3.has("score")) {
                    JsonObject $$12 = GsonHelper.m_13930_($$3, "score");
                    if (!$$12.has("name") || !$$12.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    ScoreComponent $$13 = new ScoreComponent(GsonHelper.m_13906_($$12, "name"), GsonHelper.m_13906_($$12, "objective"));
                } else if ($$3.has("selector")) {
                    Optional<Component> $$15 = this.m_178415_(p_130695_, p_130696_, $$3);
                    SelectorComponent $$16 = new SelectorComponent(GsonHelper.m_13906_($$3, "selector"), $$15);
                } else if ($$3.has("keybind")) {
                    KeybindComponent $$17 = new KeybindComponent(GsonHelper.m_13906_($$3, "keybind"));
                } else {
                    if (!$$3.has("nbt")) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                    String $$18 = GsonHelper.m_13906_($$3, "nbt");
                    Optional<Component> $$19 = this.m_178415_(p_130695_, p_130696_, $$3);
                    boolean $$20 = GsonHelper.m_13855_($$3, "interpret", false);
                    if ($$3.has("block")) {
                        NbtComponent.BlockNbtComponent $$21 = new NbtComponent.BlockNbtComponent($$18, $$20, GsonHelper.m_13906_($$3, "block"), $$19);
                    } else if ($$3.has("entity")) {
                        NbtComponent.EntityNbtComponent $$22 = new NbtComponent.EntityNbtComponent($$18, $$20, GsonHelper.m_13906_($$3, "entity"), $$19);
                    } else {
                        if (!$$3.has("storage")) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                        NbtComponent.StorageNbtComponent $$23 = new NbtComponent.StorageNbtComponent($$18, $$20, new ResourceLocation(GsonHelper.m_13906_($$3, "storage")), $$19);
                    }
                }
                if ($$3.has("extra")) {
                    JsonArray $$26 = GsonHelper.m_13933_($$3, "extra");
                    if ($$26.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    for (int $$27 = 0; $$27 < $$26.size(); ++$$27) {
                        $$25.m_7220_(this.deserialize($$26.get($$27), p_130695_, p_130696_));
                    }
                }
                $$25.m_6270_((Style)p_130696_.deserialize(p_130694_, Style.class));
                return $$25;
            }
            if (!p_130694_.isJsonArray()) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
            JsonArray $$28 = p_130694_.getAsJsonArray();
            MutableComponent $$29 = null;
            for (JsonElement $$30 : $$28) {
                MutableComponent $$31 = this.deserialize($$30, $$30.getClass(), p_130696_);
                if ($$29 == null) {
                    $$29 = $$31;
                    continue;
                }
                $$29.m_7220_($$31);
            }
            return $$29;
        }

        private Optional<Component> m_178415_(Type p_178416_, JsonDeserializationContext p_178417_, JsonObject p_178418_) {
            if (p_178418_.has("separator")) {
                return Optional.of(this.deserialize(p_178418_.get("separator"), p_178416_, p_178417_));
            }
            return Optional.empty();
        }

        private void m_130709_(Style p_130710_, JsonObject p_130711_, JsonSerializationContext p_130712_) {
            JsonElement $$3 = p_130712_.serialize((Object)p_130710_);
            if ($$3.isJsonObject()) {
                JsonObject $$4 = (JsonObject)$$3;
                for (Map.Entry $$5 : $$4.entrySet()) {
                    p_130711_.add((String)$$5.getKey(), (JsonElement)$$5.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(Component p_130706_, Type p_130707_, JsonSerializationContext p_130708_) {
            JsonObject $$3 = new JsonObject();
            if (!p_130706_.m_7383_().m_131179_()) {
                this.m_130709_(p_130706_.m_7383_(), $$3, p_130708_);
            }
            if (!p_130706_.m_7360_().isEmpty()) {
                JsonArray $$4 = new JsonArray();
                for (Component $$5 : p_130706_.m_7360_()) {
                    $$4.add(this.serialize($$5, $$5.getClass(), p_130708_));
                }
                $$3.add("extra", (JsonElement)$$4);
            }
            if (p_130706_ instanceof TextComponent) {
                $$3.addProperty("text", ((TextComponent)p_130706_).m_131292_());
                return $$3;
            } else if (p_130706_ instanceof TranslatableComponent) {
                TranslatableComponent $$6 = (TranslatableComponent)p_130706_;
                $$3.addProperty("translate", $$6.m_131328_());
                if ($$6.m_131329_() == null || $$6.m_131329_().length <= 0) return $$3;
                JsonArray $$7 = new JsonArray();
                for (Object $$8 : $$6.m_131329_()) {
                    if ($$8 instanceof Component) {
                        $$7.add(this.serialize((Component)$$8, $$8.getClass(), p_130708_));
                        continue;
                    }
                    $$7.add((JsonElement)new JsonPrimitive(String.valueOf($$8)));
                }
                $$3.add("with", (JsonElement)$$7);
                return $$3;
            } else if (p_130706_ instanceof ScoreComponent) {
                ScoreComponent $$9 = (ScoreComponent)p_130706_;
                JsonObject $$10 = new JsonObject();
                $$10.addProperty("name", $$9.m_131071_());
                $$10.addProperty("objective", $$9.m_131072_());
                $$3.add("score", (JsonElement)$$10);
                return $$3;
            } else if (p_130706_ instanceof SelectorComponent) {
                SelectorComponent $$11 = (SelectorComponent)p_130706_;
                $$3.addProperty("selector", $$11.m_131096_());
                this.m_178411_(p_130708_, $$3, $$11.m_178519_());
                return $$3;
            } else if (p_130706_ instanceof KeybindComponent) {
                KeybindComponent $$12 = (KeybindComponent)p_130706_;
                $$3.addProperty("keybind", $$12.m_130935_());
                return $$3;
            } else {
                if (!(p_130706_ instanceof NbtComponent)) throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                NbtComponent $$13 = (NbtComponent)p_130706_;
                $$3.addProperty("nbt", $$13.m_130979_());
                $$3.addProperty("interpret", Boolean.valueOf($$13.m_130980_()));
                this.m_178411_(p_130708_, $$3, $$13.f_178447_);
                if (p_130706_ instanceof NbtComponent.BlockNbtComponent) {
                    NbtComponent.BlockNbtComponent $$14 = (NbtComponent.BlockNbtComponent)p_130706_;
                    $$3.addProperty("block", $$14.m_131001_());
                    return $$3;
                } else if (p_130706_ instanceof NbtComponent.EntityNbtComponent) {
                    NbtComponent.EntityNbtComponent $$15 = (NbtComponent.EntityNbtComponent)p_130706_;
                    $$3.addProperty("entity", $$15.m_131024_());
                    return $$3;
                } else {
                    if (!(p_130706_ instanceof NbtComponent.StorageNbtComponent)) throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                    NbtComponent.StorageNbtComponent $$16 = (NbtComponent.StorageNbtComponent)p_130706_;
                    $$3.addProperty("storage", $$16.m_131043_().toString());
                }
            }
            return $$3;
        }

        private void m_178411_(JsonSerializationContext p_178412_, JsonObject p_178413_, Optional<Component> p_178414_) {
            p_178414_.ifPresent(p_178410_ -> p_178413_.add("separator", this.serialize((Component)p_178410_, (Type)p_178410_.getClass(), p_178412_)));
        }

        public static String m_130703_(Component p_130704_) {
            return f_130685_.toJson((Object)p_130704_);
        }

        public static JsonElement m_130716_(Component p_130717_) {
            return f_130685_.toJsonTree((Object)p_130717_);
        }

        @Nullable
        public static MutableComponent m_130701_(String p_130702_) {
            return GsonHelper.m_13798_(f_130685_, p_130702_, MutableComponent.class, false);
        }

        @Nullable
        public static MutableComponent m_130691_(JsonElement p_130692_) {
            return (MutableComponent)f_130685_.fromJson(p_130692_, MutableComponent.class);
        }

        @Nullable
        public static MutableComponent m_130714_(String p_130715_) {
            return GsonHelper.m_13798_(f_130685_, p_130715_, MutableComponent.class, true);
        }

        public static MutableComponent m_130699_(com.mojang.brigadier.StringReader p_130700_) {
            try {
                JsonReader $$1 = new JsonReader((Reader)new StringReader(p_130700_.getRemaining()));
                $$1.setLenient(false);
                MutableComponent $$2 = (MutableComponent)f_130685_.getAdapter(MutableComponent.class).read($$1);
                p_130700_.setCursor(p_130700_.getCursor() + Serializer.m_130697_($$1));
                return $$2;
            }
            catch (IOException | StackOverflowError $$3) {
                throw new JsonParseException($$3);
            }
        }

        private static int m_130697_(JsonReader p_130698_) {
            try {
                return f_130686_.getInt(p_130698_) - f_130687_.getInt(p_130698_) + 1;
            }
            catch (IllegalAccessException $$1) {
                throw new IllegalStateException("Couldn't read position of JsonReader", $$1);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((Component)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

