/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public abstract class ChunkGenerator
implements BiomeManager.NoiseBiomeSource {
    private static final Logger f_211627_;
    public static final Codec<ChunkGenerator> f_62136_;
    protected final Registry<StructureSet> f_207955_;
    protected final BiomeSource f_62137_;
    protected final BiomeSource f_62138_;
    protected final Optional<HolderSet<StructureSet>> f_207956_;
    private final Map<ConfiguredStructureFeature<?, ?>, List<StructurePlacement>> f_207957_ = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkPos>>> f_204350_ = new Object2ObjectArrayMap();
    private boolean f_207958_;
    @Deprecated
    private final long f_212255_;

    protected static final <T extends ChunkGenerator> Products.P1<RecordCodecBuilder.Mu<T>, Registry<StructureSet>> m_208005_(RecordCodecBuilder.Instance<T> p_208006_) {
        return p_208006_.group((App)RegistryOps.m_206832_(Registry.f_211073_).forGetter(p_208008_ -> p_208008_.f_207955_));
    }

    public ChunkGenerator(Registry<StructureSet> p_207960_, Optional<HolderSet<StructureSet>> p_207961_, BiomeSource p_207962_) {
        this(p_207960_, p_207961_, p_207962_, p_207962_, 0L);
    }

    public ChunkGenerator(Registry<StructureSet> p_207964_, Optional<HolderSet<StructureSet>> p_207965_, BiomeSource p_207966_, BiomeSource p_207967_, long p_207968_) {
        this.f_207955_ = p_207964_;
        this.f_62137_ = p_207966_;
        this.f_62138_ = p_207967_;
        this.f_207956_ = p_207965_;
        this.f_212255_ = p_207968_;
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        if (this.f_207956_.isPresent()) {
            return this.f_207956_.get().m_203614_();
        }
        return this.f_207955_.m_203611_().map(Holder::m_205706_);
    }

    private void m_208097_() {
        Set<Holder<Biome>> $$0 = this.f_62138_.m_207840_();
        this.m_207969_().forEach(p_208094_ -> {
            StructureSet $$2 = (StructureSet)p_208094_.m_203334_();
            for (StructureSet.StructureSelectionEntry $$3 : $$2.f_210003_()) {
                this.f_207957_.computeIfAbsent($$3.f_210026_().m_203334_(), p_208087_ -> new ArrayList()).add($$2.f_210004_());
            }
            StructurePlacement $$4 = $$2.f_210004_();
            if ($$4 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement $$5 = (ConcentricRingsStructurePlacement)$$4;
                if ($$2.f_210003_().stream().anyMatch(p_208071_ -> p_208071_.m_210035_($$0::contains))) {
                    this.f_204350_.put($$5, this.m_211667_((Holder<StructureSet>)p_208094_, $$5));
                }
            }
        });
    }

    private CompletableFuture<List<ChunkPos>> m_211667_(Holder<StructureSet> p_211668_, ConcentricRingsStructurePlacement p_211669_) {
        if (p_211669_.f_204952_() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        return CompletableFuture.supplyAsync(Util.m_183946_("placement calculation", () -> {
            Stopwatch $$2 = Stopwatch.createStarted((Ticker)Util.f_211544_);
            ArrayList<ChunkPos> $$3 = new ArrayList<ChunkPos>();
            Set $$4 = ((StructureSet)p_211668_.m_203334_()).f_210003_().stream().flatMap(p_208015_ -> p_208015_.f_210026_().m_203334_().m_209752_().m_203614_()).collect(Collectors.toSet());
            int $$5 = p_211669_.f_204950_();
            int $$6 = p_211669_.f_204952_();
            int $$7 = p_211669_.f_204951_();
            Random $$8 = new Random();
            $$8.setSeed(this.f_212255_);
            double $$9 = $$8.nextDouble() * Math.PI * 2.0;
            int $$10 = 0;
            int $$11 = 0;
            for (int $$12 = 0; $$12 < $$6; ++$$12) {
                double $$13 = (double)(4 * $$5 + $$5 * $$11 * 6) + ($$8.nextDouble() - 0.5) * ((double)$$5 * 2.5);
                int $$14 = (int)Math.round(Math.cos($$9) * $$13);
                int $$15 = (int)Math.round(Math.sin($$9) * $$13);
                Pair<BlockPos, Holder<Biome>> $$16 = this.f_62137_.m_207829_(SectionPos.m_175554_($$14, 8), 0, SectionPos.m_175554_($$15, 8), 112, $$4::contains, $$8, this.m_183403_());
                if ($$16 != null) {
                    BlockPos $$17 = (BlockPos)$$16.getFirst();
                    $$14 = SectionPos.m_123171_($$17.m_123341_());
                    $$15 = SectionPos.m_123171_($$17.m_123343_());
                }
                $$3.add(new ChunkPos($$14, $$15));
                $$9 += Math.PI * 2 / (double)$$7;
                if (++$$10 != $$7) continue;
                $$10 = 0;
                $$7 += 2 * $$7 / (++$$11 + 1);
                $$7 = Math.min($$7, $$6 - $$12);
                $$9 += $$8.nextDouble() * Math.PI * 2.0;
            }
            double $$18 = (double)$$2.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            f_211627_.debug("Calculation for {} took {}s", (Object)p_211668_, (Object)$$18);
            return $$3;
        }), Util.m_183991_());
    }

    protected abstract Codec<? extends ChunkGenerator> m_6909_();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> m_187743_() {
        return Registry.f_122890_.m_7854_(this.m_6909_());
    }

    public abstract ChunkGenerator m_6819_(long var1);

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_196743_, Executor p_196744_, Blender p_196745_, StructureFeatureManager p_196746_, ChunkAccess p_196747_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            p_196747_.m_183442_(this.f_62138_::m_203407_, this.m_183403_());
            return p_196747_;
        }), Util.m_183991_());
    }

    public abstract Climate.Sampler m_183403_();

    @Override
    public Holder<Biome> m_203495_(int p_204416_, int p_204417_, int p_204418_) {
        return this.m_62218_().m_203407_(p_204416_, p_204417_, p_204418_, this.m_183403_());
    }

    public abstract void m_183516_(WorldGenRegion var1, long var2, BiomeManager var4, StructureFeatureManager var5, ChunkAccess var6, GenerationStep.Carving var7);

    @Nullable
    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_207970_(ServerLevel p_207971_, HolderSet<ConfiguredStructureFeature<?, ?>> p_207972_, BlockPos p_207973_, int p_207974_, boolean p_207975_) {
        Set $$5 = p_207972_.m_203614_().flatMap(p_211699_ -> ((ConfiguredStructureFeature)p_211699_.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if ($$5.isEmpty()) {
            return null;
        }
        Set<Holder<Biome>> $$6 = this.f_62138_.m_207840_();
        if (Collections.disjoint($$6, $$5)) {
            return null;
        }
        Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> $$7 = null;
        double $$8 = Double.MAX_VALUE;
        Object2ObjectArrayMap $$9 = new Object2ObjectArrayMap();
        for (Holder holder : p_207972_) {
            if ($$6.stream().noneMatch(((ConfiguredStructureFeature)holder.m_203334_()).m_209752_()::m_203333_)) continue;
            for (StructurePlacement $$11 : this.m_208090_(holder)) {
                $$9.computeIfAbsent($$11, p_211663_ -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList $$12 = new ArrayList($$9.size());
        for (Map.Entry entry : $$9.entrySet()) {
            StructurePlacement $$14 = (StructurePlacement)entry.getKey();
            if ($$14 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement $$15 = (ConcentricRingsStructurePlacement)$$14;
                BlockPos $$16 = this.m_204382_(p_207973_, $$15);
                double $$17 = p_207973_.m_123331_($$16);
                if (!($$17 < $$8)) continue;
                $$8 = $$17;
                $$7 = Pair.of((Object)$$16, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!($$14 instanceof RandomSpreadStructurePlacement)) continue;
            $$12.add(entry);
        }
        if (!$$12.isEmpty()) {
            int n = SectionPos.m_123171_(p_207973_.m_123341_());
            int n2 = SectionPos.m_123171_(p_207973_.m_123343_());
            for (int $$20 = 0; $$20 <= p_207974_; ++$$20) {
                boolean $$21 = false;
                for (Map.Entry $$22 : $$12) {
                    RandomSpreadStructurePlacement $$23 = (RandomSpreadStructurePlacement)$$22.getKey();
                    Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> $$24 = ChunkGenerator.m_208059_((Set)$$22.getValue(), p_207971_, p_207971_.m_8595_(), n, n2, $$20, p_207975_, p_207971_.m_7328_(), $$23);
                    if ($$24 == null) continue;
                    $$21 = true;
                    double $$25 = p_207973_.m_123331_((Vec3i)$$24.getFirst());
                    if (!($$25 < $$8)) continue;
                    $$8 = $$25;
                    $$7 = $$24;
                }
                if (!$$21) continue;
                return $$7;
            }
        }
        return $$7;
    }

    @Nullable
    private BlockPos m_204382_(BlockPos p_204383_, ConcentricRingsStructurePlacement p_204384_) {
        List<ChunkPos> $$2 = this.m_204380_(p_204384_);
        if ($$2 == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        BlockPos $$3 = null;
        double $$4 = Double.MAX_VALUE;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (ChunkPos $$6 : $$2) {
            $$5.m_122178_(SectionPos.m_175554_($$6.f_45578_, 8), 32, SectionPos.m_175554_($$6.f_45579_, 8));
            double $$7 = $$5.m_123331_(p_204383_);
            if ($$3 == null) {
                $$3 = new BlockPos($$5);
                $$4 = $$7;
                continue;
            }
            if (!($$7 < $$4)) continue;
            $$3 = new BlockPos($$5);
            $$4 = $$7;
        }
        return $$3;
    }

    @Nullable
    private static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_208059_(Set<Holder<ConfiguredStructureFeature<?, ?>>> p_208060_, LevelReader p_208061_, StructureFeatureManager p_208062_, int p_208063_, int p_208064_, int p_208065_, boolean p_208066_, long p_208067_, RandomSpreadStructurePlacement p_208068_) {
        int $$9 = p_208068_.f_204973_();
        for (int $$10 = -p_208065_; $$10 <= p_208065_; ++$$10) {
            boolean $$11 = $$10 == -p_208065_ || $$10 == p_208065_;
            for (int $$12 = -p_208065_; $$12 <= p_208065_; ++$$12) {
                boolean $$13;
                boolean bl = $$13 = $$12 == -p_208065_ || $$12 == p_208065_;
                if (!$$11 && !$$13) continue;
                int $$14 = p_208063_ + $$9 * $$10;
                int $$15 = p_208064_ + $$9 * $$12;
                ChunkPos $$16 = p_208068_.m_204991_(p_208067_, $$14, $$15);
                for (Holder<ConfiguredStructureFeature<?, ?>> $$17 : p_208060_) {
                    StructureCheckResult $$18 = p_208062_.m_207777_($$16, $$17.m_203334_(), p_208066_);
                    if ($$18 == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_208066_ && $$18 == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)StructureFeature.m_204766_(p_208068_, $$16), $$17);
                    }
                    ChunkAccess $$19 = p_208061_.m_46819_($$16.f_45578_, $$16.f_45579_, ChunkStatus.f_62315_);
                    StructureStart $$20 = p_208062_.m_207802_(SectionPos.m_175562_($$19), $$17.m_203334_(), $$19);
                    if ($$20 == null || !$$20.m_73603_()) continue;
                    if (p_208066_ && $$20.m_73606_()) {
                        p_208062_.m_196674_($$20);
                        return Pair.of((Object)StructureFeature.m_204766_(p_208068_, $$20.m_163625_()), $$17);
                    }
                    if (p_208066_) continue;
                    return Pair.of((Object)StructureFeature.m_204766_(p_208068_, $$20.m_163625_()), $$17);
                }
            }
        }
        return null;
    }

    public void m_183372_(WorldGenLevel p_187712_, ChunkAccess p_187713_, StructureFeatureManager p_187714_) {
        ChunkPos $$3 = p_187713_.m_7697_();
        if (SharedConstants.m_183707_($$3)) {
            return;
        }
        SectionPos $$4 = SectionPos.m_123196_($$3, p_187712_.m_151560_());
        BlockPos $$5 = $$4.m_123249_();
        Registry<ConfiguredStructureFeature<?, ?>> $$6 = p_187712_.m_5962_().m_175515_(Registry.f_122882_);
        Map<Integer, List<ConfiguredStructureFeature>> $$7 = $$6.m_123024_().collect(Collectors.groupingBy(p_211653_ -> ((StructureFeature)p_211653_.f_65403_).m_67095_().ordinal()));
        List<BiomeSource.StepFeatureData> $$8 = this.f_62137_.m_186733_();
        WorldgenRandom $$9 = new WorldgenRandom(new XoroshiroRandomSource(RandomSupport.m_189328_()));
        long $$10 = $$9.m_64690_(p_187712_.m_7328_(), $$5.m_123341_(), $$5.m_123343_());
        ObjectArraySet $$11 = new ObjectArraySet();
        if (this instanceof FlatLevelSource) {
            this.f_62137_.m_207840_().stream().map(Holder::m_203334_).forEach(((Set)$$11)::add);
        } else {
            ChunkPos.m_45596_($$4.m_123251_(), 1).forEach(arg_0 -> ChunkGenerator.m_211648_(p_187712_, (Set)$$11, arg_0));
            $$11.retainAll(this.f_62137_.m_207840_().stream().map(Holder::m_203334_).collect(Collectors.toSet()));
        }
        int $$12 = $$8.size();
        try {
            Registry<PlacedFeature> $$13 = p_187712_.m_5962_().m_175515_(Registry.f_194567_);
            int $$14 = Math.max(GenerationStep.Decoration.values().length, $$12);
            for (int $$15 = 0; $$15 < $$14; ++$$15) {
                int $$16 = 0;
                if (p_187714_.m_47271_()) {
                    List $$17 = $$7.getOrDefault($$15, Collections.emptyList());
                    for (ConfiguredStructureFeature $$18 : $$17) {
                        $$9.m_190064_($$10, $$16, $$15);
                        Supplier<String> $$19 = () -> $$6.m_7854_($$18).map(Object::toString).orElseGet($$18::toString);
                        try {
                            p_187712_.m_183406_($$19);
                            p_187714_.m_207794_($$4, $$18).forEach(p_211647_ -> p_211647_.m_7129_(p_187712_, p_187714_, this, $$9, ChunkGenerator.m_187717_(p_187713_), $$3));
                        }
                        catch (Exception $$20) {
                            CrashReport $$21 = CrashReport.m_127521_($$20, "Feature placement");
                            $$21.m_127514_("Feature").m_128165_("Description", $$19::get);
                            throw new ReportedException($$21);
                        }
                        ++$$16;
                    }
                }
                if ($$15 >= $$12) continue;
                IntArraySet $$22 = new IntArraySet();
                for (Biome $$23 : $$11) {
                    List<HolderSet<PlacedFeature>> $$24 = $$23.m_47536_().m_47818_();
                    if ($$15 >= $$24.size()) continue;
                    HolderSet<PlacedFeature> $$25 = $$24.get($$15);
                    BiomeSource.StepFeatureData $$26 = $$8.get($$15);
                    $$25.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> ChunkGenerator.m_211679_((IntSet)$$22, $$26, arg_0));
                }
                int $$27 = $$22.size();
                int[] $$28 = $$22.toIntArray();
                Arrays.sort($$28);
                BiomeSource.StepFeatureData $$29 = $$8.get($$15);
                for (int $$30 = 0; $$30 < $$27; ++$$30) {
                    int $$31 = $$28[$$30];
                    PlacedFeature $$32 = $$29.f_196677_().get($$31);
                    Supplier<String> $$33 = () -> $$13.m_7854_($$32).map(Object::toString).orElseGet($$32::toString);
                    $$9.m_190064_($$10, $$31, $$15);
                    try {
                        p_187712_.m_183406_($$33);
                        $$32.m_191806_(p_187712_, this, $$9, $$5);
                        continue;
                    }
                    catch (Exception $$34) {
                        CrashReport $$35 = CrashReport.m_127521_($$34, "Feature placement");
                        $$35.m_127514_("Feature").m_128165_("Description", $$33::get);
                        throw new ReportedException($$35);
                    }
                }
            }
            p_187712_.m_183406_(null);
        }
        catch (Exception $$36) {
            CrashReport $$37 = CrashReport.m_127521_($$36, "Biome decoration");
            $$37.m_127514_("Generation").m_128159_("CenterX", $$3.f_45578_).m_128159_("CenterZ", $$3.f_45579_).m_128159_("Seed", $$10);
            throw new ReportedException($$37);
        }
    }

    public boolean m_212265_(ResourceKey<StructureSet> p_212266_, long p_212267_, int p_212268_, int p_212269_, int p_212270_) {
        StructureSet $$5 = this.f_207955_.m_6246_(p_212266_);
        if ($$5 == null) {
            return false;
        }
        StructurePlacement $$6 = $$5.f_210004_();
        for (int $$7 = p_212268_ - p_212270_; $$7 <= p_212268_ + p_212270_; ++$$7) {
            for (int $$8 = p_212269_ - p_212270_; $$8 <= p_212269_ + p_212270_; ++$$8) {
                if (!$$6.m_212129_(this, p_212267_, $$7, $$8)) continue;
                return true;
            }
        }
        return false;
    }

    private static BoundingBox m_187717_(ChunkAccess p_187718_) {
        ChunkPos $$1 = p_187718_.m_7697_();
        int $$2 = $$1.m_45604_();
        int $$3 = $$1.m_45605_();
        LevelHeightAccessor $$4 = p_187718_.m_183618_();
        int $$5 = $$4.m_141937_() + 1;
        int $$6 = $$4.m_151558_() - 1;
        return new BoundingBox($$2, $$5, $$3, $$2 + 15, $$6, $$3 + 15);
    }

    public abstract void m_183621_(WorldGenRegion var1, StructureFeatureManager var2, ChunkAccess var3);

    public abstract void m_6929_(WorldGenRegion var1);

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public BiomeSource m_62218_() {
        return this.f_62138_;
    }

    public abstract int m_6331_();

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<Biome> p_204386_, StructureFeatureManager p_204387_, MobCategory p_204388_, BlockPos p_204389_) {
        Map<ConfiguredStructureFeature<?, ?>, LongSet> $$4 = p_204387_.m_207815_(p_204389_);
        for (Map.Entry<ConfiguredStructureFeature<?, ?>, LongSet> $$5 : $$4.entrySet()) {
            ConfiguredStructureFeature<?, ?> $$6 = $$5.getKey();
            StructureSpawnOverride $$7 = $$6.f_209744_.get(p_204388_);
            if ($$7 == null) continue;
            MutableBoolean $$8 = new MutableBoolean(false);
            Predicate<StructureStart> $$9 = $$7.f_210043_() == StructureSpawnOverride.BoundingBoxType.PIECE ? p_211631_ -> p_204387_.m_207788_(p_204389_, (StructureStart)p_211631_) : p_211666_ -> p_211666_.m_73601_().m_71051_(p_204389_);
            p_204387_.m_207781_($$6, $$5.getValue(), p_211692_ -> {
                if ($$8.isFalse() && $$9.test((StructureStart)p_211692_)) {
                    $$8.setTrue();
                }
            });
            if (!$$8.isTrue()) continue;
            return $$7.f_210044_();
        }
        return p_204386_.m_203334_().m_47518_().m_151798_(p_204388_);
    }

    public static Stream<ConfiguredStructureFeature<?, ?>> m_208044_(Registry<ConfiguredStructureFeature<?, ?>> p_208045_, StructureFeature<?> p_208046_) {
        return p_208045_.m_123024_().filter(p_211656_ -> p_211656_.f_65403_ == p_208046_);
    }

    public void m_62199_(RegistryAccess p_62200_, StructureFeatureManager p_62201_, ChunkAccess p_62202_, StructureManager p_62203_, long p_62204_) {
        ChunkPos $$5 = p_62202_.m_7697_();
        SectionPos $$6 = SectionPos.m_175562_(p_62202_);
        this.m_207969_().forEach(p_212264_ -> {
            StructurePlacement $$8 = ((StructureSet)p_212264_.m_203334_()).f_210004_();
            List<StructureSet.StructureSelectionEntry> $$9 = ((StructureSet)p_212264_.m_203334_()).f_210003_();
            for (StructureSet.StructureSelectionEntry $$10 : $$9) {
                StructureStart $$11 = p_62201_.m_207802_($$6, $$10.f_210026_().m_203334_(), p_62202_);
                if ($$11 == null || !$$11.m_73603_()) continue;
                return;
            }
            if (!$$8.m_212129_(this, p_62204_, p_212261_.f_45578_, p_212261_.f_45579_)) {
                return;
            }
            if ($$9.size() == 1) {
                this.m_208016_($$9.get(0), p_62201_, p_62200_, p_62203_, p_62204_, p_62202_, $$5, $$6);
                return;
            }
            ArrayList<StructureSet.StructureSelectionEntry> $$12 = new ArrayList<StructureSet.StructureSelectionEntry>($$9.size());
            $$12.addAll($$9);
            WorldgenRandom $$13 = new WorldgenRandom(new LegacyRandomSource(0L));
            $$13.m_190068_(p_62204_, p_212261_.f_45578_, p_212261_.f_45579_);
            int $$14 = 0;
            for (StructureSet.StructureSelectionEntry $$15 : $$12) {
                $$14 += $$15.f_210027_();
            }
            while (!$$12.isEmpty()) {
                StructureSet.StructureSelectionEntry $$18;
                int $$16 = $$13.nextInt($$14);
                int $$17 = 0;
                Iterator iterator = $$12.iterator();
                while (iterator.hasNext() && ($$16 -= ($$18 = (StructureSet.StructureSelectionEntry)iterator.next()).f_210027_()) >= 0) {
                    ++$$17;
                }
                StructureSet.StructureSelectionEntry $$19 = (StructureSet.StructureSelectionEntry)$$12.get($$17);
                if (this.m_208016_($$19, p_62201_, p_62200_, p_62203_, p_62204_, p_62202_, $$5, $$6)) {
                    return;
                }
                $$12.remove($$17);
                $$14 -= $$19.f_210027_();
            }
        });
    }

    private boolean m_208016_(StructureSet.StructureSelectionEntry p_208017_, StructureFeatureManager p_208018_, RegistryAccess p_208019_, StructureManager p_208020_, long p_208021_, ChunkAccess p_208022_, ChunkPos p_208023_, SectionPos p_208024_) {
        HolderSet<Biome> $$10;
        Predicate<Holder<Biome>> $$11;
        int $$9;
        ConfiguredStructureFeature<?, ?> $$8 = p_208017_.f_210026_().m_203334_();
        StructureStart $$12 = $$8.m_204707_(p_208019_, this, this.f_62137_, p_208020_, p_208021_, p_208023_, $$9 = ChunkGenerator.m_207976_(p_208018_, p_208022_, p_208024_, $$8), p_208022_, $$11 = arg_0 -> this.m_211670_($$10 = $$8.m_209752_(), arg_0));
        if ($$12.m_73603_()) {
            p_208018_.m_207806_(p_208024_, $$8, $$12, p_208022_);
            return true;
        }
        return false;
    }

    private static int m_207976_(StructureFeatureManager p_207977_, ChunkAccess p_207978_, SectionPos p_207979_, ConfiguredStructureFeature<?, ?> p_207980_) {
        StructureStart $$4 = p_207977_.m_207802_(p_207979_, p_207980_, p_207978_);
        return $$4 != null ? $$4.m_73608_() : 0;
    }

    protected Holder<Biome> m_203427_(Holder<Biome> p_204385_) {
        return p_204385_;
    }

    public void m_62177_(WorldGenLevel p_62178_, StructureFeatureManager p_62179_, ChunkAccess p_62180_) {
        int $$3 = 8;
        ChunkPos $$4 = p_62180_.m_7697_();
        int $$5 = $$4.f_45578_;
        int $$6 = $$4.f_45579_;
        int $$7 = $$4.m_45604_();
        int $$8 = $$4.m_45605_();
        SectionPos $$9 = SectionPos.m_175562_(p_62180_);
        for (int $$10 = $$5 - 8; $$10 <= $$5 + 8; ++$$10) {
            for (int $$11 = $$6 - 8; $$11 <= $$6 + 8; ++$$11) {
                long $$12 = ChunkPos.m_45589_($$10, $$11);
                for (StructureStart $$13 : p_62178_.m_6325_($$10, $$11).m_6633_().values()) {
                    try {
                        if (!$$13.m_73603_() || !$$13.m_73601_().m_71019_($$7, $$8, $$7 + 15, $$8 + 15)) continue;
                        p_62179_.m_207797_($$9, $$13.m_210081_(), $$12, p_62180_);
                        DebugPackets.m_133711_(p_62178_, $$13);
                    }
                    catch (Exception $$14) {
                        CrashReport $$15 = CrashReport.m_127521_($$14, "Generating structure reference");
                        CrashReportCategory $$16 = $$15.m_127514_("Structure");
                        Optional<Registry<ConfiguredStructureFeature<?, ?>>> $$17 = p_62178_.m_5962_().m_6632_(Registry.f_122882_);
                        $$16.m_128165_("Id", () -> $$17.map(p_211661_ -> p_211661_.m_7981_($$13.m_210081_()).toString()).orElse("UNKNOWN"));
                        $$16.m_128165_("Name", () -> Registry.f_122841_.m_7981_((StructureFeature<?>)p_208029_.m_210081_().f_65403_).toString());
                        $$16.m_128165_("Class", () -> $$13.m_210081_().getClass().getCanonicalName());
                        throw new ReportedException($$15);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> m_183489_(Executor var1, Blender var2, StructureFeatureManager var3, ChunkAccess var4);

    public abstract int m_6337_();

    public abstract int m_142062_();

    public abstract int m_142647_(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4);

    public abstract NoiseColumn m_141914_(int var1, int var2, LevelHeightAccessor var3);

    public int m_156174_(int p_156175_, int p_156176_, Heightmap.Types p_156177_, LevelHeightAccessor p_156178_) {
        return this.m_142647_(p_156175_, p_156176_, p_156177_, p_156178_);
    }

    public int m_156179_(int p_156180_, int p_156181_, Heightmap.Types p_156182_, LevelHeightAccessor p_156183_) {
        return this.m_142647_(p_156180_, p_156181_, p_156182_, p_156183_) - 1;
    }

    public void m_211700_() {
        if (!this.f_207958_) {
            this.m_208097_();
            this.f_207958_ = true;
        }
    }

    @Nullable
    public List<ChunkPos> m_204380_(ConcentricRingsStructurePlacement p_204381_) {
        this.m_211700_();
        CompletableFuture<List<ChunkPos>> $$1 = this.f_204350_.get(p_204381_);
        return $$1 != null ? $$1.join() : null;
    }

    private List<StructurePlacement> m_208090_(Holder<ConfiguredStructureFeature<?, ?>> p_208091_) {
        this.m_211700_();
        return this.f_207957_.getOrDefault(p_208091_.m_203334_(), List.of());
    }

    public abstract void m_207076_(List<String> var1, BlockPos var2);

    private /* synthetic */ boolean m_211670_(HolderSet p_211671_, Holder p_211672_) {
        return p_211671_.m_203333_(this.m_203427_(p_211672_));
    }

    private static /* synthetic */ void m_211679_(IntSet p_211680_, BiomeSource.StepFeatureData p_211681_, PlacedFeature p_211682_) {
        p_211680_.add(p_211681_.f_196678_().applyAsInt(p_211682_));
    }

    private static /* synthetic */ void m_211648_(WorldGenLevel p_211649_, Set p_211650_, ChunkPos p_211651_) {
        ChunkAccess $$3 = p_211649_.m_6325_(p_211651_.f_45578_, p_211651_.f_45579_);
        for (LevelChunkSection $$4 : $$3.m_7103_()) {
            $$4.m_188013_().m_196879_(p_211688_ -> p_211650_.add((Biome)p_211688_.m_203334_()));
        }
    }

    static {
        Registry.m_122961_(Registry.f_122890_, "noise", NoiseBasedChunkGenerator.f_64314_);
        Registry.m_122961_(Registry.f_122890_, "flat", FlatLevelSource.f_64164_);
        Registry.m_122961_(Registry.f_122890_, "debug", DebugLevelSource.f_64111_);
        f_211627_ = LogUtils.getLogger();
        f_62136_ = Registry.f_122890_.m_194605_().dispatchStable(ChunkGenerator::m_6909_, Function.identity());
    }
}

