/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> f_208259_ = Registry.f_211076_.m_194605_().dispatch(DensityFunction::m_207500_, Function.identity());
    protected static final double f_208257_ = 1000000.0;
    static final Codec<Double> f_208260_ = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> f_208258_ = Codec.either(f_208260_, f_208259_).xmap(p_208274_ -> (DensityFunction)p_208274_.map(DensityFunctions::m_208264_, Function.identity()), p_208392_ -> {
        if (p_208392_ instanceof Constant) {
            Constant $$1 = (Constant)p_208392_;
            return Either.left((Object)$$1.f_208607_());
        }
        return Either.right((Object)p_208392_);
    });

    public static Codec<? extends DensityFunction> m_208342_(Registry<Codec<? extends DensityFunction>> p_208343_) {
        DensityFunctions.m_208344_(p_208343_, "blend_alpha", BlendAlpha.f_208528_);
        DensityFunctions.m_208344_(p_208343_, "blend_offset", BlendOffset.f_208565_);
        DensityFunctions.m_208344_(p_208343_, "beardifier", (Codec<? extends DensityFunction>)BeardifierMarker.f_208524_);
        DensityFunctions.m_208344_(p_208343_, "old_blended_noise", BlendedNoise.f_210616_);
        for (Marker.Type type : Marker.Type.values()) {
            DensityFunctions.m_208344_(p_208343_, type.m_7912_(), type.f_208731_);
        }
        DensityFunctions.m_208344_(p_208343_, "noise", Noise.f_208785_);
        DensityFunctions.m_208344_(p_208343_, "end_islands", EndIslandDensityFunction.f_208626_);
        DensityFunctions.m_208344_(p_208343_, "weird_scaled_sampler", WeirdScaledSampler.f_208424_);
        DensityFunctions.m_208344_(p_208343_, "shifted_noise", ShiftedNoise.f_208923_);
        DensityFunctions.m_208344_(p_208343_, "range_choice", RangeChoice.f_208822_);
        DensityFunctions.m_208344_(p_208343_, "shift_a", ShiftA.f_208878_);
        DensityFunctions.m_208344_(p_208343_, "shift_b", ShiftB.f_208898_);
        DensityFunctions.m_208344_(p_208343_, "shift", Shift.f_208858_);
        DensityFunctions.m_208344_(p_208343_, "blend_density", BlendDensity.f_208547_);
        DensityFunctions.m_208344_(p_208343_, "clamp", Clamp.f_208583_);
        for (Enum enum_ : Mapped.Type.values()) {
            DensityFunctions.m_208344_(p_208343_, ((Mapped.Type)enum_).m_7912_(), ((Mapped.Type)enum_).f_208691_);
        }
        DensityFunctions.m_208344_(p_208343_, "slide", Slide.f_208971_);
        for (Enum enum_ : TwoArgumentSimpleFunction.Type.values()) {
            DensityFunctions.m_208344_(p_208343_, ((TwoArgumentSimpleFunction.Type)enum_).m_7912_(), ((TwoArgumentSimpleFunction.Type)enum_).f_209082_);
        }
        DensityFunctions.m_208344_(p_208343_, "spline", Spline.f_211701_);
        DensityFunctions.m_208344_(p_208343_, "terrain_shaper_spline", TerrainShaperSpline.f_208994_);
        DensityFunctions.m_208344_(p_208343_, "constant", Constant.f_208608_);
        return DensityFunctions.m_208344_(p_208343_, "y_clamped_gradient", YClampedGradient.f_208480_);
    }

    private static Codec<? extends DensityFunction> m_208344_(Registry<Codec<? extends DensityFunction>> p_208345_, String p_208346_, Codec<? extends DensityFunction> p_208347_) {
        return Registry.m_122961_(p_208345_, p_208346_, p_208347_);
    }

    static <A, O> Codec<O> m_208275_(Codec<A> p_208276_, Function<A, O> p_208277_, Function<O, A> p_208278_) {
        return p_208276_.fieldOf("argument").xmap(p_208277_, p_208278_).codec();
    }

    static <O> Codec<O> m_208352_(Function<DensityFunction, O> p_208353_, Function<O, DensityFunction> p_208354_) {
        return DensityFunctions.m_208275_(DensityFunction.f_208218_, p_208353_, p_208354_);
    }

    static <O> Codec<O> m_208348_(BiFunction<DensityFunction, DensityFunction, O> p_208349_, Function<O, DensityFunction> p_208350_, Function<O, DensityFunction> p_208351_) {
        return RecordCodecBuilder.create(p_208359_ -> p_208359_.group((App)DensityFunction.f_208218_.fieldOf("argument1").forGetter(p_208350_), (App)DensityFunction.f_208218_.fieldOf("argument2").forGetter(p_208351_)).apply((Applicative)p_208359_, p_208349_));
    }

    static <O> Codec<O> m_208279_(MapCodec<O> p_208280_) {
        return p_208280_.codec();
    }

    private DensityFunctions() {
    }

    public static DensityFunction m_208281_(DensityFunction p_208282_) {
        return new Marker(Marker.Type.Interpolated, p_208282_);
    }

    public static DensityFunction m_208361_(DensityFunction p_208362_) {
        return new Marker(Marker.Type.FlatCache, p_208362_);
    }

    public static DensityFunction m_208373_(DensityFunction p_208374_) {
        return new Marker(Marker.Type.Cache2D, p_208374_);
    }

    public static DensityFunction m_208380_(DensityFunction p_208381_) {
        return new Marker(Marker.Type.CacheOnce, p_208381_);
    }

    public static DensityFunction m_208387_(DensityFunction p_208388_) {
        return new Marker(Marker.Type.CacheAllInCell, p_208388_);
    }

    public static DensityFunction m_208336_(Holder<NormalNoise.NoiseParameters> p_208337_, @Deprecated double p_208338_, double p_208339_, double p_208340_, double p_208341_) {
        return DensityFunctions.m_208283_(new Noise(p_208337_, null, p_208338_, p_208339_), p_208340_, p_208341_);
    }

    public static DensityFunction m_208331_(Holder<NormalNoise.NoiseParameters> p_208332_, double p_208333_, double p_208334_, double p_208335_) {
        return DensityFunctions.m_208336_(p_208332_, 1.0, p_208333_, p_208334_, p_208335_);
    }

    public static DensityFunction m_208327_(Holder<NormalNoise.NoiseParameters> p_208328_, double p_208329_, double p_208330_) {
        return DensityFunctions.m_208336_(p_208328_, 1.0, 1.0, p_208329_, p_208330_);
    }

    public static DensityFunction m_208296_(DensityFunction p_208297_, DensityFunction p_208298_, double p_208299_, Holder<NormalNoise.NoiseParameters> p_208300_) {
        return new ShiftedNoise(p_208297_, DensityFunctions.m_208263_(), p_208298_, p_208299_, 0.0, p_208300_, null);
    }

    public static DensityFunction m_208322_(Holder<NormalNoise.NoiseParameters> p_208323_) {
        return DensityFunctions.m_208368_(p_208323_, 1.0, 1.0);
    }

    public static DensityFunction m_208368_(Holder<NormalNoise.NoiseParameters> p_208369_, double p_208370_, double p_208371_) {
        return new Noise(p_208369_, null, p_208370_, p_208371_);
    }

    public static DensityFunction m_208324_(Holder<NormalNoise.NoiseParameters> p_208325_, double p_208326_) {
        return DensityFunctions.m_208368_(p_208325_, 1.0, p_208326_);
    }

    public static DensityFunction m_208287_(DensityFunction p_208288_, double p_208289_, double p_208290_, DensityFunction p_208291_, DensityFunction p_208292_) {
        return new RangeChoice(p_208288_, p_208289_, p_208290_, p_208291_, p_208292_);
    }

    public static DensityFunction m_208366_(Holder<NormalNoise.NoiseParameters> p_208367_) {
        return new ShiftA(p_208367_, null);
    }

    public static DensityFunction m_208378_(Holder<NormalNoise.NoiseParameters> p_208379_) {
        return new ShiftB(p_208379_, null);
    }

    public static DensityFunction m_208385_(Holder<NormalNoise.NoiseParameters> p_208386_) {
        return new Shift(p_208386_, null);
    }

    public static DensityFunction m_208389_(DensityFunction p_208390_) {
        return new BlendDensity(p_208390_);
    }

    public static DensityFunction m_208271_(long p_208272_) {
        return new EndIslandDensityFunction(p_208272_);
    }

    public static DensityFunction m_208315_(DensityFunction p_208316_, Holder<NormalNoise.NoiseParameters> p_208317_, WeirdScaledSampler.RarityValueMapper p_208318_) {
        return new WeirdScaledSampler(p_208316_, p_208317_, null, p_208318_);
    }

    public static DensityFunction m_208319_(NoiseSettings p_208320_, DensityFunction p_208321_) {
        return new Slide(p_208320_, p_208321_);
    }

    public static DensityFunction m_208293_(DensityFunction p_208294_, DensityFunction p_208295_) {
        return TwoArgumentSimpleFunction.m_209073_(TwoArgumentSimpleFunction.Type.ADD, p_208294_, p_208295_);
    }

    public static DensityFunction m_208363_(DensityFunction p_208364_, DensityFunction p_208365_) {
        return TwoArgumentSimpleFunction.m_209073_(TwoArgumentSimpleFunction.Type.MUL, p_208364_, p_208365_);
    }

    public static DensityFunction m_208375_(DensityFunction p_208376_, DensityFunction p_208377_) {
        return TwoArgumentSimpleFunction.m_209073_(TwoArgumentSimpleFunction.Type.MIN, p_208376_, p_208377_);
    }

    public static DensityFunction m_208382_(DensityFunction p_208383_, DensityFunction p_208384_) {
        return TwoArgumentSimpleFunction.m_209073_(TwoArgumentSimpleFunction.Type.MAX, p_208383_, p_208384_);
    }

    public static DensityFunction m_208305_(DensityFunction p_208306_, DensityFunction p_208307_, DensityFunction p_208308_, TerrainShaperSpline.SplineType p_208309_, double p_208310_, double p_208311_) {
        return new TerrainShaperSpline(p_208306_, p_208307_, p_208308_, null, p_208309_, p_208310_, p_208311_);
    }

    public static DensityFunction m_208263_() {
        return Constant.f_208609_;
    }

    public static DensityFunction m_208264_(double p_208265_) {
        return new Constant(p_208265_);
    }

    public static DensityFunction m_208266_(int p_208267_, int p_208268_, double p_208269_, double p_208270_) {
        return new YClampedGradient(p_208267_, p_208268_, p_208269_, p_208270_);
    }

    public static DensityFunction m_208312_(DensityFunction p_208313_, Mapped.Type p_208314_) {
        return Mapped.m_208671_(p_208314_, p_208313_);
    }

    private static DensityFunction m_208283_(DensityFunction p_208284_, double p_208285_, double p_208286_) {
        double $$3 = (p_208285_ + p_208286_) * 0.5;
        double $$4 = (p_208286_ - p_208285_) * 0.5;
        return DensityFunctions.m_208293_(DensityFunctions.m_208264_($$3), DensityFunctions.m_208363_(DensityFunctions.m_208264_($$4), p_208284_));
    }

    public static DensityFunction m_208360_() {
        return BlendAlpha.INSTANCE;
    }

    public static DensityFunction m_208372_() {
        return BlendOffset.INSTANCE;
    }

    public static DensityFunction m_208301_(DensityFunction p_208302_, DensityFunction p_208303_, DensityFunction p_208304_) {
        DensityFunction $$3 = DensityFunctions.m_208380_(p_208302_);
        DensityFunction $$4 = DensityFunctions.m_208293_(DensityFunctions.m_208363_($$3, DensityFunctions.m_208264_(-1.0)), DensityFunctions.m_208264_(1.0));
        return DensityFunctions.m_208293_(DensityFunctions.m_208363_(p_208303_, $$4), DensityFunctions.m_208363_(p_208304_, $$3));
    }

    protected static final class BlendAlpha
    extends Enum<BlendAlpha>
    implements DensityFunction.SimpleFunction {
        public static final /* enum */ BlendAlpha INSTANCE = new BlendAlpha();
        public static final Codec<DensityFunction> f_208528_;
        private static final /* synthetic */ BlendAlpha[] $VALUES;

        public static BlendAlpha[] values() {
            return (BlendAlpha[])$VALUES.clone();
        }

        public static BlendAlpha valueOf(String p_208544_) {
            return Enum.valueOf(BlendAlpha.class, p_208544_);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208536_) {
            return 1.0;
        }

        @Override
        public void m_207362_(double[] p_208538_, DensityFunction.ContextProvider p_208539_) {
            Arrays.fill(p_208538_, 1.0);
        }

        @Override
        public double m_207402_() {
            return 1.0;
        }

        @Override
        public double m_207401_() {
            return 1.0;
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208528_;
        }

        private static /* synthetic */ BlendAlpha[] m_208542_() {
            return new BlendAlpha[]{INSTANCE};
        }

        static {
            $VALUES = BlendAlpha.m_208542_();
            f_208528_ = Codec.unit((Object)INSTANCE);
        }
    }

    protected static final class BlendOffset
    extends Enum<BlendOffset>
    implements DensityFunction.SimpleFunction {
        public static final /* enum */ BlendOffset INSTANCE = new BlendOffset();
        public static final Codec<DensityFunction> f_208565_;
        private static final /* synthetic */ BlendOffset[] $VALUES;

        public static BlendOffset[] values() {
            return (BlendOffset[])$VALUES.clone();
        }

        public static BlendOffset valueOf(String p_208581_) {
            return Enum.valueOf(BlendOffset.class, p_208581_);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208573_) {
            return 0.0;
        }

        @Override
        public void m_207362_(double[] p_208575_, DensityFunction.ContextProvider p_208576_) {
            Arrays.fill(p_208575_, 0.0);
        }

        @Override
        public double m_207402_() {
            return 0.0;
        }

        @Override
        public double m_207401_() {
            return 0.0;
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208565_;
        }

        private static /* synthetic */ BlendOffset[] m_208579_() {
            return new BlendOffset[]{INSTANCE};
        }

        static {
            $VALUES = BlendOffset.m_208579_();
            f_208565_ = Codec.unit((Object)INSTANCE);
        }
    }

    protected static final class BeardifierMarker
    extends Enum<BeardifierMarker>
    implements BeardifierOrMarker {
        public static final /* enum */ BeardifierMarker INSTANCE = new BeardifierMarker();
        private static final /* synthetic */ BeardifierMarker[] $VALUES;

        public static BeardifierMarker[] values() {
            return (BeardifierMarker[])$VALUES.clone();
        }

        public static BeardifierMarker valueOf(String p_208522_) {
            return Enum.valueOf(BeardifierMarker.class, p_208522_);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208515_) {
            return 0.0;
        }

        @Override
        public void m_207362_(double[] p_208517_, DensityFunction.ContextProvider p_208518_) {
            Arrays.fill(p_208517_, 0.0);
        }

        @Override
        public double m_207402_() {
            return 0.0;
        }

        @Override
        public double m_207401_() {
            return 0.0;
        }

        private static /* synthetic */ BeardifierMarker[] m_208520_() {
            return new BeardifierMarker[]{INSTANCE};
        }

        static {
            $VALUES = BeardifierMarker.m_208520_();
        }
    }

    protected static final class Marker
    extends Record
    implements MarkerOrMarked {
        private final Type f_208705_;
        private final DensityFunction f_208706_;

        protected Marker(Type f_208705_, DensityFunction f_208706_) {
            this.f_208705_ = f_208705_;
            this.f_208706_ = f_208706_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208712_) {
            return this.f_208706_.m_207386_(p_208712_);
        }

        @Override
        public void m_207362_(double[] p_208716_, DensityFunction.ContextProvider p_208717_) {
            this.f_208706_.m_207362_(p_208716_, p_208717_);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208714_) {
            return (DensityFunction)p_208714_.apply(new Marker(this.f_208705_, this.f_208706_.m_207456_(p_208714_)));
        }

        @Override
        public double m_207402_() {
            return this.f_208706_.m_207402_();
        }

        @Override
        public double m_207401_() {
            return this.f_208706_.m_207401_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Marker.class, "type;wrapped", "f_208705_", "f_208706_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Marker.class, "type;wrapped", "f_208705_", "f_208706_"}, this);
        }

        @Override
        public final boolean equals(Object p_208720_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Marker.class, "type;wrapped", "f_208705_", "f_208706_"}, this, p_208720_);
        }

        @Override
        public Type m_207136_() {
            return this.f_208705_;
        }

        @Override
        public DensityFunction m_207056_() {
            return this.f_208706_;
        }

        static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            public static final /* enum */ Type Interpolated = new Type("interpolated");
            public static final /* enum */ Type FlatCache = new Type("flat_cache");
            public static final /* enum */ Type Cache2D = new Type("cache_2d");
            public static final /* enum */ Type CacheOnce = new Type("cache_once");
            public static final /* enum */ Type CacheAllInCell = new Type("cache_all_in_cell");
            private final String f_208730_;
            final Codec<MarkerOrMarked> f_208731_ = DensityFunctions.m_208352_(p_208740_ -> new Marker(this, (DensityFunction)p_208740_), MarkerOrMarked::m_207056_);
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String p_208743_) {
                return Enum.valueOf(Type.class, p_208743_);
            }

            private Type(String p_208737_) {
                this.f_208730_ = p_208737_;
            }

            @Override
            public String m_7912_() {
                return this.f_208730_;
            }

            private static /* synthetic */ Type[] m_208738_() {
                return new Type[]{Interpolated, FlatCache, Cache2D, CacheOnce, CacheAllInCell};
            }

            static {
                $VALUES = Type.m_208738_();
            }
        }
    }

    protected record Noise(Holder<NormalNoise.NoiseParameters> f_208786_, @Nullable NormalNoise f_208787_, @Deprecated double f_208788_, double f_208789_) implements DensityFunction.SimpleFunction
    {
        public static final MapCodec<Noise> f_208784_ = RecordCodecBuilder.mapCodec(p_208798_ -> p_208798_.group((App)NormalNoise.NoiseParameters.f_192852_.fieldOf("noise").forGetter(Noise::f_208786_), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(Noise::f_208788_), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(Noise::f_208789_)).apply((Applicative)p_208798_, Noise::m_208801_));
        public static final Codec<Noise> f_208785_ = DensityFunctions.m_208279_(f_208784_);

        public static Noise m_208801_(Holder<NormalNoise.NoiseParameters> p_208802_, @Deprecated double p_208803_, double p_208804_) {
            return new Noise(p_208802_, null, p_208803_, p_208804_);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208800_) {
            return this.f_208787_ == null ? 0.0 : this.f_208787_.m_75380_((double)p_208800_.m_207115_() * this.f_208788_, (double)p_208800_.m_207114_() * this.f_208789_, (double)p_208800_.m_207113_() * this.f_208788_);
        }

        @Override
        public double m_207402_() {
            return -this.m_207401_();
        }

        @Override
        public double m_207401_() {
            return this.f_208787_ == null ? 2.0 : this.f_208787_.m_210630_();
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208785_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Noise.class, "noiseData;noise;xzScale;yScale", "f_208786_", "f_208787_", "f_208788_", "f_208789_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Noise.class, "noiseData;noise;xzScale;yScale", "f_208786_", "f_208787_", "f_208788_", "f_208789_"}, this);
        }

        @Override
        public final boolean equals(Object p_208808_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Noise.class, "noiseData;noise;xzScale;yScale", "f_208786_", "f_208787_", "f_208788_", "f_208789_"}, this, p_208808_);
        }
    }

    protected static final class EndIslandDensityFunction
    implements DensityFunction.SimpleFunction {
        public static final Codec<EndIslandDensityFunction> f_208626_ = Codec.unit((Object)new EndIslandDensityFunction(0L));
        final SimplexNoise f_208627_;

        public EndIslandDensityFunction(long p_208630_) {
            LegacyRandomSource $$1 = new LegacyRandomSource(p_208630_);
            $$1.m_158876_(17292);
            this.f_208627_ = new SimplexNoise($$1);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208633_) {
            return ((double)TheEndBiomeSource.m_48645_(this.f_208627_, p_208633_.m_207115_() / 8, p_208633_.m_207113_() / 8) - 8.0) / 128.0;
        }

        @Override
        public double m_207402_() {
            return -0.84375;
        }

        @Override
        public double m_207401_() {
            return 0.5625;
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208626_;
        }
    }

    protected static final class WeirdScaledSampler
    extends Record
    implements TransformerWithContext {
        private final DensityFunction f_208425_;
        private final Holder<NormalNoise.NoiseParameters> f_208426_;
        @Nullable
        private final NormalNoise f_208427_;
        private final RarityValueMapper f_208428_;
        private static final MapCodec<WeirdScaledSampler> f_208429_ = RecordCodecBuilder.mapCodec(p_208438_ -> p_208438_.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(WeirdScaledSampler::m_207189_), (App)NormalNoise.NoiseParameters.f_192852_.fieldOf("noise").forGetter(WeirdScaledSampler::f_208426_), (App)RarityValueMapper.f_208460_.fieldOf("rarity_value_mapper").forGetter(WeirdScaledSampler::f_208428_)).apply((Applicative)p_208438_, WeirdScaledSampler::m_208444_));
        public static final Codec<WeirdScaledSampler> f_208424_ = DensityFunctions.m_208279_(f_208429_);

        protected WeirdScaledSampler(DensityFunction f_208425_, Holder<NormalNoise.NoiseParameters> f_208426_, @Nullable NormalNoise f_208427_, RarityValueMapper f_208428_) {
            this.f_208425_ = f_208425_;
            this.f_208426_ = f_208426_;
            this.f_208427_ = f_208427_;
            this.f_208428_ = f_208428_;
        }

        public static WeirdScaledSampler m_208444_(DensityFunction p_208445_, Holder<NormalNoise.NoiseParameters> p_208446_, RarityValueMapper p_208447_) {
            return new WeirdScaledSampler(p_208445_, p_208446_, null, p_208447_);
        }

        @Override
        public double m_207219_(DensityFunction.FunctionContext p_208440_, double p_208441_) {
            if (this.f_208427_ == null) {
                return 0.0;
            }
            double $$2 = this.f_208428_.f_208463_.get(p_208441_);
            return $$2 * Math.abs(this.f_208427_.m_75380_((double)p_208440_.m_207115_() / $$2, (double)p_208440_.m_207114_() / $$2, (double)p_208440_.m_207113_() / $$2));
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208443_) {
            this.f_208425_.m_207456_(p_208443_);
            return (DensityFunction)p_208443_.apply(new WeirdScaledSampler(this.f_208425_.m_207456_(p_208443_), this.f_208426_, this.f_208427_, this.f_208428_));
        }

        @Override
        public double m_207402_() {
            return 0.0;
        }

        @Override
        public double m_207401_() {
            return this.f_208428_.f_208464_ * (this.f_208427_ == null ? 2.0 : this.f_208427_.m_210630_());
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208424_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WeirdScaledSampler.class, "input;noiseData;noise;rarityValueMapper", "f_208425_", "f_208426_", "f_208427_", "f_208428_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WeirdScaledSampler.class, "input;noiseData;noise;rarityValueMapper", "f_208425_", "f_208426_", "f_208427_", "f_208428_"}, this);
        }

        @Override
        public final boolean equals(Object p_208451_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WeirdScaledSampler.class, "input;noiseData;noise;rarityValueMapper", "f_208425_", "f_208426_", "f_208427_", "f_208428_"}, this, p_208451_);
        }

        @Override
        public DensityFunction m_207189_() {
            return this.f_208425_;
        }

        public Holder<NormalNoise.NoiseParameters> f_208426_() {
            return this.f_208426_;
        }

        @Nullable
        public NormalNoise f_208427_() {
            return this.f_208427_;
        }

        public RarityValueMapper f_208428_() {
            return this.f_208428_;
        }

        public static final class RarityValueMapper
        extends Enum<RarityValueMapper>
        implements StringRepresentable {
            public static final /* enum */ RarityValueMapper TYPE1 = new RarityValueMapper("type_1", NoiseRouterData.QuantizedSpaghettiRarity::m_209565_, 2.0);
            public static final /* enum */ RarityValueMapper TYPE2 = new RarityValueMapper("type_2", NoiseRouterData.QuantizedSpaghettiRarity::m_209563_, 3.0);
            private static final Map<String, RarityValueMapper> f_208461_;
            public static final Codec<RarityValueMapper> f_208460_;
            private final String f_208462_;
            final Double2DoubleFunction f_208463_;
            final double f_208464_;
            private static final /* synthetic */ RarityValueMapper[] $VALUES;

            public static RarityValueMapper[] values() {
                return (RarityValueMapper[])$VALUES.clone();
            }

            public static RarityValueMapper valueOf(String p_208478_) {
                return Enum.valueOf(RarityValueMapper.class, p_208478_);
            }

            private RarityValueMapper(String p_208470_, Double2DoubleFunction p_208471_, double p_208472_) {
                this.f_208462_ = p_208470_;
                this.f_208463_ = p_208471_;
                this.f_208464_ = p_208472_;
            }

            @Override
            public String m_7912_() {
                return this.f_208462_;
            }

            private static /* synthetic */ RarityValueMapper[] m_208473_() {
                return new RarityValueMapper[]{TYPE1, TYPE2};
            }

            static {
                $VALUES = RarityValueMapper.m_208473_();
                f_208461_ = Arrays.stream(RarityValueMapper.values()).collect(Collectors.toMap(RarityValueMapper::m_7912_, p_208475_ -> p_208475_));
                f_208460_ = StringRepresentable.m_14350_(RarityValueMapper::values, f_208461_::get);
            }
        }
    }

    protected record ShiftedNoise(DensityFunction f_208924_, DensityFunction f_208925_, DensityFunction f_208926_, double f_208927_, double f_208928_, Holder<NormalNoise.NoiseParameters> f_208929_, @Nullable NormalNoise f_208930_) implements DensityFunction
    {
        private static final MapCodec<ShiftedNoise> f_208931_ = RecordCodecBuilder.mapCodec(p_208943_ -> p_208943_.group((App)DensityFunction.f_208218_.fieldOf("shift_x").forGetter(ShiftedNoise::f_208924_), (App)DensityFunction.f_208218_.fieldOf("shift_y").forGetter(ShiftedNoise::f_208925_), (App)DensityFunction.f_208218_.fieldOf("shift_z").forGetter(ShiftedNoise::f_208926_), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(ShiftedNoise::f_208927_), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(ShiftedNoise::f_208928_), (App)NormalNoise.NoiseParameters.f_192852_.fieldOf("noise").forGetter(ShiftedNoise::f_208929_)).apply((Applicative)p_208943_, ShiftedNoise::m_208948_));
        public static final Codec<ShiftedNoise> f_208923_ = DensityFunctions.m_208279_(f_208931_);

        public static ShiftedNoise m_208948_(DensityFunction p_208949_, DensityFunction p_208950_, DensityFunction p_208951_, double p_208952_, double p_208953_, Holder<NormalNoise.NoiseParameters> p_208954_) {
            return new ShiftedNoise(p_208949_, p_208950_, p_208951_, p_208952_, p_208953_, p_208954_, null);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208945_) {
            if (this.f_208930_ == null) {
                return 0.0;
            }
            double $$1 = (double)p_208945_.m_207115_() * this.f_208927_ + this.f_208924_.m_207386_(p_208945_);
            double $$2 = (double)p_208945_.m_207114_() * this.f_208928_ + this.f_208925_.m_207386_(p_208945_);
            double $$3 = (double)p_208945_.m_207113_() * this.f_208927_ + this.f_208926_.m_207386_(p_208945_);
            return this.f_208930_.m_75380_($$1, $$2, $$3);
        }

        @Override
        public void m_207362_(double[] p_208956_, DensityFunction.ContextProvider p_208957_) {
            p_208957_.m_207207_(p_208956_, this);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208947_) {
            return (DensityFunction)p_208947_.apply(new ShiftedNoise(this.f_208924_.m_207456_(p_208947_), this.f_208925_.m_207456_(p_208947_), this.f_208926_.m_207456_(p_208947_), this.f_208927_, this.f_208928_, this.f_208929_, this.f_208930_));
        }

        @Override
        public double m_207402_() {
            return -this.m_207401_();
        }

        @Override
        public double m_207401_() {
            return this.f_208930_ == null ? 2.0 : this.f_208930_.m_210630_();
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208923_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShiftedNoise.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noiseData;noise", "f_208924_", "f_208925_", "f_208926_", "f_208927_", "f_208928_", "f_208929_", "f_208930_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShiftedNoise.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noiseData;noise", "f_208924_", "f_208925_", "f_208926_", "f_208927_", "f_208928_", "f_208929_", "f_208930_"}, this);
        }

        @Override
        public final boolean equals(Object p_208961_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShiftedNoise.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noiseData;noise", "f_208924_", "f_208925_", "f_208926_", "f_208927_", "f_208928_", "f_208929_", "f_208930_"}, this, p_208961_);
        }
    }

    record RangeChoice(DensityFunction f_208823_, double f_208824_, double f_208825_, DensityFunction f_208826_, DensityFunction f_208827_) implements DensityFunction
    {
        public static final MapCodec<RangeChoice> f_208821_ = RecordCodecBuilder.mapCodec(p_208837_ -> p_208837_.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(RangeChoice::f_208823_), (App)f_208260_.fieldOf("min_inclusive").forGetter(RangeChoice::f_208824_), (App)f_208260_.fieldOf("max_exclusive").forGetter(RangeChoice::f_208825_), (App)DensityFunction.f_208218_.fieldOf("when_in_range").forGetter(RangeChoice::f_208826_), (App)DensityFunction.f_208218_.fieldOf("when_out_of_range").forGetter(RangeChoice::f_208827_)).apply((Applicative)p_208837_, RangeChoice::new));
        public static final Codec<RangeChoice> f_208822_ = DensityFunctions.m_208279_(f_208821_);

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208839_) {
            double $$1 = this.f_208823_.m_207386_(p_208839_);
            if ($$1 >= this.f_208824_ && $$1 < this.f_208825_) {
                return this.f_208826_.m_207386_(p_208839_);
            }
            return this.f_208827_.m_207386_(p_208839_);
        }

        @Override
        public void m_207362_(double[] p_208843_, DensityFunction.ContextProvider p_208844_) {
            this.f_208823_.m_207362_(p_208843_, p_208844_);
            for (int $$2 = 0; $$2 < p_208843_.length; ++$$2) {
                double $$3 = p_208843_[$$2];
                p_208843_[$$2] = $$3 >= this.f_208824_ && $$3 < this.f_208825_ ? this.f_208826_.m_207386_(p_208844_.m_207263_($$2)) : this.f_208827_.m_207386_(p_208844_.m_207263_($$2));
            }
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208841_) {
            return (DensityFunction)p_208841_.apply(new RangeChoice(this.f_208823_.m_207456_(p_208841_), this.f_208824_, this.f_208825_, this.f_208826_.m_207456_(p_208841_), this.f_208827_.m_207456_(p_208841_)));
        }

        @Override
        public double m_207402_() {
            return Math.min(this.f_208826_.m_207402_(), this.f_208827_.m_207402_());
        }

        @Override
        public double m_207401_() {
            return Math.max(this.f_208826_.m_207401_(), this.f_208827_.m_207401_());
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208822_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RangeChoice.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f_208823_", "f_208824_", "f_208825_", "f_208826_", "f_208827_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RangeChoice.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f_208823_", "f_208824_", "f_208825_", "f_208826_", "f_208827_"}, this);
        }

        @Override
        public final boolean equals(Object p_208848_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RangeChoice.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f_208823_", "f_208824_", "f_208825_", "f_208826_", "f_208827_"}, this, p_208848_);
        }
    }

    protected static final class ShiftA
    extends Record
    implements ShiftNoise {
        private final Holder<NormalNoise.NoiseParameters> f_208876_;
        @Nullable
        private final NormalNoise f_208877_;
        static final Codec<ShiftA> f_208878_ = DensityFunctions.m_208275_(NormalNoise.NoiseParameters.f_192852_, p_208888_ -> new ShiftA((Holder<NormalNoise.NoiseParameters>)p_208888_, null), ShiftA::m_207183_);

        protected ShiftA(Holder<NormalNoise.NoiseParameters> f_208876_, @Nullable NormalNoise f_208877_) {
            this.f_208876_ = f_208876_;
            this.f_208877_ = f_208877_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208884_) {
            return this.m_208917_(p_208884_.m_207115_(), 0.0, p_208884_.m_207113_());
        }

        @Override
        public ShiftNoise m_207360_(NormalNoise p_208886_) {
            return new ShiftA(this.f_208876_, p_208886_);
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208878_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShiftA.class, "noiseData;offsetNoise", "f_208876_", "f_208877_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShiftA.class, "noiseData;offsetNoise", "f_208876_", "f_208877_"}, this);
        }

        @Override
        public final boolean equals(Object p_208891_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShiftA.class, "noiseData;offsetNoise", "f_208876_", "f_208877_"}, this, p_208891_);
        }

        @Override
        public Holder<NormalNoise.NoiseParameters> m_207183_() {
            return this.f_208876_;
        }

        @Override
        @Nullable
        public NormalNoise m_207488_() {
            return this.f_208877_;
        }
    }

    protected static final class ShiftB
    extends Record
    implements ShiftNoise {
        private final Holder<NormalNoise.NoiseParameters> f_208896_;
        @Nullable
        private final NormalNoise f_208897_;
        static final Codec<ShiftB> f_208898_ = DensityFunctions.m_208275_(NormalNoise.NoiseParameters.f_192852_, p_208908_ -> new ShiftB((Holder<NormalNoise.NoiseParameters>)p_208908_, null), ShiftB::m_207183_);

        protected ShiftB(Holder<NormalNoise.NoiseParameters> f_208896_, @Nullable NormalNoise f_208897_) {
            this.f_208896_ = f_208896_;
            this.f_208897_ = f_208897_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208904_) {
            return this.m_208917_(p_208904_.m_207113_(), p_208904_.m_207115_(), 0.0);
        }

        @Override
        public ShiftNoise m_207360_(NormalNoise p_208906_) {
            return new ShiftB(this.f_208896_, p_208906_);
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208898_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShiftB.class, "noiseData;offsetNoise", "f_208896_", "f_208897_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShiftB.class, "noiseData;offsetNoise", "f_208896_", "f_208897_"}, this);
        }

        @Override
        public final boolean equals(Object p_208911_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShiftB.class, "noiseData;offsetNoise", "f_208896_", "f_208897_"}, this, p_208911_);
        }

        @Override
        public Holder<NormalNoise.NoiseParameters> m_207183_() {
            return this.f_208896_;
        }

        @Override
        @Nullable
        public NormalNoise m_207488_() {
            return this.f_208897_;
        }
    }

    static final class Shift
    extends Record
    implements ShiftNoise {
        private final Holder<NormalNoise.NoiseParameters> f_208856_;
        @Nullable
        private final NormalNoise f_208857_;
        static final Codec<Shift> f_208858_ = DensityFunctions.m_208275_(NormalNoise.NoiseParameters.f_192852_, p_208868_ -> new Shift((Holder<NormalNoise.NoiseParameters>)p_208868_, null), Shift::m_207183_);

        Shift(Holder<NormalNoise.NoiseParameters> f_208856_, @Nullable NormalNoise f_208857_) {
            this.f_208856_ = f_208856_;
            this.f_208857_ = f_208857_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208864_) {
            return this.m_208917_(p_208864_.m_207115_(), p_208864_.m_207114_(), p_208864_.m_207113_());
        }

        @Override
        public ShiftNoise m_207360_(NormalNoise p_208866_) {
            return new Shift(this.f_208856_, p_208866_);
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208858_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Shift.class, "noiseData;offsetNoise", "f_208856_", "f_208857_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Shift.class, "noiseData;offsetNoise", "f_208856_", "f_208857_"}, this);
        }

        @Override
        public final boolean equals(Object p_208871_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Shift.class, "noiseData;offsetNoise", "f_208856_", "f_208857_"}, this, p_208871_);
        }

        @Override
        public Holder<NormalNoise.NoiseParameters> m_207183_() {
            return this.f_208856_;
        }

        @Override
        @Nullable
        public NormalNoise m_207488_() {
            return this.f_208857_;
        }
    }

    static final class BlendDensity
    extends Record
    implements TransformerWithContext {
        private final DensityFunction f_208546_;
        static final Codec<BlendDensity> f_208547_ = DensityFunctions.m_208352_(BlendDensity::new, BlendDensity::m_207189_);

        BlendDensity(DensityFunction f_208546_) {
            this.f_208546_ = f_208546_;
        }

        @Override
        public double m_207219_(DensityFunction.FunctionContext p_208553_, double p_208554_) {
            return p_208553_.m_207434_().m_207103_(p_208553_, p_208554_);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208556_) {
            return (DensityFunction)p_208556_.apply(new BlendDensity(this.f_208546_.m_207456_(p_208556_)));
        }

        @Override
        public double m_207402_() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double m_207401_() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208547_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlendDensity.class, "input", "f_208546_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlendDensity.class, "input", "f_208546_"}, this);
        }

        @Override
        public final boolean equals(Object p_208560_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlendDensity.class, "input", "f_208546_"}, this, p_208560_);
        }

        @Override
        public DensityFunction m_207189_() {
            return this.f_208546_;
        }
    }

    protected static final class Clamp
    extends Record
    implements PureTransformer {
        private final DensityFunction f_208584_;
        private final double f_208585_;
        private final double f_208586_;
        private static final MapCodec<Clamp> f_208587_ = RecordCodecBuilder.mapCodec(p_208597_ -> p_208597_.group((App)DensityFunction.f_208216_.fieldOf("input").forGetter(Clamp::m_207305_), (App)f_208260_.fieldOf("min").forGetter(Clamp::m_207402_), (App)f_208260_.fieldOf("max").forGetter(Clamp::m_207401_)).apply((Applicative)p_208597_, Clamp::new));
        public static final Codec<Clamp> f_208583_ = DensityFunctions.m_208279_(f_208587_);

        protected Clamp(DensityFunction f_208584_, double f_208585_, double f_208586_) {
            this.f_208584_ = f_208584_;
            this.f_208585_ = f_208585_;
            this.f_208586_ = f_208586_;
        }

        @Override
        public double m_207382_(double p_208595_) {
            return Mth.m_14008_(p_208595_, this.f_208585_, this.f_208586_);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208599_) {
            return new Clamp(this.f_208584_.m_207456_(p_208599_), this.f_208585_, this.f_208586_);
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208583_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Clamp.class, "input;minValue;maxValue", "f_208584_", "f_208585_", "f_208586_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Clamp.class, "input;minValue;maxValue", "f_208584_", "f_208585_", "f_208586_"}, this);
        }

        @Override
        public final boolean equals(Object p_208604_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Clamp.class, "input;minValue;maxValue", "f_208584_", "f_208585_", "f_208586_"}, this, p_208604_);
        }

        @Override
        public DensityFunction m_207305_() {
            return this.f_208584_;
        }

        @Override
        public double m_207402_() {
            return this.f_208585_;
        }

        @Override
        public double m_207401_() {
            return this.f_208586_;
        }
    }

    protected static final class Mapped
    extends Record
    implements PureTransformer {
        private final Type f_208654_;
        private final DensityFunction f_208655_;
        private final double f_208656_;
        private final double f_208657_;

        protected Mapped(Type f_208654_, DensityFunction f_208655_, double f_208656_, double f_208657_) {
            this.f_208654_ = f_208654_;
            this.f_208655_ = f_208655_;
            this.f_208656_ = f_208656_;
            this.f_208657_ = f_208657_;
        }

        public static Mapped m_208671_(Type p_208672_, DensityFunction p_208673_) {
            double $$2 = p_208673_.m_207402_();
            double $$3 = Mapped.m_208668_(p_208672_, $$2);
            double $$4 = Mapped.m_208668_(p_208672_, p_208673_.m_207401_());
            if (p_208672_ == Type.ABS || p_208672_ == Type.SQUARE) {
                return new Mapped(p_208672_, p_208673_, Math.max(0.0, $$2), Math.max($$3, $$4));
            }
            return new Mapped(p_208672_, p_208673_, $$3, $$4);
        }

        private static double m_208668_(Type p_208669_, double p_208670_) {
            return switch (p_208669_) {
                default -> throw new IncompatibleClassChangeError();
                case Type.ABS -> Math.abs(p_208670_);
                case Type.SQUARE -> p_208670_ * p_208670_;
                case Type.CUBE -> p_208670_ * p_208670_ * p_208670_;
                case Type.HALF_NEGATIVE -> {
                    if (p_208670_ > 0.0) {
                        yield p_208670_;
                    }
                    yield p_208670_ * 0.5;
                }
                case Type.QUARTER_NEGATIVE -> {
                    if (p_208670_ > 0.0) {
                        yield p_208670_;
                    }
                    yield p_208670_ * 0.25;
                }
                case Type.SQUEEZE -> {
                    double $$2 = Mth.m_14008_(p_208670_, -1.0, 1.0);
                    yield $$2 / 2.0 - $$2 * $$2 * $$2 / 24.0;
                }
            };
        }

        @Override
        public double m_207382_(double p_208665_) {
            return Mapped.m_208668_(this.f_208654_, p_208665_);
        }

        @Override
        public Mapped m_207456_(DensityFunction.Visitor p_208677_) {
            return Mapped.m_208671_(this.f_208654_, this.f_208655_.m_207456_(p_208677_));
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return this.f_208654_.f_208691_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Mapped.class, "type;input;minValue;maxValue", "f_208654_", "f_208655_", "f_208656_", "f_208657_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Mapped.class, "type;input;minValue;maxValue", "f_208654_", "f_208655_", "f_208656_", "f_208657_"}, this);
        }

        @Override
        public final boolean equals(Object p_208680_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Mapped.class, "type;input;minValue;maxValue", "f_208654_", "f_208655_", "f_208656_", "f_208657_"}, this, p_208680_);
        }

        public Type f_208654_() {
            return this.f_208654_;
        }

        @Override
        public DensityFunction m_207305_() {
            return this.f_208655_;
        }

        @Override
        public double m_207402_() {
            return this.f_208656_;
        }

        @Override
        public double m_207401_() {
            return this.f_208657_;
        }

        @Override
        public /* synthetic */ DensityFunction m_207456_(DensityFunction.Visitor visitor) {
            return this.m_207456_(visitor);
        }

        static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            public static final /* enum */ Type ABS = new Type("abs");
            public static final /* enum */ Type SQUARE = new Type("square");
            public static final /* enum */ Type CUBE = new Type("cube");
            public static final /* enum */ Type HALF_NEGATIVE = new Type("half_negative");
            public static final /* enum */ Type QUARTER_NEGATIVE = new Type("quarter_negative");
            public static final /* enum */ Type SQUEEZE = new Type("squeeze");
            private final String f_208690_;
            final Codec<Mapped> f_208691_ = DensityFunctions.m_208352_(p_208700_ -> Mapped.m_208671_(this, p_208700_), Mapped::m_207305_);
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String p_208703_) {
                return Enum.valueOf(Type.class, p_208703_);
            }

            private Type(String p_208697_) {
                this.f_208690_ = p_208697_;
            }

            @Override
            public String m_7912_() {
                return this.f_208690_;
            }

            private static /* synthetic */ Type[] m_208698_() {
                return new Type[]{ABS, SQUARE, CUBE, HALF_NEGATIVE, QUARTER_NEGATIVE, SQUEEZE};
            }

            static {
                $VALUES = Type.m_208698_();
            }
        }
    }

    protected static final class Slide
    extends Record
    implements TransformerWithContext {
        @Nullable
        private final NoiseSettings f_208972_;
        private final DensityFunction f_208973_;
        public static final Codec<Slide> f_208971_ = DensityFunctions.m_208352_(p_208985_ -> new Slide(null, (DensityFunction)p_208985_), Slide::m_207189_);

        protected Slide(@Nullable NoiseSettings f_208972_, DensityFunction f_208973_) {
            this.f_208972_ = f_208972_;
            this.f_208973_ = f_208973_;
        }

        @Override
        public double m_207219_(DensityFunction.FunctionContext p_208980_, double p_208981_) {
            if (this.f_208972_ == null) {
                return p_208981_;
            }
            return NoiseRouterData.m_209498_(this.f_208972_, p_208981_, p_208980_.m_207114_());
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208983_) {
            return (DensityFunction)p_208983_.apply(new Slide(this.f_208972_, this.f_208973_.m_207456_(p_208983_)));
        }

        @Override
        public double m_207402_() {
            if (this.f_208972_ == null) {
                return this.f_208973_.m_207402_();
            }
            return Math.min(this.f_208973_.m_207402_(), Math.min(this.f_208972_.f_64511_().f_189224_(), this.f_208972_.f_64510_().f_189224_()));
        }

        @Override
        public double m_207401_() {
            if (this.f_208972_ == null) {
                return this.f_208973_.m_207401_();
            }
            return Math.max(this.f_208973_.m_207401_(), Math.max(this.f_208972_.f_64511_().f_189224_(), this.f_208972_.f_64510_().f_189224_()));
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208971_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Slide.class, "settings;input", "f_208972_", "f_208973_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Slide.class, "settings;input", "f_208972_", "f_208973_"}, this);
        }

        @Override
        public final boolean equals(Object p_208989_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Slide.class, "settings;input", "f_208972_", "f_208973_"}, this, p_208989_);
        }

        @Nullable
        public NoiseSettings f_208972_() {
            return this.f_208972_;
        }

        @Override
        public DensityFunction m_207189_() {
            return this.f_208973_;
        }
    }

    static interface TwoArgumentSimpleFunction
    extends DensityFunction {
        public static final Logger f_209071_ = LogUtils.getLogger();

        public static TwoArgumentSimpleFunction m_209073_(Type p_209074_, DensityFunction p_209075_, DensityFunction p_209076_) {
            double $$10;
            double $$3 = p_209075_.m_207402_();
            double $$4 = p_209076_.m_207402_();
            double $$5 = p_209075_.m_207401_();
            double $$6 = p_209076_.m_207401_();
            if (p_209074_ == Type.MIN || p_209074_ == Type.MAX) {
                boolean $$8;
                boolean $$7 = $$3 >= $$6;
                boolean bl = $$8 = $$4 >= $$5;
                if ($$7 || $$8) {
                    f_209071_.warn("Creating a " + p_209074_ + " function between two non-overlapping inputs: " + p_209075_ + " and " + p_209076_);
                }
            }
            double $$9 = switch (p_209074_) {
                default -> throw new IncompatibleClassChangeError();
                case Type.ADD -> $$3 + $$4;
                case Type.MAX -> Math.max($$3, $$4);
                case Type.MIN -> Math.min($$3, $$4);
                case Type.MUL -> $$3 > 0.0 && $$4 > 0.0 ? $$3 * $$4 : ($$5 < 0.0 && $$6 < 0.0 ? $$5 * $$6 : Math.min($$3 * $$6, $$5 * $$4));
            };
            switch (p_209074_) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD: {
                    double d = $$5 + $$6;
                    break;
                }
                case MAX: {
                    double d = Math.max($$5, $$6);
                    break;
                }
                case MIN: {
                    double d = Math.min($$5, $$6);
                    break;
                }
                case MUL: {
                    double d = $$3 > 0.0 && $$4 > 0.0 ? $$5 * $$6 : ($$10 = $$5 < 0.0 && $$6 < 0.0 ? $$3 * $$4 : Math.max($$3 * $$4, $$5 * $$6));
                }
            }
            if (p_209074_ == Type.MUL || p_209074_ == Type.ADD) {
                if (p_209075_ instanceof Constant) {
                    Constant $$11 = (Constant)p_209075_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209076_, $$9, $$10, $$11.f_208607_);
                }
                if (p_209076_ instanceof Constant) {
                    Constant $$12 = (Constant)p_209076_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209075_, $$9, $$10, $$12.f_208607_);
                }
            }
            return new Ap2(p_209074_, p_209075_, p_209076_, $$9, $$10);
        }

        public Type m_207119_();

        public DensityFunction m_207185_();

        public DensityFunction m_207190_();

        @Override
        default public Codec<? extends DensityFunction> m_207500_() {
            return this.m_207119_().f_209082_;
        }

        public static final class Type
        extends Enum<Type>
        implements StringRepresentable {
            public static final /* enum */ Type ADD = new Type("add");
            public static final /* enum */ Type MUL = new Type("mul");
            public static final /* enum */ Type MIN = new Type("min");
            public static final /* enum */ Type MAX = new Type("max");
            final Codec<TwoArgumentSimpleFunction> f_209082_ = DensityFunctions.m_208348_((p_209092_, p_209093_) -> TwoArgumentSimpleFunction.m_209073_(this, p_209092_, p_209093_), TwoArgumentSimpleFunction::m_207185_, TwoArgumentSimpleFunction::m_207190_);
            private final String f_209083_;
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String p_209096_) {
                return Enum.valueOf(Type.class, p_209096_);
            }

            private Type(String p_209089_) {
                this.f_209083_ = p_209089_;
            }

            @Override
            public String m_7912_() {
                return this.f_209083_;
            }

            private static /* synthetic */ Type[] m_209090_() {
                return new Type[]{ADD, MUL, MIN, MAX};
            }

            static {
                $VALUES = Type.m_209090_();
            }
        }
    }

    public static final class Spline
    extends Record
    implements DensityFunction {
        private final CubicSpline<TerrainShaper.PointCustom> f_211702_;
        private final double f_211703_;
        private final double f_211704_;
        private static final MapCodec<Spline> f_211705_ = RecordCodecBuilder.mapCodec(p_211713_ -> p_211713_.group((App)TerrainShaper.f_211598_.fieldOf("spline").forGetter(Spline::f_211702_), (App)f_208260_.fieldOf("min_value").forGetter(Spline::m_207402_), (App)f_208260_.fieldOf("max_value").forGetter(Spline::m_207401_)).apply((Applicative)p_211713_, Spline::new));
        public static final Codec<Spline> f_211701_ = DensityFunctions.m_208279_(f_211705_);

        public Spline(CubicSpline<TerrainShaper.PointCustom> f_211702_, double f_211703_, double f_211704_) {
            this.f_211702_ = f_211702_;
            this.f_211703_ = f_211703_;
            this.f_211704_ = f_211704_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_211715_) {
            return Mth.m_14008_(this.f_211702_.m_183321_(TerrainShaper.m_211599_(p_211715_)), this.f_211703_, this.f_211704_);
        }

        @Override
        public void m_207362_(double[] p_211722_, DensityFunction.ContextProvider p_211723_) {
            p_211723_.m_207207_(p_211722_, this);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_211717_) {
            return (DensityFunction)p_211717_.apply(new Spline(this.f_211702_.m_211396_(p_211720_ -> {
                ToFloatFunction toFloatFunction;
                if (p_211720_ instanceof TerrainShaper.CoordinateCustom) {
                    TerrainShaper.CoordinateCustom $$2 = (TerrainShaper.CoordinateCustom)p_211720_;
                    toFloatFunction = $$2.m_211611_(p_211717_);
                } else {
                    toFloatFunction = p_211720_;
                }
                return toFloatFunction;
            }), this.f_211703_, this.f_211704_));
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_211701_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Spline.class, "spline;minValue;maxValue", "f_211702_", "f_211703_", "f_211704_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Spline.class, "spline;minValue;maxValue", "f_211702_", "f_211703_", "f_211704_"}, this);
        }

        @Override
        public final boolean equals(Object p_211727_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Spline.class, "spline;minValue;maxValue", "f_211702_", "f_211703_", "f_211704_"}, this, p_211727_);
        }

        public CubicSpline<TerrainShaper.PointCustom> f_211702_() {
            return this.f_211702_;
        }

        @Override
        public double m_207402_() {
            return this.f_211703_;
        }

        @Override
        public double m_207401_() {
            return this.f_211704_;
        }
    }

    @Deprecated
    public static final class TerrainShaperSpline
    extends Record
    implements DensityFunction {
        private final DensityFunction f_208995_;
        private final DensityFunction f_208996_;
        private final DensityFunction f_208997_;
        @Nullable
        private final TerrainShaper f_208998_;
        private final SplineType f_208999_;
        private final double f_209000_;
        private final double f_209001_;
        private static final MapCodec<TerrainShaperSpline> f_209002_ = RecordCodecBuilder.mapCodec(p_209014_ -> p_209014_.group((App)DensityFunction.f_208218_.fieldOf("continentalness").forGetter(TerrainShaperSpline::f_208995_), (App)DensityFunction.f_208218_.fieldOf("erosion").forGetter(TerrainShaperSpline::f_208996_), (App)DensityFunction.f_208218_.fieldOf("weirdness").forGetter(TerrainShaperSpline::f_208997_), (App)SplineType.f_209046_.fieldOf("spline").forGetter(TerrainShaperSpline::f_208999_), (App)f_208260_.fieldOf("min_value").forGetter(TerrainShaperSpline::m_207402_), (App)f_208260_.fieldOf("max_value").forGetter(TerrainShaperSpline::m_207401_)).apply((Applicative)p_209014_, TerrainShaperSpline::m_209019_));
        public static final Codec<TerrainShaperSpline> f_208994_ = DensityFunctions.m_208279_(f_209002_);

        public TerrainShaperSpline(DensityFunction f_208995_, DensityFunction f_208996_, DensityFunction f_208997_, @Nullable TerrainShaper f_208998_, SplineType f_208999_, double f_209000_, double f_209001_) {
            this.f_208995_ = f_208995_;
            this.f_208996_ = f_208996_;
            this.f_208997_ = f_208997_;
            this.f_208998_ = f_208998_;
            this.f_208999_ = f_208999_;
            this.f_209000_ = f_209000_;
            this.f_209001_ = f_209001_;
        }

        public static TerrainShaperSpline m_209019_(DensityFunction p_209020_, DensityFunction p_209021_, DensityFunction p_209022_, SplineType p_209023_, double p_209024_, double p_209025_) {
            return new TerrainShaperSpline(p_209020_, p_209021_, p_209022_, null, p_209023_, p_209024_, p_209025_);
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_209016_) {
            if (this.f_208998_ == null) {
                return 0.0;
            }
            return Mth.m_14008_(this.f_208999_.f_209049_.m_209040_(this.f_208998_, TerrainShaper.m_187267_((float)this.f_208995_.m_207386_(p_209016_), (float)this.f_208996_.m_207386_(p_209016_), (float)this.f_208997_.m_207386_(p_209016_))), this.f_209000_, this.f_209001_);
        }

        @Override
        public void m_207362_(double[] p_209027_, DensityFunction.ContextProvider p_209028_) {
            for (int $$2 = 0; $$2 < p_209027_.length; ++$$2) {
                p_209027_[$$2] = this.m_207386_(p_209028_.m_207263_($$2));
            }
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_209018_) {
            return (DensityFunction)p_209018_.apply(new TerrainShaperSpline(this.f_208995_.m_207456_(p_209018_), this.f_208996_.m_207456_(p_209018_), this.f_208997_.m_207456_(p_209018_), this.f_208998_, this.f_208999_, this.f_209000_, this.f_209001_));
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208994_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TerrainShaperSpline.class, "continentalness;erosion;weirdness;shaper;spline;minValue;maxValue", "f_208995_", "f_208996_", "f_208997_", "f_208998_", "f_208999_", "f_209000_", "f_209001_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TerrainShaperSpline.class, "continentalness;erosion;weirdness;shaper;spline;minValue;maxValue", "f_208995_", "f_208996_", "f_208997_", "f_208998_", "f_208999_", "f_209000_", "f_209001_"}, this);
        }

        @Override
        public final boolean equals(Object p_209032_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TerrainShaperSpline.class, "continentalness;erosion;weirdness;shaper;spline;minValue;maxValue", "f_208995_", "f_208996_", "f_208997_", "f_208998_", "f_208999_", "f_209000_", "f_209001_"}, this, p_209032_);
        }

        public DensityFunction f_208995_() {
            return this.f_208995_;
        }

        public DensityFunction f_208996_() {
            return this.f_208996_;
        }

        public DensityFunction f_208997_() {
            return this.f_208997_;
        }

        @Nullable
        public TerrainShaper f_208998_() {
            return this.f_208998_;
        }

        public SplineType f_208999_() {
            return this.f_208999_;
        }

        @Override
        public double m_207402_() {
            return this.f_209000_;
        }

        @Override
        public double m_207401_() {
            return this.f_209001_;
        }

        public static final class SplineType
        extends Enum<SplineType>
        implements StringRepresentable {
            public static final /* enum */ SplineType OFFSET = new SplineType("offset", TerrainShaper::m_187311_);
            public static final /* enum */ SplineType FACTOR = new SplineType("factor", TerrainShaper::m_187334_);
            public static final /* enum */ SplineType JAGGEDNESS = new SplineType("jaggedness", TerrainShaper::m_187339_);
            private static final Map<String, SplineType> f_209047_;
            public static final Codec<SplineType> f_209046_;
            private final String f_209048_;
            final Spline f_209049_;
            private static final /* synthetic */ SplineType[] $VALUES;

            public static SplineType[] values() {
                return (SplineType[])$VALUES.clone();
            }

            public static SplineType valueOf(String p_209062_) {
                return Enum.valueOf(SplineType.class, p_209062_);
            }

            private SplineType(String p_209055_, Spline p_209056_) {
                this.f_209048_ = p_209055_;
                this.f_209049_ = p_209056_;
            }

            @Override
            public String m_7912_() {
                return this.f_209048_;
            }

            private static /* synthetic */ SplineType[] m_209057_() {
                return new SplineType[]{OFFSET, FACTOR, JAGGEDNESS};
            }

            static {
                $VALUES = SplineType.m_209057_();
                f_209047_ = Arrays.stream(SplineType.values()).collect(Collectors.toMap(SplineType::m_7912_, p_209059_ -> p_209059_));
                f_209046_ = StringRepresentable.m_14350_(SplineType::values, f_209047_::get);
            }
        }

        static interface Spline {
            public float m_209040_(TerrainShaper var1, TerrainShaper.Point var2);
        }
    }

    record Constant(double f_208607_) implements DensityFunction.SimpleFunction
    {
        static final Codec<Constant> f_208608_ = DensityFunctions.m_208275_(f_208260_, Constant::new, Constant::f_208607_);
        static final Constant f_208609_ = new Constant(0.0);

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208615_) {
            return this.f_208607_;
        }

        @Override
        public void m_207362_(double[] p_208617_, DensityFunction.ContextProvider p_208618_) {
            Arrays.fill(p_208617_, this.f_208607_);
        }

        @Override
        public double m_207402_() {
            return this.f_208607_;
        }

        @Override
        public double m_207401_() {
            return this.f_208607_;
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208608_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Constant.class, "value", "f_208607_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Constant.class, "value", "f_208607_"}, this);
        }

        @Override
        public final boolean equals(Object p_208622_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Constant.class, "value", "f_208607_"}, this, p_208622_);
        }
    }

    record YClampedGradient(int f_208481_, int f_208482_, double f_208483_, double f_208484_) implements DensityFunction.SimpleFunction
    {
        private static final MapCodec<YClampedGradient> f_208485_ = RecordCodecBuilder.mapCodec(p_208494_ -> p_208494_.group((App)Codec.intRange((int)(DimensionType.f_156653_ * 2), (int)(DimensionType.f_156652_ * 2)).fieldOf("from_y").forGetter(YClampedGradient::f_208481_), (App)Codec.intRange((int)(DimensionType.f_156653_ * 2), (int)(DimensionType.f_156652_ * 2)).fieldOf("to_y").forGetter(YClampedGradient::f_208482_), (App)f_208260_.fieldOf("from_value").forGetter(YClampedGradient::f_208483_), (App)f_208260_.fieldOf("to_value").forGetter(YClampedGradient::f_208484_)).apply((Applicative)p_208494_, YClampedGradient::new));
        public static final Codec<YClampedGradient> f_208480_ = DensityFunctions.m_208279_(f_208485_);

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208496_) {
            return Mth.m_144851_(p_208496_.m_207114_(), this.f_208481_, this.f_208482_, this.f_208483_, this.f_208484_);
        }

        @Override
        public double m_207402_() {
            return Math.min(this.f_208483_, this.f_208484_);
        }

        @Override
        public double m_207401_() {
            return Math.max(this.f_208483_, this.f_208484_);
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            return f_208480_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{YClampedGradient.class, "fromY;toY;fromValue;toValue", "f_208481_", "f_208482_", "f_208483_", "f_208484_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{YClampedGradient.class, "fromY;toY;fromValue;toValue", "f_208481_", "f_208482_", "f_208483_", "f_208484_"}, this);
        }

        @Override
        public final boolean equals(Object p_208500_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{YClampedGradient.class, "fromY;toY;fromValue;toValue", "f_208481_", "f_208482_", "f_208483_", "f_208484_"}, this, p_208500_);
        }
    }

    static final class Ap2
    extends Record
    implements TwoArgumentSimpleFunction {
        private final TwoArgumentSimpleFunction.Type f_208397_;
        private final DensityFunction f_208398_;
        private final DensityFunction f_208399_;
        private final double f_208400_;
        private final double f_208401_;

        Ap2(TwoArgumentSimpleFunction.Type f_208397_, DensityFunction f_208398_, DensityFunction f_208399_, double f_208400_, double f_208401_) {
            this.f_208397_ = f_208397_;
            this.f_208398_ = f_208398_;
            this.f_208399_ = f_208399_;
            this.f_208400_ = f_208400_;
            this.f_208401_ = f_208401_;
        }

        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208410_) {
            double $$1 = this.f_208398_.m_207386_(p_208410_);
            return switch (this.f_208397_) {
                default -> throw new IncompatibleClassChangeError();
                case TwoArgumentSimpleFunction.Type.ADD -> $$1 + this.f_208399_.m_207386_(p_208410_);
                case TwoArgumentSimpleFunction.Type.MUL -> {
                    if ($$1 == 0.0) {
                        yield 0.0;
                    }
                    yield $$1 * this.f_208399_.m_207386_(p_208410_);
                }
                case TwoArgumentSimpleFunction.Type.MIN -> {
                    if ($$1 < this.f_208399_.m_207402_()) {
                        yield $$1;
                    }
                    yield Math.min($$1, this.f_208399_.m_207386_(p_208410_));
                }
                case TwoArgumentSimpleFunction.Type.MAX -> $$1 > this.f_208399_.m_207401_() ? $$1 : Math.max($$1, this.f_208399_.m_207386_(p_208410_));
            };
        }

        @Override
        public void m_207362_(double[] p_208414_, DensityFunction.ContextProvider p_208415_) {
            this.f_208398_.m_207362_(p_208414_, p_208415_);
            switch (this.f_208397_) {
                case ADD: {
                    double[] $$2 = new double[p_208414_.length];
                    this.f_208399_.m_207362_($$2, p_208415_);
                    for (int $$3 = 0; $$3 < p_208414_.length; ++$$3) {
                        p_208414_[$$3] = p_208414_[$$3] + $$2[$$3];
                    }
                    break;
                }
                case MUL: {
                    for (int $$4 = 0; $$4 < p_208414_.length; ++$$4) {
                        double $$5 = p_208414_[$$4];
                        p_208414_[$$4] = $$5 == 0.0 ? 0.0 : $$5 * this.f_208399_.m_207386_(p_208415_.m_207263_($$4));
                    }
                    break;
                }
                case MIN: {
                    double $$6 = this.f_208399_.m_207402_();
                    for (int $$7 = 0; $$7 < p_208414_.length; ++$$7) {
                        double $$8 = p_208414_[$$7];
                        p_208414_[$$7] = $$8 < $$6 ? $$8 : Math.min($$8, this.f_208399_.m_207386_(p_208415_.m_207263_($$7)));
                    }
                    break;
                }
                case MAX: {
                    double $$9 = this.f_208399_.m_207401_();
                    for (int $$10 = 0; $$10 < p_208414_.length; ++$$10) {
                        double $$11 = p_208414_[$$10];
                        p_208414_[$$10] = $$11 > $$9 ? $$11 : Math.max($$11, this.f_208399_.m_207386_(p_208415_.m_207263_($$10)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208412_) {
            return (DensityFunction)p_208412_.apply(TwoArgumentSimpleFunction.m_209073_(this.f_208397_, this.f_208398_.m_207456_(p_208412_), this.f_208399_.m_207456_(p_208412_)));
        }

        @Override
        public double m_207402_() {
            return this.f_208400_;
        }

        @Override
        public double m_207401_() {
            return this.f_208401_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Ap2.class, "type;argument1;argument2;minValue;maxValue", "f_208397_", "f_208398_", "f_208399_", "f_208400_", "f_208401_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Ap2.class, "type;argument1;argument2;minValue;maxValue", "f_208397_", "f_208398_", "f_208399_", "f_208400_", "f_208401_"}, this);
        }

        @Override
        public final boolean equals(Object p_208418_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Ap2.class, "type;argument1;argument2;minValue;maxValue", "f_208397_", "f_208398_", "f_208399_", "f_208400_", "f_208401_"}, this, p_208418_);
        }

        @Override
        public TwoArgumentSimpleFunction.Type m_207119_() {
            return this.f_208397_;
        }

        @Override
        public DensityFunction m_207185_() {
            return this.f_208398_;
        }

        @Override
        public DensityFunction m_207190_() {
            return this.f_208399_;
        }
    }

    static final class MulOrAdd
    extends Record
    implements TwoArgumentSimpleFunction,
    PureTransformer {
        private final Type f_208746_;
        private final DensityFunction f_208747_;
        private final double f_208748_;
        private final double f_208749_;
        private final double f_208750_;

        MulOrAdd(Type f_208746_, DensityFunction f_208747_, double f_208748_, double f_208749_, double f_208750_) {
            this.f_208746_ = f_208746_;
            this.f_208747_ = f_208747_;
            this.f_208748_ = f_208748_;
            this.f_208749_ = f_208749_;
            this.f_208750_ = f_208750_;
        }

        @Override
        public TwoArgumentSimpleFunction.Type m_207119_() {
            return this.f_208746_ == Type.MUL ? TwoArgumentSimpleFunction.Type.MUL : TwoArgumentSimpleFunction.Type.ADD;
        }

        @Override
        public DensityFunction m_207185_() {
            return DensityFunctions.m_208264_(this.f_208750_);
        }

        @Override
        public DensityFunction m_207190_() {
            return this.f_208747_;
        }

        @Override
        public double m_207382_(double p_208759_) {
            return switch (this.f_208746_) {
                default -> throw new IncompatibleClassChangeError();
                case Type.MUL -> p_208759_ * this.f_208750_;
                case Type.ADD -> p_208759_ + this.f_208750_;
            };
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208761_) {
            double $$9;
            double $$8;
            DensityFunction $$1 = this.f_208747_.m_207456_(p_208761_);
            double $$2 = $$1.m_207402_();
            double $$3 = $$1.m_207401_();
            if (this.f_208746_ == Type.ADD) {
                double $$4 = $$2 + this.f_208750_;
                double $$5 = $$3 + this.f_208750_;
            } else if (this.f_208750_ >= 0.0) {
                double $$6 = $$2 * this.f_208750_;
                double $$7 = $$3 * this.f_208750_;
            } else {
                $$8 = $$3 * this.f_208750_;
                $$9 = $$2 * this.f_208750_;
            }
            return new MulOrAdd(this.f_208746_, $$1, $$8, $$9, this.f_208750_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MulOrAdd.class, "specificType;input;minValue;maxValue;argument", "f_208746_", "f_208747_", "f_208748_", "f_208749_", "f_208750_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MulOrAdd.class, "specificType;input;minValue;maxValue;argument", "f_208746_", "f_208747_", "f_208748_", "f_208749_", "f_208750_"}, this);
        }

        @Override
        public final boolean equals(Object p_208765_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MulOrAdd.class, "specificType;input;minValue;maxValue;argument", "f_208746_", "f_208747_", "f_208748_", "f_208749_", "f_208750_"}, this, p_208765_);
        }

        public Type f_208746_() {
            return this.f_208746_;
        }

        @Override
        public DensityFunction m_207305_() {
            return this.f_208747_;
        }

        @Override
        public double m_207402_() {
            return this.f_208748_;
        }

        @Override
        public double m_207401_() {
            return this.f_208749_;
        }

        public double f_208750_() {
            return this.f_208750_;
        }

        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type MUL = new Type();
            public static final /* enum */ Type ADD = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String p_208782_) {
                return Enum.valueOf(Type.class, p_208782_);
            }

            private static /* synthetic */ Type[] m_208780_() {
                return new Type[]{MUL, ADD};
            }

            static {
                $VALUES = Type.m_208780_();
            }
        }
    }

    static interface ShiftNoise
    extends DensityFunction.SimpleFunction {
        public Holder<NormalNoise.NoiseParameters> m_207183_();

        @Nullable
        public NormalNoise m_207488_();

        @Override
        default public double m_207402_() {
            return -this.m_207401_();
        }

        @Override
        default public double m_207401_() {
            NormalNoise $$0 = this.m_207488_();
            return ($$0 == null ? 2.0 : $$0.m_210630_()) * 4.0;
        }

        default public double m_208917_(double p_208918_, double p_208919_, double p_208920_) {
            NormalNoise $$3 = this.m_207488_();
            return $$3 == null ? 0.0 : $$3.m_75380_(p_208918_ * 0.25, p_208919_ * 0.25, p_208920_ * 0.25) * 4.0;
        }

        public ShiftNoise m_207360_(NormalNoise var1);
    }

    public static interface MarkerOrMarked
    extends DensityFunction {
        public Marker.Type m_207136_();

        public DensityFunction m_207056_();

        @Override
        default public Codec<? extends DensityFunction> m_207500_() {
            return this.m_207136_().f_208731_;
        }
    }

    protected record HolderHolder(Holder<DensityFunction> f_208636_) implements DensityFunction
    {
        @Override
        public double m_207386_(DensityFunction.FunctionContext p_208641_) {
            return this.f_208636_.m_203334_().m_207386_(p_208641_);
        }

        @Override
        public void m_207362_(double[] p_208645_, DensityFunction.ContextProvider p_208646_) {
            this.f_208636_.m_203334_().m_207362_(p_208645_, p_208646_);
        }

        @Override
        public DensityFunction m_207456_(DensityFunction.Visitor p_208643_) {
            return (DensityFunction)p_208643_.apply(new HolderHolder(new Holder.Direct<DensityFunction>(this.f_208636_.m_203334_().m_207456_(p_208643_))));
        }

        @Override
        public double m_207402_() {
            return this.f_208636_.m_203334_().m_207402_();
        }

        @Override
        public double m_207401_() {
            return this.f_208636_.m_203334_().m_207401_();
        }

        @Override
        public Codec<? extends DensityFunction> m_207500_() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HolderHolder.class, "function", "f_208636_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HolderHolder.class, "function", "f_208636_"}, this);
        }

        @Override
        public final boolean equals(Object p_208650_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HolderHolder.class, "function", "f_208636_"}, this, p_208650_);
        }
    }

    public static interface BeardifierOrMarker
    extends DensityFunction.SimpleFunction {
        public static final Codec<DensityFunction> f_208524_ = Codec.unit((Object)BeardifierMarker.INSTANCE);

        @Override
        default public Codec<? extends DensityFunction> m_207500_() {
            return f_208524_;
        }
    }

    static interface PureTransformer
    extends DensityFunction {
        public DensityFunction m_207305_();

        @Override
        default public double m_207386_(DensityFunction.FunctionContext p_208817_) {
            return this.m_207382_(this.m_207305_().m_207386_(p_208817_));
        }

        @Override
        default public void m_207362_(double[] p_208819_, DensityFunction.ContextProvider p_208820_) {
            this.m_207305_().m_207362_(p_208819_, p_208820_);
            for (int $$2 = 0; $$2 < p_208819_.length; ++$$2) {
                p_208819_[$$2] = this.m_207382_(p_208819_[$$2]);
            }
        }

        public double m_207382_(double var1);
    }

    static interface TransformerWithContext
    extends DensityFunction {
        public DensityFunction m_207189_();

        @Override
        default public double m_207386_(DensityFunction.FunctionContext p_209065_) {
            return this.m_207219_(p_209065_, this.m_207189_().m_207386_(p_209065_));
        }

        @Override
        default public void m_207362_(double[] p_209069_, DensityFunction.ContextProvider p_209070_) {
            this.m_207189_().m_207362_(p_209069_, p_209070_);
            for (int $$2 = 0; $$2 < p_209069_.length; ++$$2) {
                p_209069_[$$2] = this.m_207219_(p_209070_.m_207263_($$2), p_209069_[$$2]);
            }
        }

        public double m_207219_(DensityFunction.FunctionContext var1, double var2);
    }
}

