/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger f_210265_ = LogUtils.getLogger();

    public static Optional<PieceGenerator<JigsawConfiguration>> m_210284_(PieceGeneratorSupplier.Context<JigsawConfiguration> p_210285_, PieceFactory p_210286_, BlockPos p_210287_, boolean p_210288_, boolean p_210289_) {
        int $$21;
        WorldgenRandom $$5 = new WorldgenRandom(new LegacyRandomSource(0L));
        $$5.m_190068_(p_210285_.f_197354_(), p_210285_.f_197355_().f_45578_, p_210285_.f_197355_().f_45579_);
        RegistryAccess $$6 = p_210285_.f_197360_();
        JigsawConfiguration $$7 = p_210285_.f_197356_();
        ChunkGenerator $$8 = p_210285_.f_197352_();
        StructureManager $$9 = p_210285_.f_197359_();
        LevelHeightAccessor $$10 = p_210285_.f_197357_();
        Predicate<Holder<Biome>> $$11 = p_210285_.f_197358_();
        StructureFeature.m_67096_();
        Registry<StructureTemplatePool> $$12 = $$6.m_175515_(Registry.f_122884_);
        Rotation $$13 = Rotation.m_55956_($$5);
        StructureTemplatePool $$14 = $$7.m_204802_().m_203334_();
        StructurePoolElement $$15 = $$14.m_210585_($$5);
        if ($$15 == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece $$16 = p_210286_.m_210300_($$9, $$15, p_210287_, $$15.m_210540_(), $$13, $$15.m_207470_($$9, p_210287_, $$13));
        BoundingBox $$17 = $$16.m_73547_();
        int $$18 = ($$17.m_162399_() + $$17.m_162395_()) / 2;
        int $$19 = ($$17.m_162401_() + $$17.m_162398_()) / 2;
        if (p_210289_) {
            int $$20 = p_210287_.m_123342_() + $$8.m_156174_($$18, $$19, Heightmap.Types.WORLD_SURFACE_WG, $$10);
        } else {
            $$21 = p_210287_.m_123342_();
        }
        if (!$$11.test($$8.m_203495_(QuartPos.m_175400_($$18), QuartPos.m_175400_($$21), QuartPos.m_175400_($$19)))) {
            return Optional.empty();
        }
        int $$22 = $$17.m_162396_() + $$16.m_72647_();
        $$16.m_6324_(0, $$21 - $$22, 0);
        return Optional.of((p_210282_, p_210283_) -> {
            ArrayList $$15 = Lists.newArrayList();
            $$15.add($$16);
            if ($$7.m_67765_() <= 0) {
                return;
            }
            int $$16 = 80;
            AABB $$17 = new AABB($$18 - 80, $$21 - 80, $$19 - 80, $$18 + 80 + 1, $$21 + 80 + 1, $$19 + 80 + 1);
            Placer $$18 = new Placer($$12, $$7.m_67765_(), p_210286_, $$8, $$9, $$15, $$5);
            $$18.f_210321_.addLast(new PieceState($$16, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_(Shapes.m_83064_($$17), Shapes.m_83064_(AABB.m_82321_($$17)), BooleanOp.f_82685_)), 0));
            while (!$$18.f_210321_.isEmpty()) {
                PieceState $$19 = $$18.f_210321_.removeFirst();
                $$18.m_210333_($$19.f_210307_, $$19.f_210308_, $$19.f_210309_, p_210288_, $$10);
            }
            $$15.forEach(p_210282_::m_142679_);
        });
    }

    public static void m_210290_(RegistryAccess p_210291_, PoolElementStructurePiece p_210292_, int p_210293_, PieceFactory p_210294_, ChunkGenerator p_210295_, StructureManager p_210296_, List<? super PoolElementStructurePiece> p_210297_, Random p_210298_, LevelHeightAccessor p_210299_) {
        Registry<StructureTemplatePool> $$9 = p_210291_.m_175515_(Registry.f_122884_);
        Placer $$10 = new Placer($$9, p_210293_, p_210294_, p_210295_, p_210296_, p_210297_, p_210298_);
        $$10.f_210321_.addLast(new PieceState(p_210292_, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0));
        while (!$$10.f_210321_.isEmpty()) {
            PieceState $$11 = $$10.f_210321_.removeFirst();
            $$10.m_210333_($$11.f_210307_, $$11.f_210308_, $$11.f_210309_, false, p_210299_);
        }
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece m_210300_(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> f_210314_;
        private final int f_210315_;
        private final PieceFactory f_210316_;
        private final ChunkGenerator f_210317_;
        private final StructureManager f_210318_;
        private final List<? super PoolElementStructurePiece> f_210319_;
        private final Random f_210320_;
        final Deque<PieceState> f_210321_ = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> p_210323_, int p_210324_, PieceFactory p_210325_, ChunkGenerator p_210326_, StructureManager p_210327_, List<? super PoolElementStructurePiece> p_210328_, Random p_210329_) {
            this.f_210314_ = p_210323_;
            this.f_210315_ = p_210324_;
            this.f_210316_ = p_210325_;
            this.f_210317_ = p_210326_;
            this.f_210318_ = p_210327_;
            this.f_210319_ = p_210328_;
            this.f_210320_ = p_210329_;
        }

        void m_210333_(PoolElementStructurePiece p_210334_, MutableObject<VoxelShape> p_210335_, int p_210336_, boolean p_210337_, LevelHeightAccessor p_210338_) {
            StructurePoolElement $$5 = p_210334_.m_209918_();
            BlockPos $$6 = p_210334_.m_72646_();
            Rotation $$7 = p_210334_.m_6830_();
            StructureTemplatePool.Projection $$8 = $$5.m_210539_();
            boolean $$9 = $$8 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$10 = new MutableObject();
            BoundingBox $$11 = p_210334_.m_73547_();
            int $$12 = $$11.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo $$13 : $$5.m_207245_(this.f_210318_, $$6, $$7, this.f_210320_)) {
                StructurePoolElement $$27;
                MutableObject<VoxelShape> $$25;
                Direction $$14 = JigsawBlock.m_54250_($$13.f_74676_);
                BlockPos $$15 = $$13.f_74675_;
                BlockPos $$16 = $$15.m_142300_($$14);
                int $$17 = $$15.m_123342_() - $$12;
                int $$18 = -1;
                ResourceLocation $$19 = new ResourceLocation($$13.f_74677_.m_128461_("pool"));
                Optional<StructureTemplatePool> $$20 = this.f_210314_.m_6612_($$19);
                if (!$$20.isPresent() || $$20.get().m_210590_() == 0 && !Objects.equals($$19, Pools.f_127186_.m_135782_())) {
                    f_210265_.warn("Empty or non-existent pool: {}", (Object)$$19);
                    continue;
                }
                ResourceLocation $$21 = $$20.get().m_210573_();
                Optional<StructureTemplatePool> $$22 = this.f_210314_.m_6612_($$21);
                if (!$$22.isPresent() || $$22.get().m_210590_() == 0 && !Objects.equals($$21, Pools.f_127186_.m_135782_())) {
                    f_210265_.warn("Empty or non-existent fallback pool: {}", (Object)$$21);
                    continue;
                }
                boolean $$23 = $$11.m_71051_($$16);
                if ($$23) {
                    MutableObject $$24 = $$10;
                    if ($$10.getValue() == null) {
                        $$10.setValue((Object)Shapes.m_83064_(AABB.m_82321_($$11)));
                    }
                } else {
                    $$25 = p_210335_;
                }
                ArrayList $$26 = Lists.newArrayList();
                if (p_210336_ != this.f_210315_) {
                    $$26.addAll($$20.get().m_210588_(this.f_210320_));
                }
                $$26.addAll($$22.get().m_210588_(this.f_210320_));
                Iterator iterator = $$26.iterator();
                while (iterator.hasNext() && ($$27 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation $$28 : Rotation.m_55958_(this.f_210320_)) {
                        int $$32;
                        List<StructureTemplate.StructureBlockInfo> $$29 = $$27.m_207245_(this.f_210318_, BlockPos.f_121853_, $$28, this.f_210320_);
                        BoundingBox $$30 = $$27.m_207470_(this.f_210318_, BlockPos.f_121853_, $$28);
                        if (!p_210337_ || $$30.m_71057_() > 16) {
                            boolean $$31 = false;
                        } else {
                            $$32 = $$29.stream().mapToInt(p_210332_ -> {
                                if (!$$30.m_71051_(p_210332_.f_74675_.m_142300_(JigsawBlock.m_54250_(p_210332_.f_74676_)))) {
                                    return 0;
                                }
                                ResourceLocation $$2 = new ResourceLocation(p_210332_.f_74677_.m_128461_("pool"));
                                Optional<StructureTemplatePool> $$3 = this.f_210314_.m_6612_($$2);
                                Optional<Integer> $$4 = $$3.flatMap(p_210344_ -> this.f_210314_.m_6612_(p_210344_.m_210573_()));
                                int $$5 = $$3.map(p_210342_ -> p_210342_.m_210580_(this.f_210318_)).orElse(0);
                                int $$6 = $$4.map(p_210340_ -> p_210340_.m_210580_(this.f_210318_)).orElse(0);
                                return Math.max($$5, $$6);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.StructureBlockInfo $$33 : $$29) {
                            int $$54;
                            int $$50;
                            int $$43;
                            if (!JigsawBlock.m_54245_($$13, $$33)) continue;
                            BlockPos $$34 = $$33.f_74675_;
                            BlockPos $$35 = $$16.m_141950_($$34);
                            BoundingBox $$36 = $$27.m_207470_(this.f_210318_, $$35, $$28);
                            int $$37 = $$36.m_162396_();
                            StructureTemplatePool.Projection $$38 = $$27.m_210539_();
                            boolean $$39 = $$38 == StructureTemplatePool.Projection.RIGID;
                            int $$40 = $$34.m_123342_();
                            int $$41 = $$17 - $$40 + JigsawBlock.m_54250_($$13.f_74676_).m_122430_();
                            if ($$9 && $$39) {
                                int $$42 = $$12 + $$41;
                            } else {
                                if ($$18 == -1) {
                                    $$18 = this.f_210317_.m_156174_($$15.m_123341_(), $$15.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_210338_);
                                }
                                $$43 = $$18 - $$40;
                            }
                            int $$44 = $$43 - $$37;
                            BoundingBox $$45 = $$36.m_71045_(0, $$44, 0);
                            BlockPos $$46 = $$35.m_142082_(0, $$44, 0);
                            if ($$32 > 0) {
                                int $$47 = Math.max($$32 + 1, $$45.m_162400_() - $$45.m_162396_());
                                $$45.m_162371_(new BlockPos($$45.m_162395_(), $$45.m_162396_() + $$47, $$45.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)$$25.getValue(), Shapes.m_83064_(AABB.m_82321_($$45).m_82406_(0.25)), BooleanOp.f_82683_)) continue;
                            $$25.setValue((Object)Shapes.m_83148_((VoxelShape)$$25.getValue(), Shapes.m_83064_(AABB.m_82321_($$45)), BooleanOp.f_82685_));
                            int $$48 = p_210334_.m_72647_();
                            if ($$39) {
                                int $$49 = $$48 - $$41;
                            } else {
                                $$50 = $$27.m_210540_();
                            }
                            PoolElementStructurePiece $$51 = this.f_210316_.m_210300_(this.f_210318_, $$27, $$46, $$50, $$28, $$45);
                            if ($$9) {
                                int $$52 = $$12 + $$17;
                            } else if ($$39) {
                                int $$53 = $$43 + $$40;
                            } else {
                                if ($$18 == -1) {
                                    $$18 = this.f_210317_.m_156174_($$15.m_123341_(), $$15.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_210338_);
                                }
                                $$54 = $$18 + $$41 / 2;
                            }
                            p_210334_.m_209916_(new JigsawJunction($$16.m_123341_(), (int)($$54 - $$17 + $$48), $$16.m_123343_(), $$41, $$38));
                            $$51.m_209916_(new JigsawJunction($$15.m_123341_(), $$54 - $$40 + $$50, $$15.m_123343_(), -$$41, $$8));
                            this.f_210319_.add($$51);
                            if (p_210336_ + 1 > this.f_210315_) continue block0;
                            this.f_210321_.addLast(new PieceState($$51, $$25, p_210336_ + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece f_210307_;
        final MutableObject<VoxelShape> f_210308_;
        final int f_210309_;

        PieceState(PoolElementStructurePiece p_210311_, MutableObject<VoxelShape> p_210312_, int p_210313_) {
            this.f_210307_ = p_210311_;
            this.f_210308_ = p_210312_;
            this.f_210309_ = p_210313_;
        }
    }
}

