/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String f_164908_ = "icon.png";
    private static final ImmutableList<String> f_78193_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String f_202311_ = "Data";
    final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;

    public LevelStorageSource(Path p_78199_, Path p_78200_, DataFixer p_78201_) {
        this.f_78196_ = p_78201_;
        try {
            Files.createDirectories(Files.exists(p_78199_, new LinkOption[0]) ? p_78199_.toRealPath(new LinkOption[0]) : p_78199_, new FileAttribute[0]);
        }
        catch (IOException $$3) {
            throw new RuntimeException($$3);
        }
        this.f_78194_ = p_78199_;
        this.f_78195_ = p_78200_;
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), DataFixers.m_14512_());
    }

    private static <T> Pair<WorldGenSettings, Lifecycle> m_78204_(Dynamic<T> p_78205_, DataFixer p_78206_, int p_78207_) {
        Dynamic $$3 = p_78205_.get("WorldGenSettings").orElseEmptyMap();
        for (String $$4 : f_78193_) {
            Optional $$5 = p_78205_.get($$4).result();
            if (!$$5.isPresent()) continue;
            $$3 = $$3.set($$4, (Dynamic)$$5.get());
        }
        Dynamic $$6 = p_78206_.update(References.f_16795_, $$3, p_78207_, SharedConstants.m_183709_().getWorldVersion());
        DataResult $$7 = WorldGenSettings.f_64600_.parse($$6);
        return Pair.of((Object)$$7.resultOrPartial(Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseGet(() -> {
            RegistryAccess $$1 = RegistryAccess.m_206154_($$6);
            return WorldGenSettings.m_190050_($$1);
        }), (Object)$$7.lifecycle());
    }

    private static DataPackConfig m_78202_(Dynamic<?> p_78203_) {
        return DataPackConfig.f_45843_.parse(p_78203_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(DataPackConfig.f_45842_);
    }

    public String m_164909_() {
        return "Anvil";
    }

    /*
     * WARNING - void declaration
     */
    public List<LevelSummary> m_78244_() throws LevelStorageException {
        File[] $$1;
        if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
            throw new LevelStorageException(new TranslatableComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList $$0 = Lists.newArrayList();
        for (File $$2 : $$1 = this.f_78194_.toFile().listFiles()) {
            if (!$$2.isDirectory()) continue;
            try {
                boolean $$3 = DirectoryLock.m_13642_($$2.toPath());
            }
            catch (Exception $$4) {
                f_78191_.warn("Failed to read {} lock", (Object)$$2, (Object)$$4);
                continue;
            }
            try {
                void $$5;
                LevelSummary $$6 = this.m_78229_($$2, this.m_78232_($$2, (boolean)$$5));
                if ($$6 == null) continue;
                $$0.add($$6);
            }
            catch (OutOfMemoryError $$7) {
                MemoryReserve.m_182328_();
                System.gc();
                f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)$$2);
                throw $$7;
            }
            catch (StackOverflowError $$8) {
                f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)$$2);
                File $$9 = new File($$2, "level.dat");
                File $$10 = new File($$2, "level.dat_old");
                File $$11 = new File($$2, "level.dat_corrupted_" + LocalDateTime.now().format(f_78192_));
                Util.m_212224_($$9, $$10, $$11, true);
                throw $$8;
            }
        }
        return $$0;
    }

    private int m_78265_() {
        return 19133;
    }

    @Nullable
    <T> T m_78229_(File p_78230_, BiFunction<File, DataFixer, T> p_78231_) {
        T $$3;
        if (!p_78230_.exists()) {
            return null;
        }
        File $$2 = new File(p_78230_, "level.dat");
        if ($$2.exists() && ($$3 = p_78231_.apply($$2, this.f_78196_)) != null) {
            return $$3;
        }
        $$2 = new File(p_78230_, "level.dat_old");
        if ($$2.exists()) {
            return p_78231_.apply($$2, this.f_78196_);
        }
        return null;
    }

    @Nullable
    private static DataPackConfig m_78252_(File p_78253_, DataFixer p_78254_) {
        try {
            Tag $$2 = LevelStorageSource.m_202312_(p_78253_);
            if ($$2 instanceof CompoundTag) {
                CompoundTag $$3 = (CompoundTag)$$2;
                CompoundTag $$4 = $$3.m_128469_(f_202311_);
                int $$5 = $$4.m_128425_("DataVersion", 99) ? $$4.m_128451_("DataVersion") : -1;
                Dynamic $$6 = p_78254_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$4), $$5, SharedConstants.m_183709_().getWorldVersion());
                return $$6.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
            }
        }
        catch (Exception $$7) {
            f_78191_.error("Exception reading {}", (Object)p_78253_, (Object)$$7);
        }
        return null;
    }

    static BiFunction<File, DataFixer, PrimaryLevelData> m_211737_(DynamicOps<Tag> p_211738_, DataPackConfig p_211739_, Lifecycle p_211740_) {
        return (p_211745_, p_211746_) -> {
            try {
                CompoundTag $$5 = NbtIo.m_128937_(p_211745_);
                CompoundTag $$6 = $$5.m_128469_(f_202311_);
                CompoundTag $$7 = $$6.m_128425_("Player", 10) ? $$6.m_128469_("Player") : null;
                $$6.m_128473_("Player");
                int $$8 = $$6.m_128425_("DataVersion", 99) ? $$6.m_128451_("DataVersion") : -1;
                Dynamic $$9 = p_211746_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic(p_211738_, (Object)$$6), $$8, SharedConstants.m_183709_().getWorldVersion());
                Pair<WorldGenSettings, Lifecycle> $$10 = LevelStorageSource.m_78204_($$9, p_211746_, $$8);
                LevelVersion $$11 = LevelVersion.m_78390_($$9);
                LevelSettings $$12 = LevelSettings.m_46924_($$9, p_211739_);
                Lifecycle $$13 = ((Lifecycle)$$10.getSecond()).add(p_211740_);
                return PrimaryLevelData.m_78530_((Dynamic<Tag>)$$9, p_211746_, $$8, $$7, $$12, $$11, (WorldGenSettings)$$10.getFirst(), $$13);
            }
            catch (Exception $$14) {
                f_78191_.error("Exception reading {}", p_211745_, (Object)$$14);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, LevelSummary> m_78232_(File p_78233_, boolean p_78234_) {
        return (p_193015_, p_193016_) -> {
            try {
                Tag $$4 = LevelStorageSource.m_202312_(p_193015_);
                if ($$4 instanceof CompoundTag) {
                    CompoundTag $$5 = (CompoundTag)$$4;
                    CompoundTag $$6 = $$5.m_128469_(f_202311_);
                    int $$7 = $$6.m_128425_("DataVersion", 99) ? $$6.m_128451_("DataVersion") : -1;
                    Dynamic $$8 = p_193016_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$6), $$7, SharedConstants.m_183709_().getWorldVersion());
                    LevelVersion $$9 = LevelVersion.m_78390_($$8);
                    int $$10 = $$9.m_78389_();
                    if ($$10 == 19132 || $$10 == 19133) {
                        boolean $$11 = $$10 != this.m_78265_();
                        File $$12 = new File(p_78233_, f_164908_);
                        DataPackConfig $$13 = $$8.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
                        LevelSettings $$14 = LevelSettings.m_46924_($$8, $$13);
                        return new LevelSummary($$14, $$9, p_78233_.getName(), $$11, p_78234_, $$12);
                    }
                } else {
                    f_78191_.warn("Invalid root tag in {}", p_193015_);
                }
                return null;
            }
            catch (Exception $$15) {
                f_78191_.error("Exception reading {}", p_193015_, (Object)$$15);
                return null;
            }
        };
    }

    @Nullable
    private static Tag m_202312_(File p_202313_) throws IOException {
        SkipFields $$1 = new SkipFields(new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings"));
        NbtIo.m_202487_(p_202313_, $$1);
        return $$1.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path $$1 = this.f_78194_.resolve(p_78241_);
            Files.createDirectory($$1, new FileAttribute[0]);
            Files.deleteIfExists($$1);
            return true;
        }
        catch (IOException $$2) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        return Files.isDirectory(this.f_78194_.resolve(p_78256_), new LinkOption[0]);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        return new LevelStorageAccess(p_78261_);
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        final Path f_78271_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        public LevelStorageAccess(String p_78276_) throws IOException {
            this.f_78272_ = p_78276_;
            this.f_78271_ = LevelStorageSource.this.f_78194_.resolve(p_78276_);
            this.f_78270_ = DirectoryLock.m_13640_(this.f_78271_);
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, p_78303_ -> this.f_78271_.resolve(p_78303_.m_78187_()));
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, this.f_78271_);
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        @Nullable
        public LevelSummary m_78308_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.this.m_78232_(this.f_78271_.toFile(), false));
        }

        @Nullable
        public WorldData m_211747_(DynamicOps<Tag> p_211748_, DataPackConfig p_211749_, Lifecycle p_211750_) {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.m_211737_(p_211748_, p_211749_, p_211750_));
        }

        @Nullable
        public DataPackConfig m_78309_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource::m_78252_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            File $$3 = this.f_78271_.toFile();
            CompoundTag $$4 = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag $$5 = new CompoundTag();
            $$5.m_128365_(LevelStorageSource.f_202311_, $$4);
            try {
                File $$6 = File.createTempFile("level", ".dat", $$3);
                NbtIo.m_128944_($$5, $$6);
                File $$7 = new File($$3, "level.dat_old");
                File $$8 = new File($$3, "level.dat");
                Util.m_137462_($$8, $$6, $$7);
            }
            catch (Exception $$9) {
                f_78191_.error("Failed to save level {}", (Object)$$3, (Object)$$9);
            }
        }

        public Optional<Path> m_182514_() {
            if (!this.f_78270_.m_13639_()) {
                return Optional.empty();
            }
            return Optional.of(this.f_78271_.resolve(LevelStorageSource.f_164908_));
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path $$0 = this.f_78271_.resolve("session.lock");
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int $$1 = 1; $$1 <= 5; ++$$1) {
                f_78191_.info("Attempt {}...", (Object)$$1);
                try {
                    Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals($$0)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_78271_)) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists($$0);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException $$2) {
                    if ($$1 < 5) {
                        f_78191_.warn("Failed to delete {}", (Object)this.f_78271_, (Object)$$2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw $$2;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_78313_();
            File $$1 = new File(LevelStorageSource.this.f_78194_.toFile(), this.f_78272_);
            if (!$$1.exists()) {
                return;
            }
            File $$2 = new File($$1, "level.dat");
            if ($$2.exists()) {
                CompoundTag $$3 = NbtIo.m_128937_($$2);
                CompoundTag $$4 = $$3.m_128469_(LevelStorageSource.f_202311_);
                $$4.m_128359_("LevelName", p_78298_);
                NbtIo.m_128944_($$3, $$2);
            }
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String $$0 = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path $$1 = LevelStorageSource.this.m_78262_();
            try {
                Files.createDirectories(Files.exists($$1, new LinkOption[0]) ? $$1.toRealPath(new LinkOption[0]) : $$1, new FileAttribute[0]);
            }
            catch (IOException $$2) {
                throw new RuntimeException($$2);
            }
            Path $$3 = $$1.resolve(FileUtil.m_133730_($$1, $$0, ".zip"));
            try (final ZipOutputStream $$4 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream($$3, new OpenOption[0])));){
                final Path $$5 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String $$2 = $$5.resolve(LevelStorageAccess.this.f_78271_.relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry $$3 = new ZipEntry($$2);
                        $$4.putNextEntry($$3);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)$$4);
                        $$4.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size($$3);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }
    }
}

