/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.GatherComponentsExtEvent;
import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.text.DynamicColor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="legendarytooltips", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LegendaryTooltips {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static ItemStack lastTooltipItem = null;

    private static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(ItemStack item, int defaultStartBorder, int defaultEndBorder, int defaultStartBackground, int defaultEndBackground) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(item);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, () -> defaultEndBorder, () -> defaultStartBackground, () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                DynamicColor rarityColor = DynamicColor.fromRgb((int)ItemColors.getColorForItem((ItemStack)item, (TextColor)TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE)).m_131265_());
                int hue = rarityColor.hue();
                boolean addHue = false;
                if (hue >= 62 && hue <= 240) {
                    addHue = true;
                }
                int startHue = addHue ? hue - 4 : hue + 4;
                int endHue = addHue ? hue + 18 : hue - 18;
                int startBGHue = addHue ? hue - 3 : hue + 3;
                int endBGHue = addHue ? hue + 13 : hue - 13;
                startHue = (startHue + 360) % 360;
                endHue = (endHue + 360) % 360;
                startBGHue = (startBGHue + 360) % 360;
                endBGHue = (endBGHue + 360) % 360;
                DynamicColor startColor = DynamicColor.fromAHSV((int)255, (int)startHue, (int)rarityColor.saturation(), (int)rarityColor.value());
                DynamicColor endColor = DynamicColor.fromAHSV((int)255, (int)endHue, (int)rarityColor.saturation(), (int)((int)((float)rarityColor.value() * 0.95f)));
                DynamicColor startBGColor = DynamicColor.fromAHSV((int)228, (int)startBGHue, (int)((int)((float)rarityColor.saturation() * 0.9f)), (int)14);
                DynamicColor endBGColor = DynamicColor.fromAHSV((int)253, (int)endBGHue, (int)((int)((float)rarityColor.saturation() * 0.8f)), (int)18);
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> startColor.m_131265_(), () -> endColor.m_131265_(), () -> startBGColor.m_131265_(), () -> endBGColor.m_131265_(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, result.endBorder(), result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), () -> defaultEndBorder, result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.startBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), () -> defaultStartBackground, result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), result.startBackground(), () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        TooltipDecor.updateTimer();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && mc.f_91080_ instanceof AbstractContainerScreen && ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse() != null && ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_6657_() && lastTooltipItem != ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_7993_()) {
            TooltipDecor.resetTimer();
            lastTooltipItem = ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_7993_();
        }
    }

    @SubscribeEvent
    public static void onGatherComponentsEvent(RenderTooltipEvent.GatherComponents event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()).index() != -2) {
            int index = 0;
            if (event instanceof GatherComponentsExtEvent) {
                index = ((GatherComponentsExtEvent)event).getIndex();
            }
            TooltipDecor.setCachedLines(event.getTooltipElements(), index);
        }
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(event.getItemStack(), event.getBorderStart(), event.getBorderEnd(), event.getBackgroundStart(), event.getBackgroundEnd());
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        boolean comparison = false;
        if (event instanceof RenderTooltipExtEvent.Color) {
            comparison = ((RenderTooltipExtEvent.Color)event).isComparison();
        }
        if (comparison) {
            event.setBorderStart(0);
            event.setBorderEnd(0);
        } else {
            event.setBorderStart(frameDefinition.startBorder().get().intValue());
            event.setBorderEnd(frameDefinition.endBorder().get().intValue());
        }
        event.setBackgroundStart(frameDefinition.startBackground().get().intValue());
        event.setBackgroundEnd(frameDefinition.endBackground().get().intValue());
    }

    @SubscribeEvent
    public static void onPostTooltipEvent(RenderTooltipExtEvent.Post event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()).index() == -2) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            if (event.isComparison()) {
                TooltipDecor.drawShadow(event.getPoseStack(), event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11);
            } else {
                TooltipDecor.drawShadow(event.getPoseStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight());
            }
        }
        if (event.isComparison()) {
            TooltipDecor.drawBorder(event.getPoseStack(), event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11, event.getItemStack(), event.getFont(), LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()), event.isComparison(), event.getIndex());
        } else {
            TooltipDecor.drawBorder(event.getPoseStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight(), event.getItemStack(), event.getFont(), LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()), event.isComparison(), event.getIndex());
        }
    }
}

