/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;

public class PageLabelButton
extends GuiButtonCore {
    public int mPage;
    public int mPages;
    public int mColor;
    public int mHoveredPage = -1;
    private float mShowTick;

    public PageLabelButton(GuiFocusable screen, int x, int y, int width, int height, int page, int pages, int color) {
        super(screen, x, y, width, height);
        this.mColor = color;
        this.refreshPages(page, pages);
    }

    @Override
    public void drawButton(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        int pos;
        int pages = this.mPages;
        if (pages <= 0) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int dotSize = this.height;
        int dotsWidth = pages * dotSize + (pages - 1);
        int startX = this.x + (this.width - dotsWidth) / 2;
        boolean hovered = this.isMouseHovered(mouseX, mouseY);
        this.mHoveredPage = hovered ? ((pos = (int)Math.floor((float)(mouseX - startX) / ((float)dotSize + 1.0f))) < 0 || pos >= pages ? -1 : pos) : -1;
        for (int i = 0; i < pages; ++i) {
            if (i == this.mPage) {
                PageLabelButton.m_93172_((PoseStack)poseStack, (int)startX, (int)this.y, (int)(startX + dotSize), (int)(this.y + dotSize), (int)(this.mColor | 0xF0000000));
            } else if (i == this.mHoveredPage) {
                PageLabelButton.m_93172_((PoseStack)poseStack, (int)startX, (int)this.y, (int)(startX + dotSize), (int)(this.y + dotSize), (int)-1065320320);
            } else {
                int inset = dotSize / 4;
                PageLabelButton.m_93172_((PoseStack)poseStack, (int)(startX + inset), (int)(this.y + inset), (int)(startX + dotSize - inset), (int)(this.y + dotSize - inset), (int)-1065320320);
            }
            startX += dotSize + 1;
        }
        if (this.mHoveredPage != -1) {
            PageLabelButton.m_93208_((PoseStack)poseStack, (Font)this.screen.getMinecraft().f_91062_, (String)(this.mHoveredPage + 1 + " / " + pages), (int)(this.x + this.width / 2), (int)(this.y + 6), (int)this.mColor);
        } else if (this.mShowTick > 0.0f) {
            int alpha = (int)Math.min(255.0f, this.mShowTick * 24.0f);
            if (alpha > 3) {
                PageLabelButton.m_93208_((PoseStack)poseStack, (Font)this.screen.getMinecraft().f_91062_, (String)(this.mPage + 1 + " / " + pages), (int)(this.x + this.width / 2), (int)(this.y + 6), (int)(this.mColor | alpha << 24));
            }
            this.mShowTick -= deltaTicks;
        }
    }

    public void refreshPages(int page, int pages) {
        if (this.mPage != page || this.mPages != pages) {
            this.mPage = page;
            this.mPages = pages;
            this.mHoveredPage = -1;
            this.mShowTick = 20.0f;
        }
    }
}

