/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.energy.IItemEnergyBridge;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.device.TileFluxController;
import sonar.fluxnetworks.common.integration.CuriosIntegration;
import sonar.fluxnetworks.common.util.EnergyUtils;
import sonar.fluxnetworks.common.util.FluxUtils;

public class FluxControllerHandler
extends TransferHandler {
    private static final Predicate<ItemStack> NOT_EMPTY = s -> !s.m_41619_();
    private final Map<ServerPlayer, Iterable<WirelessHandler>> mPlayers = new HashMap<ServerPlayer, Iterable<WirelessHandler>>();
    private int mTimer;
    private long mDesired;
    final TileFluxController mDevice;

    public FluxControllerHandler(TileFluxController fluxController) {
        super(FluxConfig.defaultLimit);
        this.mDevice = fluxController;
    }

    @Override
    public void onCycleStart() {
        if (this.mTimer == 0) {
            this.updatePlayers();
        }
        if ((this.mTimer & 3) == 2) {
            this.mDesired = this.chargeAllItems(this.getLimit(), true);
        }
    }

    @Override
    public void onCycleEnd() {
        this.mChange = -this.sendToConsumers(Math.min(this.mBuffer, this.getLimit()));
        this.mBuffer += this.mChange;
        ++this.mTimer;
        this.mTimer &= 0x3F;
    }

    @Override
    public void addToBuffer(long energy) {
        this.mBuffer += energy;
    }

    @Override
    public long getRequest() {
        return Math.max(this.mDesired - this.mBuffer, 0L);
    }

    @Override
    public void onNetworkChanged() {
        super.onNetworkChanged();
        this.mPlayers.clear();
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.writeCustomTag(tag, type);
        tag.m_128356_("buffer", this.mBuffer);
    }

    private long sendToConsumers(long energy) {
        if ((this.mTimer & 3) != 0) {
            return 0L;
        }
        return this.chargeAllItems(energy, false);
    }

    private long chargeAllItems(long energy, boolean simulate) {
        long remaining = energy;
        for (Map.Entry<ServerPlayer, Iterable<WirelessHandler>> player : this.mPlayers.entrySet()) {
            if (!player.getKey().m_6084_()) continue;
            for (WirelessHandler handler : player.getValue()) {
                remaining = handler.chargeItems(remaining, simulate);
                if (remaining > 0L) continue;
                return energy;
            }
        }
        return energy - remaining;
    }

    private void updatePlayers() {
        this.mPlayers.clear();
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (NetworkMember p : this.mDevice.getNetwork().getAllMembers()) {
            int wirelessMode;
            FluxPlayer fluxPlayer;
            ServerPlayer player = playerList.m_11259_(p.getPlayerUUID());
            if (player == null || !player.m_6084_() || (fluxPlayer = FluxUtils.get((ICapabilityProvider)player, FluxPlayer.FLUX_PLAYER)) == null || fluxPlayer.getWirelessNetwork() != this.mDevice.getNetworkID() || !WirelessType.ENABLE_WIRELESS.isActivated(wirelessMode = fluxPlayer.getWirelessMode()) || (wirelessMode & ~(1 << WirelessType.ENABLE_WIRELESS.ordinal())) == 0) continue;
            final Inventory inventory = player.m_150109_();
            ArrayList<WirelessHandler> handlers = new ArrayList<WirelessHandler>();
            if (WirelessType.MAIN_HAND.isActivated(wirelessMode)) {
                handlers.add(new WirelessHandler(() -> new Iterator<ItemStack>(){
                    private boolean mHasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.mHasNext;
                    }

                    @Override
                    public ItemStack next() {
                        if (this.mHasNext) {
                            this.mHasNext = false;
                            return inventory.m_36056_();
                        }
                        throw new NoSuchElementException();
                    }
                }, NOT_EMPTY));
            }
            if (WirelessType.OFF_HAND.isActivated(wirelessMode)) {
                handlers.add(new WirelessHandler((Iterable<ItemStack>)inventory.f_35976_, NOT_EMPTY));
            }
            if (WirelessType.HOT_BAR.isActivated(wirelessMode)) {
                handlers.add(new WirelessHandler(inventory.f_35974_.subList(0, Inventory.m_36059_()), stack -> {
                    ItemStack heldItem;
                    return !stack.m_41619_() && ((heldItem = inventory.m_36056_()).m_41619_() || heldItem != stack);
                }));
            }
            if (WirelessType.ARMOR.isActivated(wirelessMode)) {
                handlers.add(new WirelessHandler((Iterable<ItemStack>)inventory.f_35975_, NOT_EMPTY));
            }
            if (WirelessType.CURIOS.isActivated(wirelessMode) && FluxNetworks.isCuriosLoaded()) {
                handlers.add(new WirelessHandler(CuriosIntegration.getFlatStacks(player), NOT_EMPTY));
            }
            if (handlers.isEmpty()) continue;
            this.mPlayers.put(player, handlers);
        }
    }

    private record WirelessHandler(Iterable<ItemStack> stacks, Predicate<ItemStack> validator) {
        private long chargeItems(long remaining, boolean simulate) {
            for (ItemStack stack : this.stacks) {
                IItemEnergyBridge handler;
                if (!this.validator.test(stack) || (handler = EnergyUtils.getBridge(stack)) == null || !handler.canAddEnergy(stack) || (remaining -= handler.addEnergy(remaining, stack, simulate)) > 0L) continue;
                return 0L;
            }
            return remaining;
        }
    }
}

