/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.connection.TransferHandler;

public abstract class FluxStorageHandler
extends TransferHandler {
    private long mAdded;
    private long mRemoved;

    protected FluxStorageHandler(long limit) {
        super(limit);
    }

    @Override
    public void onCycleStart() {
    }

    @Override
    public void onCycleEnd() {
        this.mChange = this.mAdded - this.mRemoved;
        this.mAdded = 0L;
        this.mRemoved = 0L;
    }

    @Override
    public void addToBuffer(long energy) {
        this.mBuffer += energy;
        this.mAdded += energy;
    }

    @Override
    public long removeFromBuffer(long energy) {
        long op = Math.min(Math.min(energy, this.mBuffer), this.getLimit() - this.mRemoved);
        assert (op >= 0L);
        this.mBuffer -= op;
        this.mRemoved += op;
        return op;
    }

    @Override
    public long getRequest() {
        return Math.max(0L, Math.min(this.getMaxEnergyStorage() - this.mBuffer, this.getLimit() - this.mAdded));
    }

    void fillUp() {
        long energy = Math.max(0L, Math.min(this.getMaxEnergyStorage() - this.mBuffer, Long.MAX_VALUE - this.mAdded));
        if (energy > 0L) {
            this.mBuffer += energy;
            this.mAdded += energy;
        }
    }

    public abstract long getMaxEnergyStorage();

    @Override
    public int getPriority() {
        return super.getPriority() - 1000000;
    }

    @Override
    public void setLimit(long limit) {
        super.setLimit(Math.min(limit, this.getMaxEnergyStorage()));
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.writeCustomTag(tag, type);
        if (type == 20) {
            tag.m_128356_("buffer", this.mBuffer);
        } else {
            tag.m_128356_("energy", this.mBuffer);
        }
    }

    @Override
    public void writePacketBuffer(@Nonnull FriendlyByteBuf buffer, byte type) {
        if (type == -2) {
            buffer.writeLong(this.mBuffer);
        } else {
            super.writePacketBuffer(buffer, type);
        }
    }

    @Override
    public void readPacketBuffer(@Nonnull FriendlyByteBuf buffer, byte type) {
        if (type == -2) {
            this.mBuffer = buffer.readLong();
        } else {
            super.readPacketBuffer(buffer, type);
        }
    }

    public static class Gargantuan
    extends FluxStorageHandler {
        public Gargantuan() {
            super(FluxConfig.gargantuanTransfer);
        }

        @Override
        public long getMaxEnergyStorage() {
            return FluxConfig.gargantuanCapacity;
        }
    }

    public static class Herculean
    extends FluxStorageHandler {
        public Herculean() {
            super(FluxConfig.herculeanTransfer);
        }

        @Override
        public long getMaxEnergyStorage() {
            return FluxConfig.herculeanCapacity;
        }
    }

    public static class Basic
    extends FluxStorageHandler {
        public Basic() {
            super(FluxConfig.basicTransfer);
        }

        @Override
        public long getMaxEnergyStorage() {
            return FluxConfig.basicCapacity;
        }
    }
}

