/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxStorage;
import sonar.fluxnetworks.common.device.FluxStorageHandler;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxGuiStack;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;
import sonar.fluxnetworks.register.RegistryBlocks;

public abstract class TileFluxStorage
extends TileFluxDevice
implements IFluxStorage {
    private final FluxStorageHandler mHandler;

    protected TileFluxStorage(@Nonnull BlockEntityType<?> type, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluxStorageHandler handler) {
        super(type, pos, state);
        this.mHandler = handler;
    }

    @Override
    public long getMaxTransferLimit() {
        return this.mHandler.getMaxEnergyStorage();
    }

    @Override
    protected void onServerTick() {
        super.onServerTick();
        if ((this.mFlags & 0x200) == 0 && this.mHandler.getChange() != 0L) {
            this.mFlags |= 0x200;
        }
        if ((this.mFlags & 0x200) == 512 && (this.f_58857_.m_46467_() & 7L) == 0L) {
            Channel.get().sendToTrackingChunk(Messages.makeDeviceBuffer(this, (byte)-2), this.f_58857_.m_46745_(this.f_58858_));
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return FluxDeviceType.STORAGE;
    }

    @Override
    @Nonnull
    public FluxStorageHandler getTransferHandler() {
        return this.mHandler;
    }

    public void fillUp() {
        this.mHandler.fillUp();
        this.mFlags |= 0x200;
    }

    @Nonnull
    protected ItemStack writeToDisplayStack(@Nonnull ItemStack stack) {
        CompoundTag subTag = stack.m_41698_("FluxData");
        if (this.f_58857_.f_46443_) {
            stack.m_41784_().m_128379_("FluxColor", true);
        } else {
            stack.m_41784_().m_128379_("FluxColor", false);
            subTag.m_128405_("clientColor", this.getNetwork().getNetworkColor());
        }
        subTag.m_128356_("energy", this.getTransferBuffer());
        return stack;
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_ENTITY, pos, state, new FluxStorageHandler.Gargantuan());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.GARGANTUAN_STORAGE);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super(RegistryBlocks.HERCULEAN_FLUX_STORAGE_ENTITY, pos, state, new FluxStorageHandler.Herculean());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.HERCULEAN_STORAGE);
        }
    }

    public static class Basic
    extends TileFluxStorage {
        public Basic(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            super(RegistryBlocks.BASIC_FLUX_STORAGE_ENTITY, pos, state, new FluxStorageHandler.Basic());
        }

        @Override
        @Nonnull
        public ItemStack getDisplayStack() {
            return this.writeToDisplayStack(FluxGuiStack.BASIC_STORAGE);
        }
    }
}

