/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration;

import icyllis.modernui.core.Core;
import icyllis.modernui.forge.MuiForgeApi;
import icyllis.modernui.forge.OpenMenuEvent;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.style.ForegroundColorSpan;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.widget.Toast;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.mui.FluxDeviceUI;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class MUIIntegration {
    public static void openMenu(@Nonnull Player player, @Nonnull MenuConstructor provider, @Nullable Consumer<FriendlyByteBuf> writer) {
        MuiForgeApi.openMenu((Player)player, (MenuConstructor)provider, writer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showToastError(@Nonnull FluxTranslate translate) {
        SpannableString text = new SpannableString((CharSequence)translate.get());
        text.setSpan((Object)new ForegroundColorSpan(-3205867), 0, text.length(), 33);
        if (Core.isOnUiThread()) {
            Toast.makeText((CharSequence)text, (int)0).show();
        } else {
            MuiForgeApi.postToUiThread(() -> Toast.makeText((CharSequence)text, (int)0).show());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void openMenu(@Nonnull OpenMenuEvent event) {
        AbstractContainerMenu abstractContainerMenu = event.getMenu();
        if (abstractContainerMenu instanceof FluxMenu) {
            FluxMenu menu = (FluxMenu)abstractContainerMenu;
            if (menu.mProvider != null) {
                FluxDeviceUI fragment = new FluxDeviceUI((TileFluxDevice)menu.mProvider);
                menu.mOnResultListener = fragment;
                DataSet args = new DataSet();
                args.putInt("token", menu.f_38840_);
                fragment.setArguments(args);
                event.set((Fragment)fragment);
            }
        }
    }
}

