/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import top.theillusivec4.polymorph.api.client.widget.OutputWidget;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;

public class SelectionWidget
extends GuiComponent
implements Widget,
GuiEventListener {
    private final Consumer<ResourceLocation> onSelect;
    private final AbstractContainerScreen<?> containerScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;

    public SelectionWidget(int pX, int pY, int pXOffset, int pYOffset, Consumer<ResourceLocation> pOnSelect, AbstractContainerScreen<?> pContainerScreen) {
        this.setPosition(pX, pY);
        this.onSelect = pOnSelect;
        this.containerScreen = pContainerScreen;
        this.xOffset = pXOffset;
        this.yOffset = pYOffset;
    }

    public void setPosition(int pX, int pY) {
        this.x = pX;
        this.y = pY;
        this.updateButtonPositions();
    }

    public void setOffsets(int pX, int pY) {
        this.xOffset = pX;
        this.yOffset = pY;
    }

    public void highlightButton(ResourceLocation pResourceLocation) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getResourceLocation().equals((Object)pResourceLocation)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<IRecipePair> pRecipeList) {
        this.outputWidgets.clear();
        pRecipeList.forEach(data -> {
            if (!data.getOutput().m_41619_()) {
                this.outputWidgets.add(new OutputWidget((IRecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean pActive) {
        this.active = pActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(PoseStack pMatrixStack, int pMouseX, int pMouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), pMatrixStack, this.hoveredButton.getTooltipText(mc.f_91080_), pMouseX, pMouseY);
        }
    }

    public void m_6305_(@Nonnull PoseStack pMatrixStack, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.isActive()) {
            int x = this.containerScreen.getGuiLeft() + this.xOffset;
            int y = this.containerScreen.getGuiTop() + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.m_6305_(pMatrixStack, pMouseX, pMouseY, pPartialTicks);
                if (button.f_93624_ && button.m_198029_()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(pMatrixStack, pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
                this.onSelect.accept(widget.getResourceLocation());
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(ItemStack pStack, PoseStack pPoseStack, List<Component> pText, int pMouseX, int pMouseY) {
        SelectionWidget.renderTooltipInternal(pStack, pPoseStack, pText, pMouseX, pMouseY, this.containerScreen, this.containerScreen.getMinecraft().f_91062_);
    }

    private static void renderTooltipInternal(@Nonnull ItemStack pStack, PoseStack pPoseStack, List<Component> pText, int pMouseX, int pMouseY, Screen pScreen, Font pFontRenderer) {
        if (!pText.isEmpty()) {
            List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)pStack, pText, (int)pMouseX, (int)pScreen.f_96543_, (int)pScreen.f_96544_, (Font)pFontRenderer, (Font)pFontRenderer);
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)pStack, (PoseStack)pPoseStack, (int)pMouseX, (int)pMouseY, (int)pScreen.f_96543_, (int)pScreen.f_96544_, (List)components, (Font)pFontRenderer, (Font)pFontRenderer);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = pText.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : components) {
                int k = clienttooltipcomponent.m_142069_(preEvent.getFont());
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.m_142103_();
            }
            int j2 = preEvent.getX() + 12;
            int k2 = preEvent.getY() - 12;
            if (j2 + i > pScreen.f_96543_) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > pScreen.f_96544_) {
                k2 = pScreen.f_96544_ - j - 6;
            }
            pPoseStack.m_85836_();
            ItemRenderer itemRenderer = pScreen.getMinecraft().m_91291_();
            float f = itemRenderer.f_115093_;
            int blitOffset = 901;
            itemRenderer.f_115093_ = blitOffset;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = pPoseStack.m_85850_().m_85861_();
            RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)pStack, (PoseStack)pPoseStack, (int)j2, (int)k2, (Font)preEvent.getFont(), (List)components);
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 - 4), (int)(j2 + i + 3), (int)(k2 - 3), (int)blitOffset, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundStart());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 + j + 3), (int)(j2 + i + 3), (int)(k2 + j + 4), (int)blitOffset, (int)colorEvent.getBackgroundEnd(), (int)colorEvent.getBackgroundEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 - 3), (int)(j2 + i + 3), (int)(k2 + j + 3), (int)blitOffset, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 4), (int)(k2 - 3), (int)(j2 - 3), (int)(k2 + j + 3), (int)blitOffset, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 + i + 3), (int)(k2 - 3), (int)(j2 + i + 4), (int)(k2 + j + 3), (int)blitOffset, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 - 3 + 1), (int)(j2 - 3 + 1), (int)(k2 + j + 3 - 1), (int)blitOffset, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 + i + 2), (int)(k2 - 3 + 1), (int)(j2 + i + 3), (int)(k2 + j + 3 - 1), (int)blitOffset, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderEnd());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 - 3), (int)(j2 + i + 3), (int)(k2 - 3 + 1), (int)blitOffset, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderStart());
            SelectionWidget.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(j2 - 3), (int)(k2 + j + 2), (int)(j2 + i + 3), (int)(k2 + j + 3), (int)blitOffset, (int)colorEvent.getBorderEnd(), (int)colorEvent.getBorderEnd());
            RenderSystem.m_69482_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            pPoseStack.m_85837_(0.0, 0.0, (double)blitOffset);
            int l1 = k2;
            for (int i2 = 0; i2 < components.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent1 = (ClientTooltipComponent)components.get(i2);
                clienttooltipcomponent1.m_142440_(preEvent.getFont(), j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.m_142103_() + (i2 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.m_109911_();
            pPoseStack.m_85849_();
            l1 = k2;
            for (int l2 = 0; l2 < components.size(); ++l2) {
                ClientTooltipComponent clienttooltipcomponent2 = (ClientTooltipComponent)components.get(l2);
                clienttooltipcomponent2.m_183452_(preEvent.getFont(), j2, l1, pPoseStack, itemRenderer, blitOffset);
                l1 += clienttooltipcomponent2.m_142103_() + (l2 == 0 ? 2 : 0);
            }
            itemRenderer.f_115093_ = f;
        }
    }
}

