/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import com.mojang.datafixers.util.Pair;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.IPolymorphPacketDistributor;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IBlockEntityRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IStackRecipeData;
import top.theillusivec4.polymorph.common.capability.PlayerRecipeData;
import top.theillusivec4.polymorph.common.capability.PolymorphCapabilities;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;
import top.theillusivec4.polymorph.common.util.BlockEntityTicker;

public class CommonEventsListener {
    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(IPlayerRecipeData.class);
        evt.register(IStackRecipeData.class);
        evt.register(IBlockEntityRecipeData.class);
    }

    @SubscribeEvent
    public void serverAboutToStart(ServerAboutToStartEvent evt) {
        PolymorphApi.common().setServer(evt.getServer());
    }

    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent evt) {
        PolymorphApi.common().setServer(null);
    }

    @SubscribeEvent
    public void openContainer(PlayerContainerEvent.Open pEvent) {
        Player player = pEvent.getPlayer();
        if (!player.f_19853_.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            AbstractContainerMenu container = pEvent.getContainer();
            IPolymorphCommon commonApi = PolymorphApi.common();
            commonApi.getRecipeDataFromTileEntity(container).ifPresent(recipeData -> {
                IPolymorphPacketDistributor packetDistributor = commonApi.getPacketDistributor();
                if (recipeData.isFailing() || recipeData.isEmpty(null)) {
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity);
                } else {
                    Pair<SortedSet<IRecipePair>, ResourceLocation> data = recipeData.getPacketData();
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity, (SortedSet)data.getFirst(), (ResourceLocation)data.getSecond());
                }
            });
            for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                if (!integration.openContainer(container, serverPlayerEntity)) continue;
                return;
            }
        }
    }

    @SubscribeEvent
    public void playerDisconnected(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntityTicker.remove(serverPlayer);
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent evt) {
        Level world = evt.world;
        if (!world.m_5776_() && evt.phase == TickEvent.Phase.END && world.m_46467_() % 5L == 0L) {
            BlockEntityTicker.tick();
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> pEvent) {
        BlockEntity be = (BlockEntity)pEvent.getObject();
        PolymorphApi.common().tryCreateRecipeData(be).ifPresent(recipeData -> {
            LazyOptional cap = LazyOptional.of(() -> recipeData);
            pEvent.addCapability(PolymorphCapabilities.BLOCK_ENTITY_RECIPE_DATA_ID, (ICapabilityProvider)new BlockEntityRecipeDataProvider((LazyOptional<IBlockEntityRecipeData>)cap));
        });
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> pEvent) {
        Entity entity = (Entity)pEvent.getObject();
        if (entity instanceof Player) {
            PlayerRecipeData data = new PlayerRecipeData((Player)entity);
            LazyOptional cap = LazyOptional.of(() -> data);
            pEvent.addCapability(PolymorphCapabilities.PLAYER_RECIPE_DATA_ID, (ICapabilityProvider)new PlayerRecipeDataProvider((LazyOptional<IPlayerRecipeData>)cap));
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesStack(AttachCapabilitiesEvent<ItemStack> pEvent) {
        ItemStack stack = (ItemStack)pEvent.getObject();
        PolymorphApi.common().tryCreateRecipeData(stack).ifPresent(recipeData -> {
            LazyOptional cap = LazyOptional.of(() -> recipeData);
            pEvent.addCapability(PolymorphCapabilities.STACK_RECIPE_DATA_ID, (ICapabilityProvider)new StackRecipeDataProvider((LazyOptional<IStackRecipeData>)cap));
        });
    }

    private static class PlayerRecipeDataProvider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IPlayerRecipeData> capability;

        public PlayerRecipeDataProvider(LazyOptional<IPlayerRecipeData> pCapability) {
            this.capability = pCapability;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.PLAYER_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag pNbt) {
            if (pNbt instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)pNbt));
            }
        }
    }

    private static class StackRecipeDataProvider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IStackRecipeData> capability;

        public StackRecipeDataProvider(LazyOptional<IStackRecipeData> pCapability) {
            this.capability = pCapability;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.STACK_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag pNbt) {
            if (pNbt instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)pNbt));
            }
        }
    }

    private static class BlockEntityRecipeDataProvider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IBlockEntityRecipeData> capability;

        public BlockEntityRecipeDataProvider(LazyOptional<IBlockEntityRecipeData> pCapability) {
            this.capability = pCapability;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
            return PolymorphCapabilities.BLOCK_ENTITY_RECIPE_DATA.orEmpty(pCapability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag pNbt) {
            if (pNbt instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)pNbt));
            }
        }
    }
}

