/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractSliderFieldBuilder;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class IntSliderBuilder
extends AbstractSliderFieldBuilder<Integer, IntegerSliderEntry, IntSliderBuilder> {
    public IntSliderBuilder(Component resetButtonKey, Component fieldNameKey, int value, int min, int max) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
        this.max = max;
        this.min = min;
    }

    @Override
    public IntSliderBuilder setErrorSupplier(Function<Integer, Optional<Component>> errorSupplier) {
        return (IntSliderBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public IntSliderBuilder requireRestart() {
        return (IntSliderBuilder)super.requireRestart();
    }

    @Override
    public IntSliderBuilder setTextGetter(Function<Integer, Component> textGetter) {
        return (IntSliderBuilder)super.setTextGetter(textGetter);
    }

    @Override
    public IntSliderBuilder setSaveConsumer(Consumer<Integer> saveConsumer) {
        return (IntSliderBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public IntSliderBuilder setDefaultValue(Supplier<Integer> defaultValue) {
        return (IntSliderBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public IntSliderBuilder setDefaultValue(int defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public IntSliderBuilder setTooltipSupplier(Function<Integer, Optional<Component[]>> tooltipSupplier) {
        return (IntSliderBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public IntSliderBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        return (IntSliderBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public IntSliderBuilder setTooltip(Optional<Component[]> tooltip) {
        return (IntSliderBuilder)super.setTooltip(tooltip);
    }

    @Override
    public IntSliderBuilder setTooltip(Component ... tooltip) {
        return (IntSliderBuilder)super.setTooltip(tooltip);
    }

    @Override
    public IntSliderBuilder setMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public IntSliderBuilder setMin(int min) {
        this.min = min;
        return this;
    }

    @Override
    public IntSliderBuilder removeMin() {
        return this;
    }

    @Override
    public IntSliderBuilder removeMax() {
        return this;
    }

    @Override
    @NotNull
    public IntegerSliderEntry build() {
        IntegerSliderEntry entry = new IntegerSliderEntry(this.getFieldNameKey(), (Integer)this.min, (Integer)this.max, (Integer)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart());
        if (this.textGetter != null) {
            entry.setTextGetter(this.textGetter);
        }
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

