/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.graveyard;

import com.finallion.graveyard.blockentities.SarcophagusBlockEntity;
import com.finallion.graveyard.blockentities.enums.SarcophagusPart;
import com.finallion.graveyard.blocks.SarcophagusBlock;
import com.finallion.graveyard.init.TGTileEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.mehvahdjukaar.every_compat.modules.graveyard.GraveyardModule;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class CompatCoffinRenderer<T extends BlockEntity>
implements BlockEntityRenderer<GraveyardModule.CompatCoffinBlockTile> {
    public static final ResourceLocation SARCOPHAGUS_FOOT = new ResourceLocation("graveyard", "block/sarcophagus_foot");
    public static final ResourceLocation SARCOPHAGUS_FOOT_LID = new ResourceLocation("graveyard", "block/sarcophagus_foot_lid");
    public static final ResourceLocation SARCOPHAGUS_HEAD_LID = new ResourceLocation("graveyard", "block/sarcophagus_head_lid");
    public static final ResourceLocation SARCOPHAGUS_HEAD = new ResourceLocation("graveyard", "block/sarcophagus_head");
    private final BakedModel sarcophagusModelHead;
    private final BakedModel sarcophagusModelFoot;
    private final BakedModel sarcophagusModelFootLid;
    private final BakedModel sarcophagusModelHeadLid;

    public CompatCoffinRenderer(BlockEntityRendererProvider.Context ctx) {
        Minecraft client = Minecraft.m_91087_();
        this.sarcophagusModelHead = client.m_91304_().getModel(SARCOPHAGUS_HEAD);
        this.sarcophagusModelFoot = client.m_91304_().getModel(SARCOPHAGUS_FOOT);
        this.sarcophagusModelFootLid = client.m_91304_().getModel(SARCOPHAGUS_FOOT_LID);
        this.sarcophagusModelHeadLid = client.m_91304_().getModel(SARCOPHAGUS_HEAD_LID);
    }

    public void render(GraveyardModule.CompatCoffinBlockTile entity, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        BlockState blockState = entity.m_58900_();
        String name = entity.m_58900_().m_60734_().m_7705_();
        boolean isCoffin = entity.isCoffin();
        DoubleBlockCombiner.NeighborCombineResult propertySource = DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)TGTileEntities.SARCOPHAGUS_BLOCK_ENTITY.get()), SarcophagusBlock::getBlockType, SarcophagusBlock::getConnectedDirection, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockState, (LevelAccessor)world, (BlockPos)entity.m_58899_(), (worldx, pos) -> false);
        float g = ((Float2FloatFunction)propertySource.m_5649_(SarcophagusBlock.opennessCombiner((LidBlockEntity)entity))).get(tickDelta);
        g = 1.0f - g;
        g = 1.0f - g * g * g;
        WoodType wood = entity.getWoodType();
        int k = ((Int2IntFunction)propertySource.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(light);
        BakedModel footLid = this.getModel(wood, isCoffin, 0);
        BakedModel headLid = this.getModel(wood, isCoffin, 1);
        BakedModel head = this.getModel(wood, isCoffin, 2);
        BakedModel foot = this.getModel(wood, isCoffin, 3);
        if (world != null) {
            if (isCoffin) {
                this.renderPart(entity, matrixStack, vertexConsumers, blockState.m_61143_((Property)SarcophagusBlock.PART) == SarcophagusPart.HEAD ? head : foot, (Direction)blockState.m_61143_((Property)SarcophagusBlock.FACING), vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false);
                this.renderLid(entity, matrixStack, vertexConsumers, blockState.m_61143_((Property)SarcophagusBlock.PART) == SarcophagusPart.HEAD ? headLid : footLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false, g);
            } else {
                this.renderPart(entity, matrixStack, vertexConsumers, blockState.m_61143_((Property)SarcophagusBlock.PART) == SarcophagusPart.HEAD ? this.sarcophagusModelHead : this.sarcophagusModelFoot, (Direction)blockState.m_61143_((Property)SarcophagusBlock.FACING), vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false);
                this.renderLid(entity, matrixStack, vertexConsumers, blockState.m_61143_((Property)SarcophagusBlock.PART) == SarcophagusPart.HEAD ? this.sarcophagusModelHeadLid : this.sarcophagusModelFootLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false, g);
            }
        } else if (isCoffin) {
            this.renderLid(entity, matrixStack, vertexConsumers, footLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, true, g);
            this.renderPart(entity, matrixStack, vertexConsumers, foot, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, true);
            this.renderLid(entity, matrixStack, vertexConsumers, headLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false, g);
            this.renderPart(entity, matrixStack, vertexConsumers, head, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false);
        } else {
            this.renderLid(entity, matrixStack, vertexConsumers, this.sarcophagusModelFootLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, true, g);
            this.renderPart(entity, matrixStack, vertexConsumers, this.sarcophagusModelFoot, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, true);
            this.renderLid(entity, matrixStack, vertexConsumers, this.sarcophagusModelHeadLid, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false, g);
            this.renderPart(entity, matrixStack, vertexConsumers, this.sarcophagusModelHead, Direction.SOUTH, vertexConsumers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)entity.m_58900_(), (boolean)true)), k, overlay, false);
        }
    }

    private void renderPart(SarcophagusBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, BakedModel model, Direction direction, VertexConsumer vertexConsumer, int light, int overlay, boolean isFoot) {
        ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
        Level world = entity.m_58904_();
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, isFoot ? -1.0 : 0.0);
        float f = ((Direction)entity.m_58900_().m_61143_((Property)SarcophagusBlock.FACING)).m_122424_().m_122435_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        matrices.m_85837_(-0.5, -0.5, -0.5);
        renderer.renderModel(matrices.m_85850_(), vertexConsumer, entity.m_58900_(), model, 1.0f, 1.0f, 1.0f, light, overlay, (IModelData)EmptyModelData.INSTANCE);
        matrices.m_85849_();
    }

    private void renderLid(SarcophagusBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, BakedModel model, Direction direction, VertexConsumer vertexConsumer, int light, int overlay, boolean isFoot, float openFactor) {
        ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
        Level world = entity.m_58904_();
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, isFoot ? -1.0 : 0.0);
        float f = ((Direction)entity.m_58900_().m_61143_((Property)SarcophagusBlock.FACING)).m_122424_().m_122435_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        matrices.m_85845_(Vector3f.f_122226_.m_122240_(openFactor * 70.0f));
        matrices.m_85837_(isFoot ? -((double)openFactor * 0.25) : (double)openFactor * 0.25, (double)openFactor * 0.25, 0.0);
        matrices.m_85837_(-0.5, -0.5, -0.5);
        renderer.renderModel(matrices.m_85850_(), vertexConsumer, entity.m_58900_(), model, 1.0f, 1.0f, 1.0f, light, overlay, (IModelData)EmptyModelData.INSTANCE);
        matrices.m_85849_();
    }

    private BakedModel getModel(WoodType w, boolean isCoffin, int part) {
        Minecraft client = Minecraft.m_91087_();
        if (isCoffin) {
            String woodType = w.getAppendableId() + "_coffin";
            return switch (part) {
                case 1 -> client.m_91304_().getModel(new ResourceLocation("everycomp", "block/gy/" + woodType + "_foot_lid"));
                case 2 -> client.m_91304_().getModel(new ResourceLocation("everycomp", "block/gy/" + woodType + "_foot"));
                case 3 -> client.m_91304_().getModel(new ResourceLocation("everycomp", "block/gy/" + woodType + "_head"));
                default -> client.m_91304_().getModel(new ResourceLocation("everycomp", "block/gy/" + woodType + "_head_lid"));
            };
        }
        return client.m_91304_().getModel(new ResourceLocation("graveyard", "block/oak_coffin_head"));
    }
}

