/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.modules.CompatModule;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.client.asset_generators.textures.Palette;
import net.mehvahdjukaar.selene.resourcepack.BlockTypeResTransformer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;

class QuarkSimpleEntrySet<T extends BlockType, B extends Block>
extends SimpleEntrySet<T, B> {
    private final BiFunction<T, QuarkModule, B> blockSupplier;
    private final Class<? extends QuarkModule> quarkModule;

    public QuarkSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Class<? extends QuarkModule> module, Supplier<B> baseBlock, Supplier<T> baseType, BiFunction<T, QuarkModule, B> blockSupplier, Supplier<CreativeModeTab> tab, boolean copyLoot, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.TileHolder<?> tileFactory, @Nullable Supplier<Supplier<RenderType>> renderType, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        super(type, name, prefix, null, baseBlock, baseType, tab, copyLoot, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform);
        this.blockSupplier = blockSupplier;
        this.quarkModule = module;
    }

    @Override
    public void registerBlocks(CompatModule module, IForgeRegistry<Block> registry, Collection<T> woodTypes) {
        Block base = (Block)this.baseBlock.get();
        if (base == null) {
            throw new UnsupportedOperationException("Base block cant be null");
        }
        ((BlockType)this.baseType.get()).addChild(module.shortenedId() + "/" + this.typeName, (ItemLike)base);
        for (BlockType w : woodTypes) {
            QuarkModule m;
            Block block;
            String n = this.getBlockName(w);
            String name = module.shortenedId() + "/" + w.getNamespace() + "/" + n;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, registry) || (block = (Block)this.blockSupplier.apply(w, m = ModuleLoader.INSTANCE.getModuleInstance(this.quarkModule))) == null) continue;
            this.blocks.put(w, block);
            registry.register((IForgeRegistryEntry)block);
            w.addChild(module.shortenedId() + "/" + this.typeName, (ItemLike)block);
        }
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, Class<? extends QuarkModule> quarkModule, Supplier<B> baseBlock, Supplier<T> baseType, BiFunction<T, QuarkModule, B> factory) {
        return new Builder<T, B>(type, name, null, quarkModule, baseType, baseBlock, factory);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> builder(Class<T> type, String name, String prefix, Class<? extends QuarkModule> quarkModule, Supplier<B> baseBlock, Supplier<T> baseType, BiFunction<T, QuarkModule, B> factory) {
        return new Builder<T, B>(type, name, prefix, quarkModule, baseType, baseBlock, factory);
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends SimpleEntrySet.Builder<T, B> {
        private final BiFunction<T, QuarkModule, B> blockSupplier;
        private final Class<? extends QuarkModule> quarkModule;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Class<? extends QuarkModule> quarkModule, Supplier<T> baseType, Supplier<B> baseBlock, BiFunction<T, QuarkModule, B> factory) {
            super(type, name, prefix, baseType, baseBlock, null);
            this.quarkModule = quarkModule;
            this.blockSupplier = factory;
        }

        @Override
        public QuarkSimpleEntrySet<T, B> build() {
            QuarkSimpleEntrySet<T, B> e = new QuarkSimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.quarkModule, this.baseBlock, this.baseType, this.blockSupplier, this.tab, this.copyLoot, this.itemFactory, this.tileFactory, this.renderType, this.palette, this.extraModelTransform);
            ((QuarkSimpleEntrySet)e).recipeLocations.addAll(this.recipes);
            ((QuarkSimpleEntrySet)e).tags.putAll(this.tags);
            ((QuarkSimpleEntrySet)e).textures.addAll(this.textures);
            return e;
        }
    }
}

