/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ItemSlotNetwork {
    private final int x;
    private final int y;
    private int size;
    private final int guiLeft;
    private final int guiTop;
    private boolean showNumbers;
    private final IGuiPrivate parent;
    private ItemStack stack;

    public ItemSlotNetwork(IGuiPrivate parent, ItemStack stack, int x, int y, int size, int guiLeft, int guiTop, boolean number) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.setShowNumbers(number);
        this.parent = parent;
        this.setStack(stack);
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.parent.isInRegion(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(PoseStack poseStack, Font font, int mx, int my) {
        if (!this.getStack().m_41619_()) {
            Object amount = Screen.m_96638_() ? "" + this.size : UtilInventory.formatLargeNumber(this.size);
            float scale = 0.85f;
            PoseStack viewModelPose = RenderSystem.m_157191_();
            viewModelPose.m_85836_();
            viewModelPose.m_85837_((double)(this.x + 3), (double)(this.y + 3), 0.0);
            viewModelPose.m_85841_(0.85f, 0.85f, 0.85f);
            viewModelPose.m_85837_((double)(-1 * this.x), (double)(-1 * this.y), 0.0);
            RenderSystem.m_157182_();
            if (this.isShowNumbers() && this.size > 1) {
                Minecraft.m_91087_().m_91291_().m_115174_(font, this.stack, this.x, this.y, (String)amount);
            }
            viewModelPose.m_85849_();
            RenderSystem.m_157182_();
            if (this.isMouseOverSlot(mx, my)) {
                int j1 = this.x;
                int k1 = this.y;
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.parent.drawGradient(poseStack, j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            Minecraft.m_91087_().m_91291_().m_115203_(this.getStack(), this.x, this.y);
        }
    }

    public void drawTooltip(PoseStack ms, int mx, int my) {
        if (this.isMouseOverSlot(mx, my) && !this.getStack().m_41619_()) {
            this.parent.renderStackTooltip(ms, this.getStack(), mx - this.parent.getGuiLeft(), my - this.parent.getGuiTopFixJei());
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private boolean isShowNumbers() {
        return this.showNumbers;
    }

    private void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }
}

