/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilterModuleCache
implements Predicate<ItemStack> {
    private boolean matchDamage = true;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private boolean modMode = false;
    private final ItemStackList stacks;
    private Set<TagKey<Item>> tags = Collections.emptySet();

    public FilterModuleCache(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            this.matchDamage = tagCompound.m_128471_("damageMode");
            this.nbtMode = tagCompound.m_128471_("nbtMode");
            this.modMode = tagCompound.m_128471_("modMode");
            this.blacklistMode = "Black".equals(tagCompound.m_128461_("blacklistMode"));
            FilterModuleInventory inventory = new FilterModuleInventory(stack);
            this.tags = new HashSet<TagKey<Item>>();
            this.stacks = ItemStackList.create();
            this.stacks.addAll(inventory.getStacks());
            this.tags.addAll(inventory.getTags());
        } else {
            this.stacks = ItemStackList.EMPTY;
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        if (!stack.m_41619_()) {
            boolean match = false;
            String modName = "";
            if (this.modMode) {
                modName = Tools.getId((ItemStack)stack).m_135827_();
            }
            if (!this.tags.isEmpty()) {
                for (TagKey tag : TagTools.getTags((Item)stack.m_41720_())) {
                    if (!this.tags.contains(tag)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                match = this.itemMatches(stack, modName);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack, String modName) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.m_41773_() != stack.m_41773_() || this.nbtMode && !ItemStack.m_41658_((ItemStack)itemStack, (ItemStack)stack) || !(this.modMode ? modName.equals(Tools.getId((ItemStack)itemStack).m_135827_()) : itemStack.m_41720_().equals(stack.m_41720_()))) continue;
                return true;
            }
        }
        return false;
    }
}

