/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.worldgen;

import mcjty.rftoolsbase.modules.worldgen.WorldGenModule;
import mcjty.rftoolsbase.modules.worldgen.config.WorldGenConfig;
import mcjty.rftoolsbase.worldgen.DimensionBiomeFilter;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class OreGenerator {
    public static final RuleTest IN_ENDSTONE = new TagMatchTest(Tags.Blocks.END_STONES);
    public static Holder<PlacedFeature> DIMENSION_SHARDS;
    public static Holder<PlacedFeature> OVERWORLD_SHARDS;
    public static Holder<PlacedFeature> NETHER_SHARDS;
    public static Holder<PlacedFeature> END_SHARDS;

    public static void registerConfiguredFeatures() {
        OreConfiguration dimensionConfig = new OreConfiguration(OreFeatures.f_195072_, ((Block)WorldGenModule.DIMENSIONAL_SHARD_OVERWORLD.get()).m_49966_(), ((Integer)WorldGenConfig.DIMENSION_ORE_VEINSIZE.get()).intValue());
        DIMENSION_SHARDS = OreGenerator.registerPlacedFeature("dimshard_dimensions", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)dimensionConfig), new PlacementModifier[]{CountPlacement.m_191628_((int)((Integer)WorldGenConfig.DIMENSION_ORE_CHANCES.get())), InSquarePlacement.m_191715_(), new DimensionBiomeFilter(id -> !id.equals((Object)Level.f_46428_)), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.DIMENSION_ORE_MINY.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.DIMENSION_ORE_MAXY.get())))});
        OreConfiguration overworldConfig = new OreConfiguration(OreFeatures.f_195072_, ((Block)WorldGenModule.DIMENSIONAL_SHARD_OVERWORLD.get()).m_49966_(), ((Integer)WorldGenConfig.OVERWORLD_ORE_VEINSIZE.get()).intValue());
        OVERWORLD_SHARDS = OreGenerator.registerPlacedFeature("dimshard_overworld", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)overworldConfig), new PlacementModifier[]{CountPlacement.m_191628_((int)((Integer)WorldGenConfig.OVERWORLD_ORE_CHANCES.get())), InSquarePlacement.m_191715_(), new DimensionBiomeFilter(id -> id.equals((Object)Level.f_46428_)), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.OVERWORLD_ORE_MINY.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.OVERWORLD_ORE_MAXY.get())))});
        OreConfiguration netherConfig = new OreConfiguration(OreFeatures.f_195075_, ((Block)WorldGenModule.DIMENSIONAL_SHARD_NETHER.get()).m_49966_(), ((Integer)WorldGenConfig.NETHER_ORE_VEINSIZE.get()).intValue());
        NETHER_SHARDS = OreGenerator.registerPlacedFeature("dimshard_nether", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)netherConfig), new PlacementModifier[]{CountPlacement.m_191628_((int)((Integer)WorldGenConfig.NETHER_ORE_CHANCES.get())), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.NETHER_ORE_MINY.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.NETHER_ORE_MAXY.get())))});
        OreConfiguration endConfig = new OreConfiguration(IN_ENDSTONE, ((Block)WorldGenModule.DIMENSIONAL_SHARD_END.get()).m_49966_(), ((Integer)WorldGenConfig.END_ORE_VEINSIZE.get()).intValue());
        END_SHARDS = OreGenerator.registerPlacedFeature("dimshard_end", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)endConfig), new PlacementModifier[]{CountPlacement.m_191628_((int)((Integer)WorldGenConfig.END_ORE_CHANCES.get())), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.END_ORE_MINY.get())), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)WorldGenConfig.END_ORE_MAXY.get())))});
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> Holder<PlacedFeature> registerPlacedFeature(String registryName, ConfiguredFeature<C, F> feature, PlacementModifier ... placementModifiers) {
        return PlacementUtils.m_206513_((String)registryName, (Holder)Holder.m_205709_(feature), (PlacementModifier[])placementModifiers);
    }

    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.BiomeCategory.NETHER) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, NETHER_SHARDS);
        } else if (event.getCategory() == Biome.BiomeCategory.THEEND) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, END_SHARDS);
        } else {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OVERWORLD_SHARDS);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, DIMENSION_SHARDS);
        }
    }
}

