/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopyNbtRecipe
extends CustomRecipe {
    private final Ingredient sourceIngredient;
    private final Ingredient targetIngredient;
    private final List<String> tags;

    public CopyNbtRecipe(ResourceLocation recipeID, Ingredient sourceIngredient, Ingredient targetIngredient, List<String> tags) {
        super(recipeID);
        this.sourceIngredient = sourceIngredient;
        this.targetIngredient = targetIngredient;
        this.tags = tags;
    }

    public Pair<ItemStack, List<ItemStack>> getResult(CraftingContainer inv) {
        ItemStack source = null;
        ArrayList<ItemStack> toCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            boolean matchesSource = this.sourceIngredient.test(stack);
            boolean matchesTarget = this.targetIngredient.test(stack);
            if (!matchesSource && !matchesTarget) {
                return new Pair(null, new ArrayList());
            }
            if (matchesSource && source == null && stack.m_41782_()) {
                source = stack;
                continue;
            }
            if (matchesTarget && !stack.m_41782_()) {
                toCopy.add(stack);
                continue;
            }
            return new Pair(null, new ArrayList());
        }
        return new Pair(source, toCopy);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null || result.getValue().isEmpty()) {
            return false;
        }
        return result.getValue().size() == 1 || result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()));
    }

    public ItemStack assemble(CraftingContainer inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return ItemStack.f_41583_;
        }
        if (result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()))) {
            ItemStack res = result.getKey().m_41777_();
            res.m_41764_(1 + result.getValue().size());
            return res;
        }
        if (result.getValue().size() == 1) {
            ItemStack stack2 = result.getValue().get(0).m_41777_();
            stack2.m_41764_(1);
            CompoundTag tag = result.getKey().m_41783_();
            CompoundTag copy = new CompoundTag();
            for (String s : this.tags) {
                Tag element = this.getPath(s, tag);
                if (element == null) continue;
                this.setPath(s, copy, element);
            }
            stack2.m_41751_(copy);
            return stack2;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    private Tag getPath(String path, CompoundTag tag) {
        String[] p = path.split("\\.");
        CompoundTag c = tag;
        for (int i = 0; i < p.length - 1; ++i) {
            if (!c.m_128425_(p[i], 10)) {
                return null;
            }
            c = c.m_128469_(p[i]);
        }
        return c.m_128423_(p[p.length - 1]);
    }

    private void setPath(String path, CompoundTag tag, Tag element) {
        String[] p = path.split("\\.");
        CompoundTag c = tag;
        for (int i = 0; i < p.length - 1; ++i) {
            if (c.m_128425_(p[i], 10)) {
                c = c.m_128469_(p[i]);
                continue;
            }
            CompoundTag newTag = new CompoundTag();
            c.m_128365_(p[i], (Tag)newTag);
            c = newTag;
        }
        c.m_128365_(p[p.length - 1], element);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return super.m_7457_((Container)inv);
        }
        if (result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()))) {
            return super.m_7457_((Container)inv);
        }
        if (result.getValue().size() == 1) {
            NonNullList res = super.m_7457_((Container)inv);
            for (int i = 0; i < inv.m_6643_(); ++i) {
                if (!inv.m_8020_(i).equals(result.getKey())) continue;
                ItemStack r = result.getKey().m_41777_();
                r.m_41764_(1);
                res.set(i, (Object)r);
                break;
            }
            return res;
        }
        return super.m_7457_((Container)inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COPY_NBT;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CopyNbtRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("pipez", "copy_nbt");

        public CopyNbtRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ArrayList<String> tags = new ArrayList<String>();
            if (json.has("tags")) {
                JsonArray tagArray = json.get("tags").getAsJsonArray();
                for (int i = 0; i < tagArray.size(); ++i) {
                    tags.add(tagArray.get(i).getAsString());
                }
            }
            return new CopyNbtRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.get("source")), Ingredient.m_43917_((JsonElement)json.get("target")), tags);
        }

        public CopyNbtRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ArrayList<String> tags = new ArrayList<String>();
            int tagSize = buffer.m_130242_();
            for (int i = 0; i < tagSize; ++i) {
                tags.add(buffer.m_130277_());
            }
            return new CopyNbtRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), tags);
        }

        public void toNetwork(FriendlyByteBuf buffer, CopyNbtRecipe recipe) {
            buffer.m_130130_(recipe.tags.size());
            for (String s : recipe.tags) {
                buffer.m_130070_(s);
            }
            recipe.sourceIngredient.m_43923_(buffer);
            recipe.targetIngredient.m_43923_(buffer);
        }
    }
}

