/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common;

import com.direwolf20.mininggadgets.client.ClientEvents;
import com.direwolf20.mininggadgets.client.ClientSetup;
import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.containers.ModContainers;
import com.direwolf20.mininggadgets.common.events.ServerTickHandler;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.ModItems;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mininggadgets")
public class MiningGadgets {
    public static final String MOD_ID = "mininggadgets";
    private static final Logger LOGGER = LogManager.getLogger();
    public static CreativeModeTab itemGroup = new CreativeModeTab("mininggadgets"){

        public ItemStack m_6976_() {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.MININGGADGET.get());
            itemStack.m_41784_().m_128405_("energy", Integer.MAX_VALUE);
            return itemStack;
        }
    };

    public MiningGadgets() {
        IEventBus event = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(event);
        ModItems.UPGRADE_ITEMS.register(event);
        ModBlocks.BLOCKS.register(event);
        ModBlocks.TILES_ENTITIES.register(event);
        ModContainers.CONTAINERS.register(event);
        event.addListener(this::setup);
        event.addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        event.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mininggadgets-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mininggadgets-common.toml"));
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = MiningGadget.getGadget(event.getPlayer());
        if (stack.m_41720_() instanceof MiningGadget && (this.stackIsAnnoying(event.getPlayer().m_21205_()) || this.stackIsAnnoying(event.getPlayer().m_21206_()) || event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof RedStoneOreBlock)) {
            event.setCanceled(true);
        }
    }

    private boolean stackIsAnnoying(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)stack.m_41720_()).m_40614_();
        return block instanceof TorchBlock || block instanceof LanternBlock || block.equals(Blocks.f_50141_) || block instanceof RedstoneLampBlock || block instanceof EndRodBlock;
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        MinecraftForge.EVENT_BUS.register(ServerTickHandler.class);
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientSetup.setup();
        OurKeys.register();
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

