/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketChangeVolume {
    private float volume;

    public PacketChangeVolume(float volume) {
        this.volume = volume;
    }

    public static void encode(PacketChangeVolume msg, FriendlyByteBuf buffer) {
        buffer.writeFloat(msg.volume);
    }

    public static PacketChangeVolume decode(FriendlyByteBuf buffer) {
        return new PacketChangeVolume(buffer.readFloat());
    }

    public static class Handler {
        public static void handle(PacketChangeVolume msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = MiningGadget.getGadget((Player)player);
                MiningProperties.setVolume(stack, msg.volume);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

