/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Objects;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.dynamictrees.DynamicTreesCompat;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class FlowerBoxBlockTile
extends ItemDisplayTile
implements IBlockHolder {
    public static final ModelProperty<BlockState> FLOWER_0 = new ModelProperty();
    public static final ModelProperty<BlockState> FLOWER_1 = new ModelProperty();
    public static final ModelProperty<BlockState> FLOWER_2 = new ModelProperty();
    private final BlockState[] flowerStates = new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_()};

    public FlowerBoxBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLOWER_BOX_TILE.get(), pos, state, 3);
    }

    @Override
    public BlockState getHeldBlock(int index) {
        return this.flowerStates[index];
    }

    @Override
    public boolean setHeldBlock(BlockState state, int index) {
        if (index >= 0 && index < 3) {
            this.flowerStates[index] = state;
        }
        return false;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FLOWER_0, (Object)this.flowerStates[0]).withInitial(FLOWER_1, (Object)this.flowerStates[1]).withInitial(FLOWER_2, (Object)this.flowerStates[2]).build();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic0 = this.flowerStates[0];
        BlockState oldMimic1 = this.flowerStates[1];
        BlockState oldMimic2 = this.flowerStates[2];
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (!(Objects.equals(oldMimic0, this.flowerStates[0]) && Objects.equals(oldMimic1, this.flowerStates[1]) && Objects.equals(oldMimic2, this.flowerStates[2]))) {
            ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82386_(0.0, 0.25, 0.0);
    }

    public void updateClientVisualsOnLoad() {
        for (int n = 0; n < this.flowerStates.length; ++n) {
            Item item2 = this.m_8020_(n).m_41720_();
            Block b = null;
            if (item2 instanceof BlockItem) {
                b = ((BlockItem)item2).m_40614_();
            } else if (CompatHandler.dynamictrees) {
                b = DynamicTreesCompat.getOptionalDynamicSapling(item2, this.f_58857_, this.f_58858_);
            }
            if (b == null) {
                b = Blocks.f_50016_;
            }
            this.flowerStates[n] = b.m_49966_();
        }
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public Component m_6820_() {
        return new TranslatableComponent("block.supplementaries.flower_box");
    }

    public float getYaw() {
        return -this.getDirection().m_122424_().m_122435_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ItemShelfBlock.FACING);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.m_8020_(index).m_41619_()) {
            return stack.m_204117_(ModTags.FLOWER_BOX_PLANTABLE) || FlowerPotHandler.hasSpecialFlowerModel(stack.m_41720_());
        }
        return false;
    }
}

