/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.client.QuiverArrowSelectGui;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.ConfigButton;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.quark.QuarkTooltipPlugin;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="supplementaries", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    private static float partialTicks;
    private static double wobble;
    private static boolean isOnRope;

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getPlayer() != null) {
            Item item2;
            event.getPlayer();
            if (ClientConfigs.cached.TOOLTIP_HINTS && event.getFlags().m_7050_()) {
                ItemsOverrideHandler.addOverrideTooltips(event);
            }
            if (CompatHandler.quark) {
                QuarkTooltipPlugin.onItemTooltipEvent(event);
            }
            if ((item2 = event.getItemStack().m_41720_()) == ModRegistry.ROPE_ARROW_ITEM.get() || item2 == ModRegistry.BUBBLE_BLOWER.get()) {
                List tooltip = event.getToolTip();
                Optional<Component> r = tooltip.stream().filter(t -> {
                    TranslatableComponent component;
                    return t instanceof TranslatableComponent && (component = (TranslatableComponent)t).m_131328_().equals("item.durability");
                }).findFirst();
                r.ifPresent(tooltip::remove);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiInit(ScreenEvent.InitScreenEvent event) {
        if (ClientConfigs.cached.CONFIG_BUTTON && CompatHandler.configured) {
            ConfigButton.setupConfigButton(event);
        }
    }

    public static float getPartialTicks() {
        return partialTicks;
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            CapturedMobCache.tickCrystal();
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p != null) {
                BlockState state = p.m_146900_();
                isOnRope = (p.m_20185_() != p.f_19790_ || p.m_20189_() != p.f_19792_) && state.m_60713_((Block)ModRegistry.ROPE.get()) && (Boolean)state.m_61143_((Property)RopeBlock.UP) == false && (p.m_20186_() + 500.0) % 1.0 >= RopeBlock.COLLISION_SHAPE.m_83297_(Direction.Axis.Y);
            }
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null && !Minecraft.m_91087_().m_91104_() && (isOnRope || wobble != 0.0)) {
            double period = ClientConfigs.cached.ROPE_WOBBLE_PERIOD;
            double newWobble = ((double)p.f_19797_ + event.getPartialTicks()) / period % 1.0;
            wobble = !isOnRope && newWobble < wobble ? 0.0 : newWobble;
            event.setRoll(event.getRoll() + Mth.m_14031_((float)((float)(wobble * 2.0 * Math.PI))) * ClientConfigs.cached.ROPE_WOBBLE_AMPLITUDE);
        }
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollEvent event) {
        if (QuiverArrowSelectGui.isActive() && QuiverArrowSelectGui.onMouseScrolled(event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(WorldEvent.Unload unload) {
        if (unload.getWorld().m_5776_()) {
            CapturedMobCache.unloadLevel();
        }
    }
}

