/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation.structure;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class WaySignStructure
extends StructureFeature<JigsawConfiguration> {
    public WaySignStructure() {
        super(JigsawConfiguration.f_67756_, WaySignStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.STRONGHOLDS;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!WaySignStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator generator = context.f_197352_();
        LevelHeightAccessor levelHeight = context.f_197357_();
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        int sum = 0;
        sum += generator.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x + 2, z + 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x + 2, z - 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        sum += generator.m_156179_(x - 2, z + 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight);
        int y = Math.round((float)(sum += generator.m_156179_(x - 2, z - 2, Heightmap.Types.WORLD_SURFACE_WG, levelHeight)) / 5.0f);
        BlockPos blockpos = new BlockPos(x, y + 1, z);
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }

    private static boolean isPosNotValid(ChunkGenerator gen, int x, int z, Set<Integer> heightMap, LevelHeightAccessor heightLimitView) {
        int y = gen.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        NoiseColumn noisecolumn = gen.m_141914_(x, z, heightLimitView);
        BlockState state = noisecolumn.m_183556_(y);
        try {
            if (state.m_60819_().m_76178_()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator generator = context.f_197352_();
        LevelHeightAccessor heightLimitView = context.f_197357_();
        boolean hasVillages = generator.m_207969_().anyMatch(f -> {
            for (StructureSet.StructureSelectionEntry s : ((StructureSet)f.m_203334_()).f_210003_()) {
                if (!s.f_210026_().m_203656_(ModTags.WAY_SIGN_DESTINATIONS)) continue;
                return true;
            }
            return false;
        });
        if (!hasVillages) {
            return false;
        }
        BlockPos blockPos = chunkPos.m_45615_();
        int x = blockPos.m_123341_();
        int z = blockPos.m_123343_();
        int y = generator.m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        if (y > 105 || y < generator.m_6337_()) {
            return false;
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(y);
        if (WaySignStructure.isPosNotValid(generator, x + 2, z + 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x + 2, z - 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z + 2, set, heightLimitView)) {
            return false;
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z - 2, set, heightLimitView)) {
            return false;
        }
        if (set.last() - set.first() > 1) {
            return false;
        }
        return !context.f_197352_().m_212265_(BuiltinStructureSets.f_209825_, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, 10);
    }
}

