/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import java.util.Objects;
import java.util.UUID;
import me.lucko.spark.common.command.sender.AbstractCommandSender;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import me.lucko.spark.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.world.entity.player.Player;

public class ForgeCommandSender
extends AbstractCommandSender<CommandSource> {
    private final ForgeSparkPlugin plugin;

    public ForgeCommandSender(CommandSource source, ForgeSparkPlugin plugin) {
        super(source);
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        if (this.delegate instanceof Player) {
            return ((Player)this.delegate).m_36316_().getName();
        }
        if (this.delegate instanceof MinecraftServer) {
            return "Console";
        }
        if (this.delegate instanceof RconConsoleSource) {
            return "RCON Console";
        }
        return "unknown:" + ((CommandSource)this.delegate).getClass().getSimpleName();
    }

    @Override
    public UUID getUniqueId() {
        if (this.delegate instanceof Player) {
            return ((Player)this.delegate).m_142081_();
        }
        return null;
    }

    @Override
    public void sendMessage(me.lucko.spark.lib.adventure.text.Component message) {
        MutableComponent component = Component.Serializer.m_130701_((String)((String)GsonComponentSerializer.gson().serialize(message)));
        Objects.requireNonNull(component, "component");
        ((CommandSource)this.delegate).m_6352_((Component)component, Util.f_137441_);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.plugin.hasPermission((CommandSource)this.delegate, permission);
    }
}

