/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.TransientEntitySectionManager;

public abstract class ForgeWorldInfoProvider
implements WorldInfoProvider {
    protected List<ForgeChunkInfo> getChunksFromCache(EntitySectionStorage<Entity> cache) {
        LongSet loadedChunks = cache.m_156857_();
        ArrayList<ForgeChunkInfo> list = new ArrayList<ForgeChunkInfo>(loadedChunks.size());
        LongIterator iterator = loadedChunks.iterator();
        while (iterator.hasNext()) {
            long chunkPos = iterator.nextLong();
            Stream sections = cache.m_156888_(chunkPos);
            list.add(new ForgeChunkInfo(chunkPos, sections));
        }
        return list;
    }

    static final class ForgeChunkInfo
    extends AbstractChunkInfo<EntityType<?>> {
        private final CountMap<EntityType<?>> entityCounts = new CountMap.Simple(new HashMap());

        ForgeChunkInfo(long chunkPos, Stream<EntitySection<Entity>> entities) {
            super(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
            entities.forEach(section -> {
                if (section.m_156848_().m_157694_()) {
                    section.m_156845_().forEach(entity -> this.entityCounts.increment(entity.m_6095_()));
                }
            });
        }

        @Override
        public CountMap<EntityType<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType<?> type) {
            return EntityType.m_20613_(type).toString();
        }
    }

    public static final class Client
    extends ForgeWorldInfoProvider {
        private final Minecraft client;

        public Client(Minecraft client) {
            this.client = client;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            ClientLevel level = this.client.f_91073_;
            if (level == null) {
                return null;
            }
            TransientEntitySectionManager entityManager = level.f_171631_;
            EntityLookup entityIndex = entityManager.f_157637_;
            int entities = entityIndex.m_156821_();
            int chunks = level.m_7726_().m_142061_();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            ClientLevel level = this.client.f_91073_;
            if (level == null) {
                return null;
            }
            TransientEntitySectionManager entityManager = level.f_171631_;
            EntitySectionStorage cache = entityManager.f_157638_;
            List<ForgeChunkInfo> list = this.getChunksFromCache((EntitySectionStorage<Entity>)cache);
            data.put(level.m_46472_().m_135782_().m_135815_(), list);
            return data;
        }
    }

    public static final class Server
    extends ForgeWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.m_7416_();
            int entities = 0;
            int chunks = 0;
            for (ServerLevel level : this.server.m_129785_()) {
                PersistentEntitySectionManager entityManager = level.f_143244_;
                EntityLookup entityIndex = entityManager.f_157494_;
                entities += entityIndex.m_156821_();
                chunks += level.m_7726_().m_142061_();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            for (ServerLevel level : this.server.m_129785_()) {
                PersistentEntitySectionManager entityManager = level.f_143244_;
                EntitySectionStorage cache = entityManager.f_157495_;
                List<ForgeChunkInfo> list = this.getChunksFromCache((EntitySectionStorage<Entity>)cache);
                data.put(level.m_46472_().m_135782_().m_135815_(), list);
            }
            return data;
        }
    }
}

