/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class DropdownButton<E extends IDropdownOption>
extends Button {
    public boolean dropdownOpen;
    private E selected;
    private List<E> possibleVals;
    private Component baseButtonText;
    private final boolean dynamic;
    private final boolean drawHeader;
    public boolean wasJustClosed = false;
    private Button.OnPress ourOnPress;
    Minecraft minecraft = Minecraft.m_91087_();
    public boolean flipped = false;

    public DropdownButton(int x, int y, int widthIn, int heightIn, Component buttonText, E def, boolean dynamic, Button.OnPress onPress, boolean drawHeader) {
        super(x, y, widthIn, heightIn, buttonText, e -> {});
        this.ourOnPress = onPress;
        this.selected = def;
        this.possibleVals = def.getPossibleVals();
        this.baseButtonText = buttonText;
        this.dynamic = dynamic;
        this.drawHeader = drawHeader;
    }

    public DropdownButton(int x, int y, int widthIn, int heightIn, Component buttonText, E def, boolean dynamic, Button.OnPress onPress) {
        this(x, y, widthIn, heightIn, buttonText, def, dynamic, onPress, true);
    }

    public DropdownButton(int x, int y, Component buttonText, E def, boolean dynamic, Button.OnPress onPress) {
        this(x, y, 200, 20, buttonText, def, dynamic, onPress);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            int drawY = this.f_93621_;
            Font fontrenderer = this.minecraft.f_91062_;
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= drawY && mouseX < this.f_93620_ + this.f_93618_ && mouseY < drawY + this.f_93619_;
            int i = this.getHoverState(this.f_93622_);
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (this.drawHeader) {
                this.m_93228_(matrixStack, this.f_93620_, drawY, 0, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
                this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_ / 2, drawY, 200 - this.f_93618_ / 2, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
                int j = 0xE0E0E0;
                if (!this.f_93623_) {
                    j = 0xA0A0A0;
                } else if (this.f_93622_) {
                    j = 0xFFFFA0;
                }
                DropdownButton.m_93215_((PoseStack)matrixStack, (Font)fontrenderer, (Component)this.baseButtonText, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)j);
            }
            if (this.dropdownOpen) {
                ++drawY;
                int yOffset = this.f_93619_ - 2;
                if (this.flipped) {
                    yOffset = -yOffset;
                    --drawY;
                }
                int possibleValsSize = this.possibleVals.size();
                for (int j = 0; j < possibleValsSize; ++j) {
                    IDropdownOption e = (IDropdownOption)this.possibleVals.get(j);
                    boolean ourHovered = mouseX >= this.f_93620_ && mouseY >= (drawY += yOffset) && mouseX < this.f_93620_ + this.f_93618_ && mouseY < drawY + this.f_93619_ - 2;
                    int subHovered = ourHovered ? 2 : 0;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.m_93228_(matrixStack, this.f_93620_, drawY, 0, 46 + subHovered * 20 + 1, this.f_93618_ / 2, this.f_93619_ - 1);
                    this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_ / 2, drawY, 200 - this.f_93618_ / 2, 46 + subHovered * 20 + 1, this.f_93618_ / 2, this.f_93619_ - 1);
                    String name = I18n.m_118938_((String)e.getTranslate((IDropdownOption)this.selected, true), (Object[])new Object[0]);
                    int textColour = 0xE0E0E0;
                    DropdownButton.m_93208_((PoseStack)matrixStack, (Font)fontrenderer, (String)name, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(drawY + (this.f_93619_ - 10) / 2), (int)textColour);
                }
            }
        }
    }

    protected int getHoverState(boolean mouseOver) {
        return mouseOver ? 2 : (this.f_93623_ ? (this.dropdownOpen ? 2 : 1) : 0);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean pressed = super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.dropdownOpen) {
            if (this.drawHeader && pressed) {
                this.close();
                return false;
            }
            E clickedElement = this.getClickedElement(p_mouseClicked_1_, p_mouseClicked_3_);
            if (clickedElement != null) {
                this.setSelected(clickedElement);
                try {
                    this.ourOnPress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed && this.drawHeader) {
            this.dropdownOpen = true;
            if (this.dynamic) {
                this.selected.updateDynamic();
                this.possibleVals = this.selected.getPossibleVals();
            }
        }
        return false;
    }

    public void ourOnPress() {
        this.ourOnPress.m_93750_((Button)this);
    }

    public void m_5691_() {
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        try {
            this.selected = selected;
            this.updateDisplayString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDisplayString() {
        this.baseButtonText = new TranslatableComponent(I18n.m_118938_((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[0]), new Object[]{this.baseButtonText});
    }

    private E getClickedElement(double mouseX, double mouseY) {
        IDropdownOption clickedElement = null;
        int y = this.f_93621_ + 1;
        int yOffset = this.f_93619_ - 2;
        if (this.flipped) {
            yOffset = -yOffset;
            --y;
        }
        for (IDropdownOption e : this.possibleVals) {
            y += yOffset;
            if (!(mouseX >= (double)this.f_93620_) || !(mouseY >= (double)y) || !(mouseX < (double)(this.f_93620_ + this.f_93618_)) || !(mouseY < (double)(y + this.f_93619_ - 2))) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public List<E> getPossibleVals() {
        return this.possibleVals;
    }

    public static interface IDropdownOption {
        public List<IDropdownOption> getPossibleVals();

        public String getTranslate(IDropdownOption var1, boolean var2);

        default public void updateDynamic() {
        }
    }
}

