/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dmillerw.ping.client.KeyHandler;
import dmillerw.ping.data.PingType;
import dmillerw.ping.data.PingWrapper;
import dmillerw.ping.network.PacketHandler;
import dmillerw.ping.network.packet.ClientSendPing;
import dmillerw.ping.util.Config;
import java.awt.Color;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ping", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    @Nullable
    private static ShaderInstance rendertypePing;

    public static ShaderInstance getRenderTypePing() {
        return Objects.requireNonNull(rendertypePing, "Attempted to call getRenderTypePing before shaders have finished loading.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendPing(PingType type) {
        BlockHitResult raytraceBlock = ClientHandler.raytrace((Player)Minecraft.m_91087_().f_91074_, 50.0);
        if (raytraceBlock.m_6662_() == HitResult.Type.BLOCK) {
            ClientHandler.sendPing(raytraceBlock, new Color((Integer)Config.VISUAL.pingR.get(), (Integer)Config.VISUAL.pingG.get(), (Integer)Config.VISUAL.pingB.get()).getRGB(), type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendPing(BlockHitResult raytrace, int color, PingType type) {
        PacketHandler.CHANNEL.sendToServer((Object)new ClientSendPing(new PingWrapper(raytrace.m_82425_(), color, type)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BlockHitResult raytrace(Player player, double distance) {
        float eyeHeight = player.m_20192_();
        return (BlockHitResult)player.m_19907_(distance, eyeHeight, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerKeybinds() {
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.KEY_BINDING);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.PING_ALERT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.PING_MINE);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.PING_LOOK);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyHandler.PING_GOTO);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("ping", "rendertype_ping"), DefaultVertexFormat.f_85819_), p_172645_ -> {
            rendertypePing = p_172645_;
        });
    }
}

